/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.app;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import jp.oarts.pirka.core.kernel.PirkaUploadManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReqParser
implements Serializable {
    private static final String MULTIPPART_STRING = "multipart/form-data";
    private static final String CONTENT_DISPOSITION_HEAD = "content-disposition:";

    public static void parser(HttpServletRequest req, Map<String, String[]> reqMap, List<Long> fileNoList) throws IOException {
        String contentType = req.getContentType();
        if (contentType != null && contentType.toLowerCase().indexOf(MULTIPPART_STRING) >= 0) {
            ReqParser.multipartParser((InputStream)req.getInputStream(), reqMap, fileNoList);
        } else {
            ReqParser.singleParser(req, reqMap);
        }
    }

    private static void singleParser(HttpServletRequest req, Map<String, String[]> reqMap) throws IOException {
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            name = ReqParser.convertKanji(name);
            String[] values = req.getParameterValues(name);
            int i = 0;
            while (i < values.length) {
                values[i] = ReqParser.convertKanji(values[i]);
                ++i;
            }
            reqMap.put(name, values);
        }
    }

    private static void multipartParser(InputStream sis, Map<String, String[]> reqMap, List<Long> fileNoList) throws IOException {
        HashMap<String, List> paramMap = new HashMap<String, List>();
        BufferedOutputStream bos = null;
        byte[] tempBuff = new byte[1024];
        byte[] tempValue = new byte[256];
        int tempValueOffset = 0;
        boolean bFileOut = false;
        long fileNo = 0L;
        try {
            try {
                byte[] boundaryTemp = ReqParser.readByteLine(sis, tempBuff);
                if (boundaryTemp.length <= 0) {
                    throw new EOFException("\u7d42\u7aef\u6587\u5b57\u30d1\u30bf\u30fc\u30f3\u7121\u3057");
                }
                byte[] boundary = new byte[boundaryTemp.length + 2];
                System.arraycopy(boundaryTemp, 0, boundary, 2, boundaryTemp.length);
                boundary[0] = 13;
                boundary[1] = 10;
                while (true) {
                    bFileOut = false;
                    String contentDisposition = ReqParser.readStringLine(sis, tempBuff);
                    if (contentDisposition.length() <= CONTENT_DISPOSITION_HEAD.length()) {
                        throw new EOFException("CONTENT_DISPOSITION_HEAD\u9577\u30a8\u30e9\u30fc");
                    }
                    if (!contentDisposition.substring(0, CONTENT_DISPOSITION_HEAD.length()).toLowerCase().equals(CONTENT_DISPOSITION_HEAD)) {
                        throw new EOFException("CONTENT_DISPOSITION_HEAD\u30a8\u30e9\u30fc");
                    }
                    String name = "";
                    String filename = "";
                    StringTokenizer st = new StringTokenizer(contentDisposition = contentDisposition.substring(CONTENT_DISPOSITION_HEAD.length()).trim(), ";");
                    int count = st.countTokens();
                    if (count < 1) {
                        break;
                    }
                    int i = 0;
                    while (i < count) {
                        StringTokenizer st2 = new StringTokenizer(st.nextToken().trim(), "=");
                        if (st2.countTokens() == 2) {
                            String key = st2.nextToken().toLowerCase().trim();
                            String value = st2.nextToken();
                            if (key.equals("name")) {
                                name = ReqParser.cutDC(value);
                            } else if (key.equals("filename")) {
                                filename = ReqParser.cutDC(value);
                            }
                        }
                        ++i;
                    }
                    bFileOut = false;
                    bos = null;
                    if (!filename.equals("")) {
                        fileNo = PirkaUploadManager.getFileNo();
                        fileNoList.add(fileNo);
                        File tempFile = PirkaUploadManager.getFile(fileNo);
                        bos = new BufferedOutputStream(new FileOutputStream(tempFile));
                        bFileOut = true;
                    }
                    while (!ReqParser.readStringLine(sis, tempBuff).equals("")) {
                    }
                    tempValueOffset = 0;
                    int offset = 0;
                    boolean length = false;
                    long outCount = 0L;
                    while (true) {
                        int readCount;
                        if ((readCount = sis.read(tempBuff, offset++, 1)) <= 0) {
                            throw new EOFException("\u30c7\u30fc\u30bf\u8aad\u307f\u53d6\u308a\u4e2d\u306bEOF");
                        }
                        if (offset < boundary.length) continue;
                        if (ReqParser.checkEnd(tempBuff, offset - boundary.length, boundary)) break;
                        if (bFileOut) {
                            if (bos != null) {
                                bos.write(tempBuff, offset - boundary.length, 1);
                                ++outCount;
                            }
                        } else if (tempValueOffset < tempValue.length) {
                            tempValue[tempValueOffset++] = tempBuff[offset - boundary.length];
                        } else {
                            byte[] t = tempValue;
                            tempValue = new byte[t.length + 100];
                            System.arraycopy(t, 0, tempValue, 0, t.length);
                            tempValue[tempValueOffset++] = tempBuff[offset - boundary.length];
                        }
                        if (offset < tempBuff.length) continue;
                        System.arraycopy(tempBuff, offset - boundary.length + 1, tempBuff, 0, boundary.length - 1);
                        offset = boundary.length - 1;
                    }
                    if (bFileOut) {
                        if (bos != null) {
                            bos.close();
                            bos = null;
                        }
                        ReqParser.setParam(name, filename, paramMap);
                        ReqParser.setParam(name, "" + fileNo, paramMap);
                    } else {
                        byte[] tempByte = new byte[tempValueOffset];
                        System.arraycopy(tempValue, 0, tempByte, 0, tempValueOffset);
                        ReqParser.setParam(name, new String(tempByte, "8859_1"), paramMap);
                    }
                    ReqParser.readStringLine(sis, tempBuff);
                }
            }
            catch (EOFException boundaryTemp) {
            }
            catch (IOException e) {
                throw e;
            }
        }
        finally {
            sis.close();
        }
        for (String key : paramMap.keySet()) {
            reqMap.put(key, ((List)paramMap.get(key)).toArray(new String[0]));
        }
    }

    private static byte[] readByteLine(InputStream is, byte[] tempBuff) throws IOException {
        int offset = 0;
        int mode = 0;
        while (offset < tempBuff.length && is.read(tempBuff, offset, 1) >= 1) {
            byte byteData;
            if ((byteData = tempBuff[offset++]) == 13) {
                mode = 1;
                continue;
            }
            if (byteData == 10 && mode == 1) {
                mode = 2;
                break;
            }
            mode = 0;
        }
        if ((offset -= mode) <= 0) {
            if (mode != 2) {
                throw new EOFException("eof");
            }
            return new byte[0];
        }
        byte[] buff = new byte[offset];
        System.arraycopy(tempBuff, 0, buff, 0, offset);
        return buff;
    }

    private static String readStringLine(InputStream is, byte[] tempBuff) throws IOException {
        byte[] buff = ReqParser.readByteLine(is, tempBuff);
        if (buff == null) {
            return null;
        }
        return new String(buff, "JISAutoDetect");
    }

    private static boolean checkEnd(byte[] buff, int offset, byte[] checkData) {
        int i = 0;
        while (i < checkData.length) {
            if (buff[offset + i] != checkData[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String cutDC(String str) {
        if (str == null) {
            return null;
        }
        if (str.equals("\"\"")) {
            return "";
        }
        if (str.length() > 1 && str.substring(0, 1).equals("\"")) {
            str = str.substring(1);
        }
        if (str.length() > 1 && str.substring(str.length() - 1).equals("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private String cutFileName(String str) {
        if (str == null) {
            return null;
        }
        int idx = (str = ReqParser.cutDC(str)).lastIndexOf("\\");
        if (idx + 1 < str.length()) {
            str = str.substring(idx + 1);
        }
        if ((idx = str.lastIndexOf("/")) + 1 < str.length()) {
            str = str.substring(idx + 1);
        }
        return str;
    }

    private static void setParam(String key, String value, HashMap<String, List> paramMap) {
        LinkedList<String> paramList = paramMap.get(key);
        if (paramList == null) {
            paramList = new LinkedList<String>();
            paramMap.put(key, paramList);
        }
        paramList.add(value);
    }

    private static String convertKanji(String value) {
        try {
            return ReqParser.MSKanjiConv(value.getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public static String MSKanjiConv(byte[] bytes) throws UnsupportedEncodingException {
        boolean jisFlg = false;
        int i = 0;
        while (i < bytes.length) {
            if (i + 2 < bytes.length && bytes[i] == 27 && bytes[i + 1] == 36) {
                jisFlg = true;
                break;
            }
            ++i;
        }
        if (jisFlg) {
            return new String(ReqParser.jis2SJis(bytes), "MS932");
        }
        String euc = "";
        try {
            euc = new String(bytes, "EUC_JP");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String JISAutoDetect = "";
        try {
            JISAutoDetect = new String(bytes, "JISAutoDetect");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String ms932 = "";
        try {
            ms932 = new String(ReqParser.jis2SJis(bytes), "MS932");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (!euc.equals(JISAutoDetect)) {
            return ms932;
        }
        if (ReqParser.charCount(ms932, '?') <= ReqParser.charCount(euc, '?')) {
            return ms932;
        }
        return euc;
    }

    private static int charCount(String str, char chr) {
        int count = 0;
        if (str != null) {
            int length = str.length();
            int i = 0;
            while (i < length) {
                if (str.charAt(i) == chr) {
                    ++count;
                }
                ++i;
            }
        }
        return count;
    }

    private static byte[] jis2SJis(byte[] buff) {
        int op = 0;
        int mode = 1;
        int i = 0;
        while (i < buff.length) {
            if (buff[i] == 27) {
                if (i + 2 < buff.length) {
                    if (buff[i + 1] == 40) {
                        mode = 1;
                    } else if (buff[i + 1] == 36) {
                        mode = 2;
                    }
                }
                i += 2;
            } else if (mode == 1) {
                buff[op++] = buff[i];
            } else {
                if (i + 1 < buff.length) {
                    int c1 = buff[i] >= 0 ? buff[i] : 256 + buff[i];
                    int c2 = buff[i + 1] >= 0 ? buff[i + 1] : 256 + buff[i + 1];
                    if (c1 % 2 != 0) {
                        c1 = (c1 + 1) / 2 + 112;
                        c2 += 31;
                    } else {
                        c1 = c1 / 2 + 112;
                        c2 += 125;
                    }
                    if (c1 >= 160) {
                        c1 += 64;
                    }
                    if (c2 >= 127) {
                        ++c2;
                    }
                    buff[op++] = c1 > 127 ? (byte)(c1 - 256) : (byte)c1;
                    buff[op++] = c2 > 127 ? (byte)(c2 - 256) : (byte)c2;
                }
                ++i;
            }
            ++i;
        }
        byte[] rtn = new byte[op];
        System.arraycopy(buff, 0, rtn, 0, op);
        return rtn;
    }
}

