/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.ctrl.proc.def;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.oarts.pirka.core.analyzer.html.HtmlTools;
import jp.oarts.pirka.core.ctrl.SelectList;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.HtmlPartsType;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.util.field.FieldItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectProcesser
extends CtrlProcesser {
    @Override
    public boolean isUseChild() {
        return true;
    }

    @Override
    public boolean isLoop() {
        return false;
    }

    @Override
    public boolean isSwitch() {
        return false;
    }

    @Override
    public boolean isInputCtrl() {
        return true;
    }

    @Override
    public boolean isActionCtrl() {
        return false;
    }

    @Override
    public boolean isGroupItem() {
        return false;
    }

    @Override
    public boolean isCheckCtrl() {
        return false;
    }

    @Override
    public boolean isFormatCtrl() {
        return false;
    }

    @Override
    public void setValue(Object data, FieldItem fieldItem) {
        if (data == null || !(data instanceof String[]) && !(data instanceof String)) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u308c\u305f\u5024\u306f\u30bb\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093 String\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u53c8\u306fString[]\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        fieldItem.setValue((String)data);
    }

    @Override
    public void analyzeInitValue(HtmlCtrlParts ctrl, List<HtmlParts> list) {
        StringBuilder defaultValueSb = new StringBuilder();
        SelectList selectList = new SelectList();
        for (HtmlParts parts : list) {
            if (parts.getType() != HtmlPartsType.TAG || !"option".equalsIgnoreCase(parts.getTagName())) continue;
            String sendValue = parts.getOption().get("value");
            boolean selected = parts.getOption().containsKey("selected");
            String optionValue = "";
            if (parts.getChild() != null) {
                optionValue = HtmlTools.toSimpleString(parts.getChild());
            }
            if (sendValue == null || sendValue.length() <= 0) {
                selectList.add(optionValue);
                if (!selected) continue;
                if (defaultValueSb.length() > 0) {
                    defaultValueSb.append('\t');
                }
                defaultValueSb.append(optionValue);
                continue;
            }
            selectList.add(optionValue, sendValue);
            if (!selected) continue;
            if (defaultValueSb.length() > 0) {
                defaultValueSb.append('\t');
            }
            defaultValueSb.append(sendValue);
        }
        ctrl.setSelectList(selectList);
        ctrl.setDefaultValue(defaultValueSb.toString());
    }

    @Override
    public String makeStartTag(HtmlCtrlParts ctrl, String loopSuffix, String value, boolean checked, WindowBaseData windowBaseData, ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker, boolean errorFlag) {
        Map<String, String> optionMap = ctrl.getOptionMap();
        if (errorFlag) {
            optionMap = this.changeStyle(errorMessageManager.getNgStyle(), optionMap);
        }
        Map<String, String> selectedMap = this.makeSelectedMap(value);
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        sb.append(ctrl.getTagName());
        sb.append(this.createOptionString(ctrl.getTypeOption(), String.valueOf(ctrl.getName()) + loopSuffix, loopSuffix, value, ctrl.isSuffix(), optionMap));
        sb.append(">");
        SelectList selectList = ctrl.getSelectList();
        if (selectList != null) {
            int i = 0;
            while (i < selectList.size()) {
                sb.append("<option value=\"");
                sb.append(selectList.getSendValue(i));
                sb.append('\"');
                if (selectedMap.containsKey(selectList.getSendValue(i))) {
                    sb.append(" selected");
                }
                sb.append('>');
                sb.append(selectList.getOptionValue(i));
                sb.append("</option>");
                sb.append("\r\n");
                ++i;
            }
        }
        return sb.toString();
    }

    private Map<String, String> makeSelectedMap(String value) {
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        if (value != null) {
            String[] values;
            String[] stringArray = values = value.split("\\t");
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String selectValue = stringArray[n];
                rtnMap.put(selectValue, selectValue);
                ++n;
            }
        }
        return rtnMap;
    }

    @Override
    public void setReq(Map<String, String[]> reqMap, String fieldName, FieldItem fieldItem, String[] values) {
        StringBuilder defaultValueSb = new StringBuilder();
        if (values != null) {
            String[] stringArray = values;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String value = stringArray[n];
                if (defaultValueSb.length() > 0) {
                    defaultValueSb.append('\t');
                }
                defaultValueSb.append(value);
                ++n;
            }
            fieldItem.setValue(defaultValueSb.toString());
        }
    }
}

