/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.ctrl.proc.def;

import java.util.List;
import java.util.Map;
import jp.oarts.pirka.core.analyzer.html.HtmlTools;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.util.field.FieldItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpanProcesser
extends CtrlProcesser {
    @Override
    public boolean isUseChild() {
        return true;
    }

    @Override
    public boolean isLoop() {
        return false;
    }

    @Override
    public boolean isSwitch() {
        return false;
    }

    @Override
    public boolean isInputCtrl() {
        return false;
    }

    @Override
    public boolean isActionCtrl() {
        return false;
    }

    @Override
    public boolean isGroupItem() {
        return false;
    }

    @Override
    public boolean isCheckCtrl() {
        return false;
    }

    @Override
    public boolean isFormatCtrl() {
        return true;
    }

    @Override
    public void setValue(Object data, FieldItem fieldItem) {
        if (data == null || !(data instanceof String)) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u308c\u305f\u5024\u306f\u30bb\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093 String\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        fieldItem.setValue((String)data);
    }

    @Override
    public void analyzeInitValue(HtmlCtrlParts ctrl, List<HtmlParts> list) {
        ctrl.setDefaultValue(HtmlTools.toSimpleString(list));
        ctrl.setTagEffective(true);
        ctrl.setWebSafe(true);
    }

    @Override
    public String makeStartTag(HtmlCtrlParts ctrl, String loopSuffix, String value, boolean checked, WindowBaseData windowBaseData, ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker, boolean errorFlag) {
        StringBuilder sb = new StringBuilder();
        if (ctrl.isTagEffective()) {
            Map<String, String> optionMap = ctrl.getOptionMap();
            if (errorFlag) {
                optionMap = this.changeStyle(errorMessageManager.getNgLabelStyle(), optionMap);
            }
            sb.append('<');
            sb.append(ctrl.getTagName());
            sb.append(this.createOptionString(ctrl.getTypeOption(), String.valueOf(ctrl.getName()) + loopSuffix, loopSuffix, null, ctrl.isSuffix(), optionMap));
            sb.append(">");
        }
        if (ctrl.getBaseName().equals("errorMessage")) {
            if (errorMessageManager.isWebSafeErrorMessage()) {
                sb.append(HtmlTools.webString(errorMessageManager.createErrorMessage(errorMessageStocker)));
            } else {
                sb.append(errorMessageManager.createErrorMessage(errorMessageStocker));
            }
        } else if (ctrl.isWebSafe()) {
            sb.append(HtmlTools.webString(value));
        } else {
            sb.append(value);
        }
        return sb.toString();
    }
}

