/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.util.check;

import java.io.UnsupportedEncodingException;
import jp.oarts.pirka.core.util.check.PirkaCheckerStringCharsIF;

public class PirkaCheckerStringChars
implements PirkaCheckerStringCharsIF {
    public static final PirkaCheckerStringChars NUM = new PirkaCheckerStringChars("0123456789");
    public static final PirkaCheckerStringChars LOW_ALPHABET = new PirkaCheckerStringChars("abcdefghijklmnopqrstuvwxyz");
    public static final PirkaCheckerStringChars HIGHT_ALPHABET = new PirkaCheckerStringChars("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    public static final PirkaCheckerStringChars HALF = new PirkaCheckerStringChars(){

        public boolean check(char c) {
            String s = "" + c;
            try {
                return s.getBytes("MS932").length == 1;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("\u6587\u5b57\u30b3\u30fc\u30c9\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
        }
    };
    public static final PirkaCheckerStringChars WIDE = new PirkaCheckerStringChars(){

        public boolean check(char c) {
            String s = "" + c;
            try {
                return s.getBytes("MS932").length == 2;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("\u6587\u5b57\u30b3\u30fc\u30c9\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
        }
    };
    public static final PirkaCheckerStringChars HALF_KANA = new PirkaCheckerStringChars("\uff71\uff72\uff73\uff74\uff75\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff85\uff86\uff87\uff88\uff89\uff8a\uff8b\uff8c\uff8d\uff8e\uff8f\uff90\uff91\uff92\uff93\uff94\uff95\uff96\uff97\uff98\uff99\uff9a\uff9b\uff9c\uff66\uff9d\uff67\uff68\uff69\uff6a\uff6b\uff6f\uff6c\uff6d\uff6e\uff70\uff9e\uff9f\uff64\uff61\uff65\uff62\uff63");
    public static final PirkaCheckerStringChars SPACE = new PirkaCheckerStringChars(" ");
    public static final PirkaCheckerStringChars WIDE_SPAC = new PirkaCheckerStringChars("\u3000");
    public static final PirkaCheckerStringChars MAIL = new PirkaCheckerStringChars("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ@_.");
    public static final PirkaCheckerStringChars PATH_WIN = new PirkaCheckerStringChars(){

        public boolean check(char c) {
            return "/;*?\"<>?".indexOf(c) < 0;
        }
    };
    private String checkString;

    public PirkaCheckerStringChars() {
        this.checkString = null;
    }

    public PirkaCheckerStringChars(String checkString) {
        this.checkString = checkString;
    }

    public boolean check(char c) {
        return this.checkString.indexOf(c) >= 0;
    }
}

