/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.kernel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PirkaUploadManager
implements Serializable {
    private static long fileNo = 0L;
    private static Map<Long, File> uploadFileMap = new HashMap<Long, File>();
    private static Map<Long, InputStream> inputStreamMap = new HashMap<Long, InputStream>();

    public static synchronized long getFileNo() {
        return ++fileNo;
    }

    public static synchronized File getFile(long fileNo) throws IOException {
        File tempFile = File.createTempFile("Pirka" + fileNo, "tmp");
        uploadFileMap.put(fileNo, tempFile);
        return tempFile;
    }

    public static synchronized InputStream getInputStream(long fileNo) throws IOException {
        if (inputStreamMap.containsKey(fileNo)) {
            throw new IOException("\u65e2\u306b\u53d6\u5f97\u6e08\u307f\u3067\u3059");
        }
        File file = uploadFileMap.get(fileNo);
        FileInputStream fis = null;
        fis = new FileInputStream(file);
        inputStreamMap.put(fileNo, fis);
        return fis;
    }

    public static synchronized void deleteFile(long fileNo) {
        File file = uploadFileMap.get(fileNo);
        uploadFileMap.remove(fileNo);
        InputStream is = inputStreamMap.get(fileNo);
        if (is != null) {
            inputStreamMap.remove(fileNo);
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        file.delete();
    }

    public static synchronized void deleteFile(List<Long> deleteFineNoList) {
        Long[] deleteFileNos;
        Long[] longArray = deleteFileNos = deleteFineNoList.toArray(new Long[0]);
        int n = 0;
        int n2 = longArray.length;
        while (n < n2) {
            Long fileNo = longArray[n];
            PirkaUploadManager.deleteFile(fileNo);
            ++n;
        }
    }
}

