/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.core.BasicLocation;
import org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static AgentLocation agentDataLocation = null;
    public static BundleContext context;
    private static final String DEFAULT_AGENT_LOCATION = "../p2";
    public static final String ID = "org.eclipse.equinox.p2.core";
    private static Activator instance;
    private static final String NO_DEFAULT = "@noDefault";
    private static final String NONE = "@none";
    private static final String PROP_AGENT_DATA_AREA = "eclipse.p2.data.area";
    private static final String PROP_CONFIG_DIR = "osgi.configuration.area";
    private static final String PROP_USER_DIR = "user.dir";
    private static final String PROP_USER_HOME = "user.home";
    public static final String READ_ONLY_AREA_SUFFIX = ".readOnly";
    private static final String VAR_CONFIG_DIR = "@config.dir";
    private static final String VAR_USER_DIR = "@user.dir";
    private static final String VAR_USER_HOME = "@user.home";
    private ServiceRegistration agentLocationRegistration = null;
    ServiceTracker logTracker;
    static /* synthetic */ Class class$0;

    private static URL adjustTrailingSlash(URL url, boolean trailingSlash) throws MalformedURLException {
        String file = url.getFile();
        if (trailingSlash == file.endsWith("/")) {
            return url;
        }
        file = trailingSlash ? String.valueOf(file) + "/" : file.substring(0, file.length() - 1);
        return new URL(url.getProtocol(), url.getHost(), file);
    }

    private static URL buildURL(String spec, boolean trailingSlash) {
        if (spec == null) {
            return null;
        }
        boolean isFile = spec.startsWith("file:");
        try {
            if (isFile) {
                return Activator.adjustTrailingSlash(new File(spec.substring(5)).toURL(), trailingSlash);
            }
            return new URL(spec);
        }
        catch (MalformedURLException malformedURLException) {
            if (isFile) {
                return null;
            }
            try {
                return Activator.adjustTrailingSlash(new File(spec).toURL(), trailingSlash);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    public static BundleContext getContext() {
        return context;
    }

    public static FrameworkLog getFrameworkLog() {
        Activator a = instance;
        if (a == null) {
            return null;
        }
        ServiceTracker tracker = a.getLogTracker();
        if (tracker == null) {
            return null;
        }
        return (FrameworkLog)tracker.getService();
    }

    private static String substituteVar(String source, String var, String prop) {
        String value = context.getProperty(prop);
        if (value == null) {
            value = "";
        }
        return String.valueOf(value) + source.substring(var.length());
    }

    private AgentLocation buildLocation(String property, URL defaultLocation, boolean readOnlyDefault, boolean addTrailingSlash) {
        String base;
        boolean readOnly;
        String location = context.getProperty(property);
        String userReadOnlySetting = context.getProperty(String.valueOf(property) + READ_ONLY_AREA_SUFFIX);
        boolean bl = readOnly = userReadOnlySetting == null ? readOnlyDefault : Boolean.valueOf(userReadOnlySetting);
        if (location == null) {
            return new BasicLocation(property, defaultLocation, readOnly);
        }
        if (location.equalsIgnoreCase(NONE)) {
            return null;
        }
        if (location.equalsIgnoreCase(NO_DEFAULT)) {
            return new BasicLocation(property, null, readOnly);
        }
        if (location.startsWith(VAR_USER_HOME)) {
            base = Activator.substituteVar(location, VAR_USER_HOME, PROP_USER_HOME);
            location = new Path(base).toFile().getAbsolutePath();
        } else if (location.startsWith(VAR_USER_DIR)) {
            base = Activator.substituteVar(location, VAR_USER_DIR, PROP_USER_DIR);
            location = new Path(base).toFile().getAbsolutePath();
        } else if (location.startsWith(VAR_CONFIG_DIR)) {
            location = Activator.substituteVar(location, VAR_CONFIG_DIR, PROP_CONFIG_DIR);
        }
        URL url = Activator.buildURL(location, addTrailingSlash);
        BasicLocation result = null;
        if (url != null) {
            result = new BasicLocation(property, null, readOnly);
            result.set(url, false);
        }
        return result;
    }

    private ServiceTracker getLogTracker() {
        if (this.logTracker != null) {
            return this.logTracker;
        }
        if (context == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logTracker = new ServiceTracker(context, clazz.getName(), null);
        this.logTracker.open();
        return this.logTracker;
    }

    public void start(BundleContext aContext) throws Exception {
        instance = this;
        context = aContext;
        URL defaultLocation = new URL(String.valueOf(aContext.getProperty(PROP_CONFIG_DIR)) + DEFAULT_AGENT_LOCATION + '/');
        agentDataLocation = this.buildLocation(PROP_AGENT_DATA_AREA, defaultLocation, false, true);
        Hashtable<String, String> locationProperties = new Hashtable<String, String>();
        if (agentDataLocation != null) {
            ((Dictionary)locationProperties).put("type", PROP_AGENT_DATA_AREA);
            this.agentLocationRegistration = aContext.registerService(AgentLocation.SERVICE_NAME, (Object)agentDataLocation, locationProperties);
        }
    }

    public void stop(BundleContext aContext) throws Exception {
        instance = null;
        if (this.agentLocationRegistration != null) {
            this.agentLocationRegistration.unregister();
        }
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        context = null;
    }
}

