/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.association.utility.WinRegistryWrapper;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.proxy.NSPreferences;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.WinRegistry;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.Vector;
import sun.security.action.GetPropertyAction;

public class WinConfig
extends Config {
    private String _userHome;
    private String _systemHome;
    private String _osHome;
    private String _systemExeHome;
    private static final String JRE_SUBKEY = "SOFTWARE\\JavaSoft\\Java Runtime Environment";
    private static final String JAVA_HOME = "JavaHome";

    public void loadDeployNativeLib() {
        try {
            System.load(Config.getJavaHome() + File.separator + "bin" + File.separator + "msvcr71.dll");
            System.load(Config.getJavaHome() + File.separator + "bin" + File.separator + "deploy.dll");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public String escapeBackslashAndQuoteString(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public String getPlatformUserHome() {
        if (this._userHome == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.user.profile"));
            if (string == null || string.trim().equals("")) {
                byte[] byArray = WinConfig.getPlatformUserHomeImpl();
                if (byArray != null) {
                    string = new String(byArray);
                }
                if (string == null) {
                    string = AccessController.doPrivileged(new GetPropertyAction("user.home"));
                }
            }
            this._userHome = string + (string.endsWith(File.separator) ? "" : File.separator) + "Sun" + File.separator + "Java" + File.separator + "Deployment";
        }
        return this._userHome;
    }

    public String getPlatformSystemHome() {
        if (this._systemHome == null) {
            this._systemHome = WinConfig.getPlatformSystemHomeImpl() + File.separator + "Sun" + File.separator + "Java" + File.separator + "Deployment";
        }
        return this._systemHome;
    }

    public String getPlatformOSHome() {
        if (this._osHome == null) {
            this._osHome = WinConfig.getPlatformSystemHomeImpl();
        }
        return this._osHome;
    }

    private static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public String getSystemJavawsPath() {
        String string;
        File file;
        if (this._systemExeHome == null) {
            this._systemExeHome = WinConfig.getSystemExecutableHomeImpl();
        }
        if ((file = new File(string = this._systemExeHome + File.separator + "javaws.exe")).exists()) {
            File file2 = new File(WinConfig.replace(string, "system32", "SysWOW64"));
            if (file2.exists()) {
                return file2.getPath();
            }
            return file.getPath();
        }
        return super.getSystemJavawsPath();
    }

    public String getPlatformExtension() {
        return ".exe";
    }

    public String toExecArg(String string) {
        return "\"" + string + "\"";
    }

    public String getLibraryPrefix() {
        return "";
    }

    public String getLibrarySufix() {
        return ".dll";
    }

    public boolean useAltFileSystemView() {
        return true;
    }

    public boolean systemLookAndFeelDefault() {
        return true;
    }

    public String getPlatformSpecificJavaName() {
        return "javaw.exe";
    }

    public String getSessionSpecificString() {
        return "-" + System.getProperty("os.arch");
    }

    public String getDebugJavaPath(String string) {
        return string.substring(0, string.lastIndexOf(".")).concat(".exe");
    }

    public void resetJavaHome() {
        String string;
        String string2 = WinRegistry.getString(-2147483646, "Software\\Javasoft\\Java Runtime Environment", "CurrentVersion");
        if (string2 != null && (string = WinRegistry.getString(-2147483646, "Software\\Javasoft\\Java Runtime Environment\\" + string2, JAVA_HOME)) != null) {
            Trace.println("_javaHome reset from: " + _javaHome + " to: " + string, TraceLevel.NETWORK);
            _javaHome = string;
        }
    }

    public native boolean showDocument(String var1);

    public native String getBrowserPath();

    public native void notifyJREInstalled(String var1);

    public native boolean isNativeModalDialogUp();

    public String getMozillaUserProfileDirectory() {
        String string = WinRegistry.getString(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "AppData");
        String string2 = null;
        if (string != null) {
            try {
                File file = new File(string + "\\Mozilla\\registry.dat");
                if (file.exists()) {
                    string2 = NSPreferences.getNS6UserProfileDirectory(file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string2;
    }

    public String getFireFoxUserProfileDirectory() {
        String string = WinRegistry.getString(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "AppData");
        String string2 = null;
        if (string != null) {
            try {
                File file = new File(string + "\\Mozilla\\Firefox\\profiles.ini");
                if (file.exists()) {
                    string2 = NSPreferences.getFireFoxUserProfileDirectory(file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string2;
    }

    public boolean canAutoDownloadJRE() {
        return this.canDownloadJRE();
    }

    public Vector getInstalledJREList() {
        String string;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while ((string = WinRegistryWrapper.WinRegEnumKeyEx(-2147483646, JRE_SUBKEY, n, 255)) != null) {
            vector.add(string);
            String string2 = WinRegistryWrapper.WinRegQueryValueEx(-2147483646, "SOFTWARE\\JavaSoft\\Java Runtime Environment\\" + string, JAVA_HOME);
            if (string2 != null) {
                vector.add(string2);
            } else {
                vector.add("");
            }
            ++n;
        }
        return vector;
    }

    public String getBrowserHomePath() {
        return WinConfig.getBrowserHomePathImpl();
    }

    public native int installShortcut(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public native void addRemoveProgramsAdd(String var1, String var2, String var3, String var4, String var5, String var6, boolean var7);

    public native void addRemoveProgramsRemove(String var1, boolean var2);

    public native boolean canDownloadJRE();

    public native boolean isPlatformWindowsVista();

    public native boolean isBrowserFireFox();

    private static native byte[] getPlatformUserHomeImpl();

    private static native String getPlatformSystemHomeImpl();

    private static native String getSystemExecutableHomeImpl();

    private static native String getBrowserHomePathImpl();

    protected native int getPlatformMaxCommandLineLength();

    protected native long getPlatformPID();

    static {
        Config.getInstance().loadDeployNativeLib();
    }
}

