<?php
class Plugg_User_Main_AssociateAuth extends Sabai_Application_Controller
{
    protected function _doExecute(Sabai_Application_Context $context)
    {
        // Check if properly coming from authentication
        if (empty($_SESSION['Plugg_User_Main_Login_auth']['timestamp']) ||
            $_SESSION['Plugg_User_Main_Login_auth']['timestamp'] < time() - 300
        ) {
            $context->response->setError($context->plugin->_('Invalid request'));
            return;
        }

        // Check if already logged in
        if ($context->user->isAuthenticated()) {
            $context->response->setError($context->plugin->_('Invalid request'), array('base' => '/user'));
            unset($_SESSION['Plugg_User_Main_Login_auth']);
            return;
        }

        // Check if user account plugin is valid
        if ((!$manager_name = $context->plugin->getParam('userManagerPlugin')) ||
            (!$manager = $this->pluginManager->getPlugin($manager_name)) ||
            ($manager instanceof Plugg_User_Manager_API)
        ) {
            $context->response->setError($context->plugin->_('Invalid request'));
            unset($_SESSION['Plugg_User_Main_Login_auth']);
            return;
        }

        // Update auth data timestamp in session
        $_SESSION['Plugg_User_Main_Login_auth']['timestamp'] = time();

        // Validate form and submit if valid
        $form = $this->_parent->getLoginForm($context, $manager, $this->url->create(array('base' => '/user', 'path' => '/associate_auth')), $context->request->getAsInt('_autologin'));
        $form->addHeader(sprintf(
            $context->plugin->_('Login using the form below to associate your user account with the submitted authentication or <a href="%s">create a new user account and associate it with the authenticaton</a>.'),
            $this->url->create(array('base' => '/user', 'path' => '/register_auth'))
        ));
        if ($form->validate()) {
            if ($user = $this->_parent->submitLoginForm($context, $form, $manager)) {
                // Associate authentication in session with the user account
                if ($context->plugin->createAuthdata($_SESSION['Plugg_User_Main_Login_auth'], $user->getId())) {
                    $context->response->addMessage(
                        $context->plugin->_('Authentication associated with your user account successfully. You can log in as the user account using the authentication from now on.'),
                        Sabai_Response::MESSAGE_SUCCESS
                    );
                } else {
                    $context->response->addMessage(
                        $context->plugin->_('Failed creating association between your user account and the external authentication used. Try logging in again using the external authentication.'),
                        Sabai_Response::MESSAGE_WARNING
                    );
                }
                $this->_parent->loginUser($context, $user, $form->getSubmitValue('_autologin'));
                unset($_SESSION['Plugg_User_Main_Login_auth']);
                return;
            }
        }
        // View
        $context->response
            ->setVars(array(
                'form' => $form,
                'form_html' => $this->_parent->renderLoginForm($form, $manager),
            ))
            ->setPageInfo($context->plugin->_('Login'));
    }
}