<?php
require_once 'Plugg/PluginMain.php';

class Plugg_Xigg_Main extends Plugg_PluginMain
{
    public function __construct()
    {
        parent::__construct(__CLASS__ . '_', dirname(__FILE__) . '/Main', 'ShowNodes');
        $this->addControllerFilter(array(
            'DeleteCommentForm',
            'DeleteTrackbackForm',
            'EditCommentForm',
            'EditTrackbackForm',
            'MoveCommentForm'
        ), 'isAuthenticated');
        $this->addControllerFilter(array(
            'ShowUpcomingNodes',
            'ShowUpcomingNodesByTag'
        ), 'isUpcomingFeatureEnabled');
        $this->addControllerFilter(array(
            'SubmitCommentForm',
            'SubmitCommentReplyForm',
            'ShowCommentReplyForm',
            'ShowComment',
            'ShowCommentReplies',
            'EditCommentForm',
            'MoveCommentForm',
            'DeleteCommentForm'
        ), 'isCommentFeatureEnabled');
        $this->addControllerFilter(array(
            'ShowTrackback',
            'EditTrackbackForm',
            'DeleteTrackbackForm'
        ), 'isTrackbackFeatureEnabled');
        $this->addControllerFilter(array(
            'ShowVote'
        ), 'isVotingFeatureEnabled');
        $this->addControllerFilter(array(
            'ShowCommentReplyForm',
            'SubmitCommentReplyForm'
        ), 'isSubmitCommentAllowed');
        $this->addControllerFilter(array(
            'ShowVoteForm',
            'SubmitVote'
        ), 'isSubmitVoteAllowed');
        $this->addControllerFilter(array(
            'SubmitNodeForm'
        ), 'isSubmitArticleAllowed');
    }

    function _doGetRoutes(Sabai_Application_Context $context)
    {
        return array(
            'upcoming' => array(
                'controller' => 'ShowUpcomingNodes'
            ),
            ':node_id' => array(
                'controller'   => 'Node',
                'requirements' => array(':node_id' => '\d+')
            ),
            'submit' => array(
                'controller' => 'SubmitNodeForm'
            ),
            'comment/:comment_id/replyform' => array(
                'controller'   => 'ShowCommentReplyForm',
                'requirements' => array(':comment_id' => '\d+')
            ),
            'comment/:comment_id/reply' => array(
                'controller'   => 'SubmitCommentReplyForm',
                'requirements' => array(':comment_id' => '\d+')
            ),
            'comment/:comment_id/replies' => array(
                'controller'   => 'ShowCommentReplies',
                'requirements' => array(':comment_id' => '\d+')
            ),
            'comment/:comment_id/delete' => array(
                'controller'   => 'DeleteCommentForm',
                'requirements' => array(':comment_id' => '\d+')
            ),
            'comment/:comment_id/edit' => array(
                'controller'   => 'EditCommentForm',
                'requirements' => array(':comment_id' => '\d+')
            ),
            'comment/:comment_id/move' => array(
                'controller'   => 'MoveCommentForm',
                'requirements' => array(':comment_id' => '\d+')
            ),
            'comment/:comment_id' => array(
                'controller'   => 'ShowComment',
                'requirements' => array(':comment_id' => '\d+')
            ),
            'tag/:tag_name/upcoming' => array(
                'controller'   => 'ShowUpcomingNodesByTag',
                'requirements' => array(':tag_name' => '.+')
            ),
            'tag/:tag_name' => array(
                'controller'   => 'ShowNodesByTag',
                'requirements' => array(':tag_name' => '.+')
            ),
            'tag' => array(
                'controller' => 'ListTags'
            ),
            'trackback/:trackback_id/delete' => array(
                'controller'   => 'DeleteTrackbackForm',
                'requirements' => array(':trackback_id' => '\d+')
            ),
            'trackback/:trackback_id/edit' => array(
                'controller'   => 'EditTrackbackForm',
                'requirements' => array(':trackback_id' => '\d+')
            ),
            'trackback/:trackback_id' => array(
                'controller'   => 'ShowTrackback',
                'requirements' => array(':trackback_id' => '\d+')
            ),
            'vote/:vote_id' => array(
                'controller'   => 'ShowVote',
                'requirements' => array(':vote_id' => '\d+')
            ),
            'rss' => array('controller' => 'RSS'),
        );
    }

    function getNodeById(Sabai_Application_Context $context, $nodeIdVar = 'node_id', $clearCache = false)
    {
        if (0 < $node_id = $context->request->getAsInt($nodeIdVar)) {
            if ($clearCache) {
                $context->plugin->getModel()->Node->clearCache();
            }
            if (false !== $node = $context->plugin->getModel()->Node->fetchById($node_id)) {
                return $node;
            }
        }
        return false;
    }

    function isAuthorized(Sabai_Application_Context $context, $perms)
    {
        if (!$context->user->hasPermission($perms)) {
            $context->response->setError($context->plugin->_('Permission denied'));
            $context->response->send($this->_application);
        }
    }

    function isSubmitArticleAllowedBeforeFilter(Sabai_Application_Context $context)
    {
        $this->_parent->isAuthenticatedBeforeFilter($context);
        $this->isAuthorized($context, array('xigg post'));
    }

    function isSubmitArticleAllowedAfterFilter(Sabai_Application_Context $context){}

    function isSubmitVoteAllowedBeforeFilter(Sabai_Application_Context $context)
    {
        if (!$context->plugin->getParam('guestVotesAllowed')) {
            $this->_parent->isAuthenticatedBeforeFilter($context);
            $this->isAuthorized($context, array('xigg vote'));
        }
    }

    function isSubmitVoteAllowedAfterFilter(Sabai_Application_Context $context){}

    function isSubmitCommentAllowedBeforeFilter(Sabai_Application_Context $context)
    {
        if (!$context->plugin->getParam('guestCommentsAllowed')) {
            $this->_parent->isAuthenticatedBeforeFilter($context);
        }
        $this->isAuthorized($context, array('xigg comment'));
    }

    function isSubmitCommentAllowedAfterFilter(Sabai_Application_Context $context){}

    function isUpcomingFeatureEnabledBeforeFilter(Sabai_Application_Context $context)
    {
        $this->isFeatureEnabledBeforeFilter('useUpcomingFeature', $context);
    }

    function isUpcomingFeatureEnabledAfterFilter(Sabai_Application_Context $context){}

    function isCommentFeatureEnabledBeforeFilter(Sabai_Application_Context $context)
    {
        $this->isFeatureEnabledBeforeFilter('useCommentFeature', $context);
    }

    function isCommentFeatureEnabledAfterFilter(Sabai_Application_Context $context){}

    function isTrackbackFeatureEnabledBeforeFilter(Sabai_Application_Context $context)
    {
        $this->isFeatureEnabledBeforeFilter('useTrackbackFeature', $context);
    }

    function isTrackbackFeatureEnabledAfterFilter(Sabai_Application_Context $context){}

    function isVotingFeatureEnabledBeforeFilter(Sabai_Application_Context $context)
    {
        $this->isFeatureEnabledBeforeFilter('useVotingFeature', $context);
    }

    function isVotingFeatureEnabledAfterFilter(Sabai_Application_Context $context){}

    function isFeatureEnabledBeforeFilter($feature, Sabai_Application_Context $context)
    {
        if (!$context->plugin->getParam($feature)) {
            $context->response->setError($context->plugin->_('Access denied'));
            $context->response->send($this->_application);
        }
    }
}