<?php
/*
This file has been generated by the Sabai scaffold script. Do not edit this file directly.
If you need to customize the class, use the following file:
plugins/Xigg/Model/Comment.php
*/
require_once 'Sabai/Model/TreeEntity.php';

abstract class Plugg_Xigg_Model_Base_Comment extends Sabai_Model_TreeEntity
{
    public function __construct(Sabai_Model $model)
    {
        parent::__construct('Comment', $model);
        $this->_vars = array('comment_id' => 0, 'comment_created' => 0, 'comment_updated' => 0, 'comment_title' => null, 'comment_body_filter_id' => 0, 'comment_body' => null, 'comment_body_html' => null, 'comment_allow_edit' => 1, 'comment_node_id' => null, 'comment_parent' => null, 'comment_userid' => null);
    }

    public function getUserId()
    {
        return $this->getVar('userid');
    }

    public function assignUser($user)
    {
        $this->_setVar('userid', $user->getId());
    }

    protected function _fetchUser($withData = false)
    {
        if (!isset($this->_objects['User'])) {
            $user_id = $this->getUserId();
            $identities = $this->_model->fetchUserIdentities(array($user_id), $withData);
            $this->_objects['User'] = $identities[$user_id];
        }
        return $this->_objects['User'];
    }

    public function isOwnedBy($user)
    {
        return $this->getUserId() == $user->getId();
    }

    public function getId()
    {
        return $this->getVar('id');
    }

    public function setId($value)
    {
        $this->setVar('id', $value);
    }

    public function getTimeCreated()
    {
        return $this->getVar('created');
    }

    public function getTimeUpdated()
    {
        return $this->getVar('updated');
    }

    public function getLabel()
    {
        return $this->getVar('title');
    }


    public function getParentId()
    {
        return intval($this->getVar('parent'));
    }

    public function assignNode(Sabai_Model_Entity $entity)
    {
        if ($entity->getName() != 'Node') return false;

        return $this->_assignEntity($entity, 'node_id');
    }

    public function unassignNode()
    {
        return $this->_unassignEntity('Node', 'node_id');
    }

    protected function _fetchNode()
    {
        return $this->_fetchEntity('Node', 'node_id');
    }

    public function assignParent(Sabai_Model_Entity $entity)
    {
        if ($entity->getName() != 'Comment') return false;

        return $this->_assignEntity($entity, 'parent');
    }

    public function unassignParent()
    {
        return $this->_unassignEntity('Parent', 'parent');
    }

    protected function _fetchParent()
    {
        return $this->_fetchEntity('Comment', 'parent');
    }

    protected function _getVar($name)
    {
        return $this->_vars['comment_' . $name];
    }

    protected function _setVar($name, $value)
    {
        switch ($name) {
        case 'id':
            $this->_vars['comment_id'] = $value;
            break;
        case 'title':
            $this->_vars['comment_title'] = trim($value);
            break;
        case 'body_filter_id':
            $this->_vars['comment_body_filter_id'] = $value;
            break;
        case 'body':
            $this->_vars['comment_body'] = trim($value);
            break;
        case 'body_html':
            $this->_vars['comment_body_html'] = trim($value);
            break;
        case 'allow_edit':
            $this->_vars['comment_allow_edit'] = $value;
            break;
        case 'node_id':
            $this->_vars['comment_node_id'] = $value;
            break;
        case 'parent':
            $this->_vars['comment_parent'] = $value;
            break;
        case 'userid':
            $this->_vars['comment_userid'] = trim($value);
            break;
        default:
            trigger_error(sprintf('Error trying to set value for variable %s. This variable is either read-only or does not exist for this entity', $name), E_USER_WARNING);
            return false;
        }
        return true;
    }

    protected function _get($name, $sort, $order)
    {
        switch ($name) {
        case 'title':
            return $this->getVar('title');
        case 'body_filter_id':
            return $this->getVar('body_filter_id');
        case 'body':
            return $this->getVar('body');
        case 'body_html':
            return $this->getVar('body_html');
        case 'allow_edit':
            return $this->getVar('allow_edit');
        case 'Node':
            return $this->_fetchNode();
        case 'Parent':
            return $this->_fetchParent();
        case 'User':
            return $this->_fetchUser();
        case 'UserWithData':
            return $this->_fetchUser(true);
        case 'Children':
            return $this->_fetchChildren();
        }
    }

    public function __set($name, $value)
    {
        switch ($name) {
        case 'title':
            $this->setVar('title', $value);
            break;
        case 'body_filter_id':
            $this->setVar('body_filter_id', $value);
            break;
        case 'body':
            $this->setVar('body', $value);
            break;
        case 'body_html':
            $this->setVar('body_html', $value);
            break;
        case 'allow_edit':
            $this->setVar('allow_edit', $value);
            break;
        case 'Node':
            $entity = is_array($value) ? $value[0] : $value;
            $this->assignNode($entity);
            break;
        case 'Parent':
            $entity = is_array($value) ? $value[0] : $value;
            $this->assignParent($entity);
            break;
        }
    }

    public function initVar($name, $value)
    {
        switch ($name) {
        default:
            $this->_vars[$name] = $value;
            break;
        }
    }
}

require_once 'Sabai/Model/TreeEntityRepository.php';

abstract class Plugg_Xigg_Model_Base_CommentRepository extends Sabai_Model_TreeEntityRepository
{
    public function __construct(Sabai_Model $model)
    {
        parent::__construct('Comment', $model);
    }
    public function fetchByUser($id, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeign('comment_userid', $id, $limit, $offset, $sort, $order);
    }

    public function paginateByUser($id, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntity('User', $id, $perpage, $sort, $order);
    }

    public function countByUser($id)
    {
        return $this->_countByForeign('comment_userid', $id);
    }

    public function fetchByUserAndCriteria($id, Sabai_Model_Criteria $criteria, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeignAndCriteria('comment_userid', $id, $criteria, $limit, $offset, $sort, $order);
    }

    public function paginateByUserAndCriteria($id, Sabai_Model_Criteria $criteria, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntityAndCriteria('User', $id, $criteria, $perpage, $sort, $order);
    }

    public function countByUserAndCriteria($id, Sabai_Model_Criteria $criteria)
    {
        return $this->_countByForeignAndCriteria('comment_userid', $id, $criteria);
    }

    public function fetchByNode($id, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeign('comment_node_id', $id, $limit, $offset, $sort, $order);
    }

    public function paginateByNode($id, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntity('Node', $id, $perpage, $sort, $order);
    }

    public function countByNode($id)
    {
        return $this->_countByForeign('comment_node_id', $id);
    }

    public function fetchByNodeAndCriteria($id, Sabai_Model_Criteria $criteria, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeignAndCriteria('comment_node_id', $id, $criteria, $limit, $offset, $sort, $order);
    }

    public function paginateByNodeAndCriteria($id, Sabai_Model_Criteria $criteria, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntityAndCriteria('Node', $id, $criteria, $perpage, $sort, $order);
    }

    public function countByNodeAndCriteria($id, Sabai_Model_Criteria $criteria)
    {
        return $this->_countByForeignAndCriteria('comment_node_id', $id, $criteria);
    }

    public function fetchByParent($id, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeign('comment_parent', $id, $limit, $offset, $sort, $order);
    }

    public function paginateByParent($id, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntity('Parent', $id, $perpage, $sort, $order);
    }

    public function countByParent($id)
    {
        return $this->_countByForeign('comment_parent', $id);
    }

    public function fetchByParentAndCriteria($id, Sabai_Model_Criteria $criteria, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeignAndCriteria('comment_parent', $id, $criteria, $limit, $offset, $sort, $order);
    }

    public function paginateByParentAndCriteria($id, Sabai_Model_Criteria $criteria, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntityAndCriteria('Parent', $id, $criteria, $perpage, $sort, $order);
    }

    public function countByParentAndCriteria($id, Sabai_Model_Criteria $criteria)
    {
        return $this->_countByForeignAndCriteria('comment_parent', $id, $criteria);
    }

    protected function _getCollectionByRowset(Sabai_DB_Rowset $rs)
    {
        return new Plugg_Xigg_Model_Base_CommentsByRowset($rs, $this->_model->create('Comment'), $this->_model);
    }

    public function createCollection(array $entities = array())
    {
        return new Plugg_Xigg_Model_Base_Comments($this->_model, $entities);
    }
}

class Plugg_Xigg_Model_Base_CommentsByRowset extends Sabai_Model_EntityCollection_Rowset
{
    public function __construct(Sabai_DB_Rowset $rs, Sabai_Model_Entity $emptyEntity, Sabai_Model $model)
    {
        parent::__construct('Comments', $rs, $emptyEntity, $model);
    }

    protected function _loadRow(Sabai_Model_Entity $entity, array $row)
    {
        $entity->initVars($row);
        if (isset($row['level'])) {
            $entity->setParentsCount($row['level']);
        }
        $entity->left = $row['tree_left'];
        $entity->right = $row['tree_right'];
    }
}

class Plugg_Xigg_Model_Base_Comments extends Sabai_Model_EntityCollection_Array
{
    public function __construct(Sabai_Model $model, array $entities = array())
    {
        parent::__construct($model, 'Comments', $entities);
    }
}