<?php
class Plugg_Xigg_Plugin extends Plugg_Plugin implements Plugg_Widget_Widget, Plugg_User_Tab, Plugg_User_Menu, Plugg_Search_Searchable
{
    const NODE_STATUS_PUBLISHED = 1;
    const NODE_STATUS_UPCOMING = 0;

    function onPluggMainRoutes($routes)
    {
        parent::_onPluggMainRoutes($routes);
    }

    function onPluggAdminRoutes($routes)
    {
        parent::_onPluggAdminRoutes($routes);
    }

    function onUserAdminRolePermissions($permissions)
    {
        $permissions[$this->_library] = array(
            //'Article' => array(
                'xigg post' => $this->_('Post article'),
                'xigg publish own' => $this->_('Publish own article'),
                'xigg publish any' => $this->_('Publish any article'),
                'xigg edit own unpublished' => $this->_('Edit own unpublished article'),
                'xigg edit any unpublished' => $this->_('Edit any unpublished article'),
                'xigg edit own published' => $this->_('Edit own published article'),
                'xigg edit any published' => $this->_('Edit any published article'),
                'xigg delete own unpublished' => $this->_('Delete own unpublished article'),
                'xigg delete any unpublished' => $this->_('Delete any unpublished article'),
                'xigg delete own published' => $this->_('Delete own published article'),
                'xigg delete any published' => $this->_('Delete any published article'),
                'xigg edit source title' => $this->_('Edit article source title'),
                'xigg edit priority' => $this->_('Edit article priority'),
                'xigg edit views' => $this->_('Edit article view count'),
                'xigg edit published' => $this->_('Edit article published date'),
                'xigg allow edit' => $this->_('Allow or disallow edit article'),
                'xigg allow comments' => $this->_('Allow or disallow article comments'),
                'xigg allow trackbacks' => $this->_('Allow or disallow article trackbacks'),
                //'xigg edit html' => $this->_('Edit article raw HTML'),
                'xigg hide' => $this->_('Hide article'),
                'xigg view hidden' => $this->_('View hidden article'),
            //),
                 //'Comment' => array(
                'xigg comment' => $this->_('Post comment'),
                'xigg comment move own' => $this->_('Move own comment'),
                'xigg comment move any' => $this->_('Move any comment'),
                'xigg comment edit own' => $this->_('Edit own comment'),
                'xigg comment edit any' => $this->_('Edit any comment'),
                'xigg comment delete own' => $this->_('Delete own comment'),
                'xigg comment delete any' => $this->_('Delete any comment'),
                'xigg comment allow edit' => $this->_('Allow or disallow edit'),
                //'xigg comment edit html' => $this->_('Edit comment raw HTML'),
                 //          ),
                 //'Trackback' => array(
                 'xigg trackback edit' => $this->_('Edit any trackback'),
                 'xigg trackback delete' => $this->_('Delete any trackback'),
                 //          ),
                 //'Vote' => array(
                 'xigg vote' => $this->_('Subumit vote')
            //),
        );
    }

    function widgetGetNames()
    {
        return array('nodes', 'posts', 'comments', 'trackbacks', 'votes', 'categories', 'tags');
    }

    function widgetGetTitle($widgetName)
    {
        switch ($widgetName) {
            case 'nodes':
                return $this->_('Recent articles');
            case 'posts':
                return $this->_('Recent posts');
            case 'comments':
                return $this->_('Recent comments');
            case 'trackbacks':
                return $this->_('Recent trackbacks');
            case 'votes':
                return $this->_('Recent votes');
            case 'categories':
                return $this->_('Categories');
            case 'tags':
                return $this->_('Tags');
        }
    }

    function widgetGetContent(Sabai_User $user, Sabai_Template_PHP $template, $widgetName)
    {
        switch ($widgetName) {
            case 'nodes':
                return $this->_renderNodesWidget($user, $template);
            case 'posts':
                return $this->_renderPostsWidget($user, $template);
            case 'comments':
                return $this->_renderCommentsWidget($user, $template);
            case 'trackbacks':
                return $this->_renderTrackbacksWidget($user, $template);
            case 'votes':
                return $this->_renderVotesWidget($user, $template);
            case 'categories':
                return $this->_renderCategoriesWidget($user, $template);
            case 'tags':
                return $this->_renderTagsWidget($user, $template);
        }
    }

    function _renderCategoriesWidget($user, $template)
    {
        $cache = $this->getCache(3600);
        if (false === $data = $cache->get('widget_categories')) {
            $categories = $this->getModel()->Category->fetch(0, 0, 'category_name', 'ASC');
            if ($categories->count() == 0) {
                $data = '';
            } else {
                $html = array();
                $entities = array();
                foreach ($categories as $category) {
                    $parent_id = intval($category->getParentId());
                    $entities[$parent_id]['children'][] = $category;
                }
                if (!empty($entities[0]['children'])) {
                    foreach (array_keys($entities[0]['children']) as $i) {
                        $this->_renderCategories($html, $entities, $entities[0]['children'][$i], '- ');
                    }
                }
                $data = implode("<br />\n", $html);
            }
            $cache->save($data, 'widget_categories');
        }
        return $data;
    }

    function _renderCategories(&$html, $categories, $category, $prefixOrig, $prefix = '')
    {
        $id = $category->getId();
        array_push($html, sprintf('%s<a href="%s">%s</a>', $prefix, $this->url->create(array('base' => '/' . $this->getName(), 'params' => array('category_id' => $id))), h($category->name)));
        if (!empty($categories[$id]['children'])) {
            foreach (array_keys($categories[$id]['children']) as $i) {
                $this->_renderCategories($html, $categories, $categories[$id]['children'][$i], $prefixOrig, $prefix . $prefixOrig);
            }
        }
    }

    function _renderNodesWidget($user, $template)
    {
        $cache = $this->getCache(90);
        if (false === $data = $cache->get('widget_nodes')) {
            $order = array('DESC', 'DESC');
            switch ($this->getParam('orderOfNodesOnWidget')) {
                case 'views':
                    $sort = array('node_views', 'node_published', 'node_priority');
                    $order = array('DESC', 'DESC', 'DESC');
                    break;
                case 'date':
                    $sort = array('node_published', 'node_priority');
                    break;
                case 'active':
                    $sort = array('node_comment_lasttime', 'node_published');
                    break;
                default:
                    $sort = array('node_priority', 'node_published');
            }
            $nodes = $this->getModel()->Node
                ->criteria()
                ->hidden_is(0)
                ->status_is(self::NODE_STATUS_PUBLISHED)
                ->fetch($this->getParam('numberOfNodesOnWidget'), 0, $sort, $order);
            if ($nodes->count() == 0) {
                $data = '';
            } else {
                $vars = array('nodes' => $nodes->with('Category')->with('User'));
                $data = $template->render('plugg_xigg_widget_nodes.tpl', $vars);
            }
            $cache->save($data, 'widget_nodes');
        }
        return $data;
    }

    function _renderPostsWidget($user, $template)
    {
        $cache = $this->getCache(90);
        if (false === $data = $cache->get('widget_posts')) {
            $order = array('DESC', 'DESC');
            $sort = array('node_comment_lasttime', 'node_published');
            $nodes = $this->getModel()->Node
                ->criteria()
                ->hidden_is(0)
                ->status_is(self::NODE_STATUS_PUBLISHED)
                ->fetch($this->getParam('numberOfPostsOnWidget'), 0, $sort, $order);
            if ($nodes->count() == 0) {
                $data = '';
            } else {
                $data = $template->render('plugg_xigg_widget_posts.tpl', array(
                    'nodes' => $nodes->with('Category')->with('User')->with('LastComment', 'User')
                ));
            }
            $cache->save($data, 'widget_posts');
        }
        return $data;
    }

    function _renderCommentsWidget($user, $template)
    {
        $cache = $this->getCache(300);
        if (false === $data = $cache->get('widget_comments')) {
            $comments = $this->getModel()->Comment
                ->fetch($this->getParam('numberOfCommentsOnWidget'), 0, 'comment_created', 'DESC');
            if ($comments->count() > 0) {
                $data = $template->render('plugg_xigg_widget_comments.tpl', array('comments' => $comments));
            } else {
                $data = '';
            }
            $cache->save($data, 'widget_comments');
        }
        return $data;
    }

    function _renderTrackbacksWidget($user, $template)
    {
        $cache = $this->getCache(3600);
        if (false === $data = $cache->get('widget_trackbacks')) {
            $trackbacks = $this->getModel()->Trackback
                ->fetch($this->getParam('numberOfTrackbacksOnWidget'), 0, 'trackback_created', 'DESC');
            if ($trackbacks->count() > 0) {
                $data = $template->render('plugg_xigg_widget_trackbacks.tpl', array('trackbacks' => $trackbacks));
            } else {
                $data = '';
            }
            $cache->save($data, 'widget_trackbacks');
        }
        return $data;
    }

    function _renderVotesWidget($user, $template)
    {
        $cache = $this->getCache(300);
        if (false === $data = $cache->get('widget_votes')) {
            $votes = $this->getModel()->Vote->fetch($this->getParam('numberOfVotesOnWidget'), 0, 'vote_created', 'DESC');
            if ($votes->count() > 0) {
                $data = $template->render('plugg_xigg_widget_votes.tpl', array('votes' => $votes));
            } else {
                $data = '';
            }
            $cache->save($data, 'widget_votes');
        }
        return $data;
    }

    function _renderTagsWidget($user, $template)
    {
        $cache = $this->getCache(300);
        $limit = $this->getParam('numberOfTagsOnWidget');
        $id = 'widget_tags_' . $limit;
        if ($data = $cache->get($id)) {
            $tags = unserialize($data);
        } else {
            $tags = $this->buildTagCloud($limit);
            $cache->save(serialize($tags), $id);
        }
        if (!empty($tags)) {
            return $template->render('plugg_xigg_widget_tags.tpl', array('tags' => $tags));
        }
        return '';
    }

    function buildTagCloud($limit = 0)
    {
        $tag_cloud = array();
        if ($tags = $this->getModel()->getGateway('Tag')->getTagsWithNodeCount($limit, 'tag_name')) {
            ksort($tags);

            require_once 'Sabai/Cloud.php';
            $cloud = new Sabai_Cloud();
            foreach (array_keys($tags) as $i) {
                $cloud->addElement(
                    $tags[$i]['tag_name'],
                    $this->url->create(array('base' => '/' . $this->getName(), 'path' => '/tag/' . rawurlencode($tags[$i]['tag_name']))),
                    $tags[$i]['node_count']
                );
            }
            $tag_cloud = $cloud->build();

            /*
            require_once 'HTML/TagCloud.php';
            $cloud = new HTML_TagCloud();
            foreach (array_keys($tags) as $i) {
                $cloud->addElement(
                    $tags[$i]['tag_name'],
                    $this->url->create(array('base' => '/' . $this->getName(), 'path' => '/tag/' . rawurlencode($tags[$i]['tag_name']))),
                    $tags[$i]['node_count']
                );
            }
            $tag_cloud = $cloud->buildAll();
            */
        }
        return $tag_cloud;
    }

    function userTabGetNames()
    {
        return array(
            'default' => $this->getNiceName()
        );
    }

    function userTabGetNicename($tabName)
    {
        switch ($tabName) {
            case 'default':
                return $this->getNiceName();
        }
    }

    function userTabGetContent($tabName, Sabai_Request_Web $request, Sabai_User $user, Sabai_Template_PHP $template, $tabId, Sabai_User_Identity $identity)
    {
        switch ($tabName) {
            case 'default':
                return $this->_renderDefaultUserTab($request, $user, $template, $tabId, $identity);
        }
    }

    function _renderDefaultUserTab($request, $user, $template, $tabId, $identity)
    {
        $id = $identity->getId();
        $is_owner = $user->getId() == $id;
        $model = $this->getModel();

        $perpage = 10;//intval($this->getParam('numberOfNodesOnUserTab'));
        $order = array('DESC', 'DESC');
        $sort = array('node_created', 'node_published');
        if (!$is_owner) {
            $node_pages = $model->Node
                ->criteria()
                ->hidden_is(0)
                ->paginateByUser($id, $perpage, $sort, $order);
        } else {
            $node_pages = $model->Node->paginateByUser($id, $perpage, $sort, $order);
        }
        $node_page = $node_pages->getValidPage($request->getAsInt('tab_node_page', 1));

        $perpage = 10;// intval($this->getParam('numberOfCommentsOnUserTab'));
        $comment_pages = $model->Comment->paginateByUser($id, $perpage, 'comment_created', 'DESC');
        $comment_page = $comment_pages->getValidPage($request->getAsInt('tab_comment_page', 1));

        $perpage = 10;//intval($this->getParam('numberOfVotesOnUserTab'));
        $vote_pages = $model->Vote->paginateByUser($id, $perpage, 'vote_created', 'DESC');
        $vote_page = $vote_pages->getValidPage($request->getAsInt('tab_vote_page', 1));

        $vars = array(
            'node_pages' => $node_pages,
            'node_page' => $node_page,
            'nodes' => $node_page->getElements(),
            'node_count_last' => $node_count_last = $node_page->getOffset() + $node_page->getLimit(),
            'node_count_first' => $node_count_last > 0 ? $node_page->getOffset() + 1 : 0,
            'comment_pages' => $comment_pages,
            'comment_page' => $comment_page,
            'comments' => $comment_page->getElements(),
            'comment_count_last' => $comment_count_last = $comment_page->getOffset() + $comment_page->getLimit(),
            'comment_count_first' => $comment_count_last > 0 ? $comment_page->getOffset() + 1 : 0,
            'vote_pages' => $vote_pages,
            'vote_page' => $vote_page,
            'votes' => $vote_page->getElements(),
            'vote_count_last' => $vote_count_last = $vote_page->getOffset() + $vote_page->getLimit(),
            'vote_count_first' => $vote_count_last > 0 ? $vote_page->getOffset() + 1 : 0,
            'is_owner' => $is_owner,
            'identity' => $identity,
            'identity_id' => $id,
            'tab_id' => $tabId
        );

        return $template->render('plugg_xigg_user_tab_default.tpl', $vars);
    }

    function userMenuGetNames()
    {
        return array('submit' => $this->_('Submit article'));
    }

    function userMenuGetNicename($menuName)
    {
        return $this->_('Submit article');
    }

    function userMenuGetLinkText($menuName, $menuTitle, Sabai_User $user)
    {
        return $menuTitle;
    }

    function userMenuGetLinkUrl($menuName, Sabai_User $user)
    {
        return $this->url->create(array('base' => '/' . $this->_name, 'path' => '/submit'));
    }

    function searchGetNames()
    {
        // %s will be repalaced with the plugin display name
        return array(
            'articles' => $this->_('%s - Articles'),
            'comments' => $this->_('%s - Comments')
        );
    }

    function searchGetNicename($searchName)
    {
        switch ($searchName) {
            case 'articles': return $this->_('%s - Articles');
            case 'comments': return $this->_('%s - Comments');
        }
    }

    function searchGetContentUrl($searchName, $contentId)
    {
        switch ($searchName) {
            case 'articles':
                return $this->url->create(array(
                    'base' => '/' . $this->getName(),
                    'path' => '/' . $contentId,
                ));
            case 'comments':
                return $this->url->create(array(
                    'base' => '/' . $this->getName(),
                    'path' => '/comment/' . $contentId,
                    'fragment' => 'comment' . $contentId
                ));
        }
    }

    function searchFetchContents($searchName, $limit, $offset)
    {
        $contents = array();
        switch ($searchName) {
            case 'articles':
                $nodes = $this->getModel()->Node
                    ->criteria()
                    ->hidden_is(0)
                    ->fetch($limit, $offset, 'node_id', 'ASC')
                    ->with('Tags');
                foreach ($nodes as $node) {
                    $contents[] = $this->_nodeToContent($node, $node->Tags);
                }
                break;
            case 'comments':
                $comments = $this->getModel()->Comment->fetch($limit, $offset, 'comment_id', 'ASC');
                foreach ($comments as $comment) {
                    $contents[] = $this->_commentToContent($comment);
                }
                break;
        }
        return new ArrayObject($contents);
    }

    function searchCountContents($searchName)
    {
        switch ($searchName) {
            case 'articles':
                return $this->getModel()->Node
                    ->criteria()
                    ->hidden_is(0)
                    ->count();
            case 'comments':
                return $this->getModel()->Comment->count();
        }
        return false;
    }

    function searchFetchContentsByIds($searchName, $contentIds)
    {
        $contents = array();
        switch ($searchName) {
            case 'articles':
                $nodes = $this->getModel()->Node
                    ->criteria()
                    ->id_in($contentIds)
                    ->hidden_is(0)
                    ->fetch()
                    ->with('Tags');
                foreach ($nodes as $node) {
                    $contents[] = $this->_nodeToContent($node, $node->Tags);
                }
                break;
            case 'comments':
                $comments = $this->getModel()->Comment
                    ->criteria()
                    ->id_in($contentIds)
                    ->fetch();
                foreach ($comments as $comment) {
                    $contents[] = $this->_commentToContent($comment);
                }
                break;
        }
        return new ArrayObject($contents);
    }

    function _nodeToContent($node, $tags)
    {
        return array(
            'id' => $id = $node->getId(),
            'user_id' => $node->getUserId(),
            'title' => $node->get('title'),
            'body' => $node->get('body_html'),
            'created' => $node->getTimeCreated(),
            'modified' => $node->getTimeUpdated(),
            'keywords' => $tags->getAllVars('name'),
            'group' => sprintf('n:%d;', $id)
        );
    }

    function _commentToContent($comment)
    {
        return array(
            'id' => $id = $comment->getId(),
            'user_id' => $comment->getUserId(),
            'title' => $comment->get('title'),
            'body' => $comment->get('body_html'),
            'created' => $comment->getTimeCreated(),
            'modified' => $comment->getTimeUpdated(),
            'group' => sprintf('n:%d;c:%d', $comment->getVar('node_id'), $id)
        );
    }

    function onXiggSubmitNodeSuccess($context, $node, $isEdit)
    {
        // Ignore if not self dispatched
        if ($context->plugin->getName() != $this->_name) return;

        $c = $this->_nodeToContent($node, $node->Tags);

        // Register content to search engine
        $this->pluginManager->getPlugin('search')->putContent($this->getName(), 'articles', $c['id'], $c['title'], $c['body'], $c['user_id'], time(), $c['modified'], $c['keywords'], $c['group']);
    }

    function onXiggDeleteNodeSuccess($context, $node)
    {
        // Ignore if not self dispatched
        if ($context->plugin->getName() != $this->_name) return;

        // Specify group so that any content related to this node will be purged
        $group = sprintf('n:%d;', $node->getId());

        // Purge conetnt from search engine
        $this->pluginManager->getPlugin('search')->purgeContentGroup($this->getName(), $group);
    }

    function onXiggSubmitCommentSuccess($context, $node, $comment, $isEdit)
    {
        // Ignore if not self dispatched
        if ($context->plugin->getName() != $this->_name) return;

        $c = $this->_commentToContent($comment);

        // Register content to search engine
        $this->pluginManager->getPlugin('search')->putContent($this->getName(), 'comments', $c['id'], $c['title'], $c['body'], $c['user_id'], time(), $c['modified'], array(), $c['group']);
    }

    function onXiggDeleteCommentSuccess($context, $comment)
    {
        // Ignore if not self dispatched
        if ($context->plugin->getName() != $this->_name) return;

        // Purge conetnt from search engine
        $this->pluginManager->getPlugin('search')->purgeContent($this->getName(), 'comments', $comment->getId());
    }
}