<?php
require_once 'Sabai/Application/RoutingController.php';

abstract class Plugg_RoutingController extends Sabai_Application_RoutingController
{   
    protected $_eventNamePrefix;
    
    protected function __construct($defaultController, $controllerPrefix, $controllerDir, array $defaultControllerArgs = array(), $defaultControllerFile = null)
    {
        parent::__construct($defaultController, $controllerPrefix, $controllerDir, $defaultControllerArgs, $defaultControllerFile);
        $this->setFilters(array('_global'));
        $this->_eventNamePrefix = str_replace('_', '', substr(get_class($this), 6)); // Remove plugg_ 
    }
    
    protected function _globalBeforeFilter(Sabai_Application_Context $context)
    {
        $this->pluginManager->dispatch($this->_eventNamePrefix . 'Enter', array($context));
    }

    protected function _globalAfterFilter(Sabai_Application_Context $context)
    {   
        $this->pluginManager->dispatch($this->_eventNamePrefix . 'Exit', array($context));
    }
    
    protected function _getRoutes(Sabai_Application_Context $context)
    {
        $routes = array();
        $this->pluginManager->dispatch($this->_eventNamePrefix . 'Routes', array(&$routes));
        return array_merge($routes, $this->_doGetRoutes($context));
    }
    
    protected function _doGetRoutes(Sabai_Application_Context $context)
    {
        return array();
    }
}