<?php
class Plugg_User_Main_Identity_Friend_Edit extends Sabai_Application_Controller
{
    protected function _doExecute(Sabai_Application_Context $context)
    {
        $friend = $this->_parent->getRequestedFriend($context);
        $identity = $this->_parent->getRequestedUserIdentity($context);
        $url = array('base' => '/user', 'path' => '/' . $identity->getId(), 'params' => array('tab_id' => $context->request->getAsInt('tab_id')));

        $form = $this->_getForm($context, $friend);
        if ($form->validate()) {
            if ($relationships = $context->request->getAsArray('relationships')) {
                $rels = array();
                if ($friendship = @$relationships['friendship']) {
                    $rels[] = $friendship;
                }
                if ($physical = @$relationships['physical']) {
                    if (is_array($physical)) {
                        $rels = array_merge($rels, $physical);
                    }
                }
                if ($professional = @$relationships['professional']) {
                    if (is_array($professional)) {
                        $rels = array_merge($rels, $professional);
                    }
                }
                if ($geographical = @$relationships['geographical']) {
                    $rels[] = $geographical;
                }
                if ($family = @$relationships['family']) {
                    $rels[] = $family;
                }
                if ($romantic = @$relationships['romantic']) {
                    if (is_array($romantic)) {
                        $rels = array_merge($rels, $romantic);
                    }
                }
                if ($identity = @$relationships['identity']) {
                    if (is_array($identity)) {
                        $rels = array_merge($rels, $identity);
                    }
                }
                if ($rel = trim(implode(' ', $rels))) {
                    $friend->set('relationships', $rel);
                    if ($friend->commit()) {
                        $message = $context->plugin->_('Friend relationship updated successfully.');
                        $context->response->setSuccess($message, $url);
                        return;
                    }
                }
            }
            $form->setElementError('relationships', $context->plugin->_('You must select at least one relationship.'));
        }

        $context->response
            ->setPageInfo($context->plugin->_('Edit friend relationship'))
            ->setVars(array('friend_form' => &$form));
    }

    function _getForm(Sabai_Application_Context $context, $friend)
    {
        $with_user = $this->locator->getService('UserIdentityFetcher')->fetchUserIdentity($friend->get('with'));
        $form = $friend->toHTMLQuickForm();
        $form->removeElementsAll();
        $form->addHeader($context->plugin->_('Select personal relationships between you and your friend.'));
        $form->addElement('static', '', $context->plugin->_('Friend'), sprintf('<a href="%3$s" title="%1$s"><img alt="" src="%2$s" width="32" /></a> %1$s', h($with_user->getUsername()), $with_user->getImage(), $this->url->create(array('base' => '/user', 'path' => '/' . $with_user->getId()))));
        $xfn = $context->plugin->getXFNMetaDataList();
        $empty_option = array('' => $context->plugin->_('No selection'));

        $friendship = $form->createElement('altselect', 'friendship', array($context->plugin->_('Friendship'), null, ''), array_merge(array_combine($xfn['Friendship'], $xfn['Friendship']), $empty_option));
        $friendship->setDelimiter('&nbsp;');

        $physical = $form->createElement('altselect', 'physical', array($context->plugin->_('Physical'), null, ''), array_combine($xfn['Physical'], $xfn['Physical']));
        $physical->setMultiple(true);
        $physical->setDelimiter('&nbsp;');

        $professional = $form->createElement('altselect', 'professional', array($context->plugin->_('Professional'), null, ''), array_combine($xfn['Professional'], $xfn['Professional']));
        $professional->setMultiple(true);
        $professional->setDelimiter('&nbsp;');

        $geo = $form->createElement('altselect', 'geographical', array($context->plugin->_('Geographical'), null, ''), array_merge(array_combine($xfn['Geographical'], $xfn['Geographical']), $empty_option));
        $geo->setDelimiter('&nbsp;');

        $family = $form->createElement('altselect', 'family', array($context->plugin->_('Family'), null, ''), array_merge(array_combine($xfn['Family'], $xfn['Family']), $empty_option));
        $family->setDelimiter('&nbsp;');

        $romantic = $form->createElement('altselect', 'romantic', array($context->plugin->_('Romantic'), null, ''), array_combine($xfn['Romantic'], $xfn['Romantic']));
        $romantic->setMultiple(true);
        $romantic->setDelimiter('&nbsp;');

        //$identity = $form->createElement('altselect', 'identity', array($context->plugin->_('Identity'), null, ''), array_combine($xfn['Identity'], $xfn['Identity']));
        //$identity->setMultiple(true);
        //$identity->setDelimiter('&nbsp;');

        $form->addElement('group', 'relationships', $context->plugin->_('Relationships'), array($friendship, $physical, $professional, $geo, $family, $romantic));

        $form->addSubmitButtons($context->plugin->_('Update'), sprintf('<a href="%s">%s</a>', $this->url->create(array('base' => '/user', 'params' => array('tab_id' => $context->request->getAsInt('tab_id')))), $context->plugin->_('Cancel')));
        $form->useToken();

        $relationships = $friend->getRelationships();
        $form->setDefaults(array('relationships' => array(
            'friendship' => $relationships,
            'physical' => $relationships,
            'professional' => $relationships,
            'geographical' => $relationships,
            'family' => $relationships,
            'romantic' => $relationships,
        )));
        return $form;
    }
}