<?php
class Plugg_User_Main_Identity_Friend_Request extends Plugg_RoutingController
{
    function Plugg_User_Main_Identity_Friend_Request()
    {
        parent::__construct('View', 'Plugg_User_Main_Identity_Friend_Request_', dirname(__FILE__) . '/Request');
        $this->addFilters(array('_isValidFriendRequestRequested'));
    }

    function _isValidFriendRequestRequestedBeforeFilter(Sabai_Application_Context $context)
    {
        // Make sure the requested request exists
        if (!$request = $this->getRequestedFriendRequest($context)) {
            $context->response->setError($context->plugin->_('Invalid request'))
                ->send($this->_application);
        }
    }

    function _isValidFriendRequestRequestedAfterFilter(Sabai_Application_Context $context){}

    function _doGetRoutes(Sabai_Application_Context $context)
    {
        return array(
            'accept'   => array(
                'controller' => 'Accept',
            ),
            'reject'   => array(
                'controller' => 'Reject',
            ),
            'cancel'   => array(
                'controller' => 'Cancel',
            ),
            'confirm'   => array(
                'controller' => 'Confirm',
            ),
        );
    }

    function getRequestedFriendRequest(Sabai_Application_Context $context, $clearCache = false)
    {
        if ($id = $context->request->getAsInt('request_id')) {
            if ($entity = $context->plugin->getModel()->Friendrequest->fetchById($id, $clearCache)) {
                $entity->cache();
                return $entity;
            }
        }
        return false;
    }

    function clearMenuInSession(Sabai_Application_Context $context)
    {
        $this->pluginManager->getPlugin('user')->clearMenuInSession($context->plugin->getName(), 'friendrequest');
    }
}