<?php
class Plugg_User_Main_Identity_Friend_Request_Cancel extends Sabai_Application_Controller
{
    protected function _doExecute(Sabai_Application_Context $context)
    {
        $request = $this->_parent->getRequestedFriendRequest($context);
        $identity = $this->_parent->getRequestedUserIdentity($context);
        $url = array(
            'base' => '/user',
            'path' => '/' . $identity->getId(),
            'params' => array('tab_id' => $context->request->getAsInt('tab_id'))
        );

        if (!$request->isPending() || !$request->isOwnedBy($identity)) {
            $context->response->setError($context->plugin->_('Invalid request'), $url);
            return;
        }

        $form = $this->_getForm($context, $request);
        if ($form->validate()) {
            $request->markRemoved();
            if ($request->commit()) {
                $message = $context->plugin->_('Friend request canceled successfully.');
                $context->response->setSuccess($message, $url);
                $this->_parent->clearMenuInSession($context);
                return;
            }
        }

        $context->response->setPageInfo($context->plugin->_('Cancel a friend request'));
        $context->response->setVars(array('request_form' => &$form));
    }

    function _getForm(Sabai_Application_Context $context, $request)
    {
        $to_user = $this->locator->getService('UserIdentityFetcher')->fetchUserIdentity($request->get('to'));
        $form = $request->toHTMLQuickForm();
        $form->removeElementsAll();
        $form->addElement(
            'static',
            '',
            $context->plugin->_('Request sent to'),
            sprintf(
                '<a href="%3$s" title="%1$s"><img alt="" src="%2$s" width="32" /></a>',
                $to_user->getUsername(),
                $to_user->getImage(),
                $this->url->create(array('base' => '/user', 'path' => '/' . $to_user->getId()))
            )
        );
        $form->addElement(
            'static',
            '',
            $context->plugin->_('Message'),
            h($request->get('message'))
        );
        $form->addSubmitButtons(
            $context->plugin->_('Cancel request'),
            sprintf(
                '<a href="%s">%s</a>',
                $this->url->create(array(
                    'base' => '/user',
                    'params' => array('tab_id' => $context->request->getAsInt('tab_id'))
                )),
                $context->plugin->_('Back')
            )
        );
        $form->useToken();
        return $form;
    }
}