<?php
/*
This file has been generated by the Sabai scaffold script. Do not edit this file directly.
If you need to customize the class, use the following file:
pluginsy/Aggregator/Model/ItemGateway.php
*/
abstract class Plugg_Aggregator_Model_Base_ItemGateway extends Sabai_Model_Gateway
{
    public function getName()
    {
        return 'item';
    }

    public function getFields()
    {
        return array('item_id' => Sabai_Model::KEY_TYPE_INT, 'item_created' => Sabai_Model::KEY_TYPE_INT, 'item_updated' => Sabai_Model::KEY_TYPE_INT, 'item_title' => Sabai_Model::KEY_TYPE_VARCHAR, 'item_url' => Sabai_Model::KEY_TYPE_VARCHAR, 'item_body' => Sabai_Model::KEY_TYPE_TEXT, 'item_author' => Sabai_Model::KEY_TYPE_VARCHAR, 'item_author_link' => Sabai_Model::KEY_TYPE_VARCHAR, 'item_published' => Sabai_Model::KEY_TYPE_INT, 'item_categories' => Sabai_Model::KEY_TYPE_TEXT, 'item_hidden' => Sabai_Model::KEY_TYPE_INT, 'item_md5' => Sabai_Model::KEY_TYPE_VARCHAR, 'item_feed_id' => Sabai_Model::KEY_TYPE_INT);
    }

    protected function _getSelectByIdQuery($id, $fields)
    {
        return sprintf(
            'SELECT %s FROM %sitem WHERE item_id = %d',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $id
        );
    }

    protected function _getSelectByIdsQuery($ids, $fields)
    {
        return sprintf(
            'SELECT %s FROM %sitem WHERE item_id IN (%s)',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            implode(',', array_map('intval', $ids))
        );
    }

    protected function _getSelectByCriteriaQuery($criteriaStr, $fields)
    {
        return sprintf(
            'SELECT %1$s FROM %2$sitem WHERE %3$s',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $criteriaStr
        );
    }

    protected function _getInsertQuery($values)
    {
        $values['item_created'] = time();
        $values['item_updated'] = 0;
        return sprintf("INSERT INTO %sitem(item_created, item_updated, item_title, item_url, item_body, item_author, item_author_link, item_published, item_categories, item_hidden, item_md5, item_feed_id) VALUES(%d, %d, %s, %s, %s, %s, %s, %d, %s, %d, %s, %d)", $this->_db->getResourcePrefix(), $values['item_created'], $values['item_updated'], $this->_db->escapeString($values['item_title']), $this->_db->escapeString($values['item_url']), $this->_db->escapeString($values['item_body']), $this->_db->escapeString($values['item_author']), $this->_db->escapeString($values['item_author_link']), $values['item_published'], $this->_db->escapeString($values['item_categories']), $values['item_hidden'], $this->_db->escapeString($values['item_md5']), $values['item_feed_id']);
    }

    protected function _getUpdateQuery($id, $values)
    {
        $last_update = $values['item_updated'];
        $values['item_updated'] = time();
        return sprintf("UPDATE %sitem SET item_updated = %d, item_title = %s, item_url = %s, item_body = %s, item_author = %s, item_author_link = %s, item_published = %d, item_categories = %s, item_hidden = %d, item_md5 = %s, item_feed_id = %d WHERE item_id = %d AND item_updated = %d", $this->_db->getResourcePrefix(), $values['item_updated'], $this->_db->escapeString($values['item_title']), $this->_db->escapeString($values['item_url']), $this->_db->escapeString($values['item_body']), $this->_db->escapeString($values['item_author']), $this->_db->escapeString($values['item_author_link']), $values['item_published'], $this->_db->escapeString($values['item_categories']), $values['item_hidden'], $this->_db->escapeString($values['item_md5']), $values['item_feed_id'], $id, $last_update);
    }

    protected function _getDeleteQuery($id)
    {
        return sprintf('DELETE FROM %1$sitem WHERE item_id = %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getUpdateByCriteriaQuery($criteriaStr, $sets)
    {
        $sets['item_updated'] = 'item_updated=' . time();
        return sprintf('UPDATE %sitem SET %s WHERE %s', $this->_db->getResourcePrefix(), implode(',', $sets), $criteriaStr);
    }

    protected function _getDeleteByCriteriaQuery($criteriaStr)
    {
        return sprintf('DELETE FROM %1$sitem WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getCountByCriteriaQuery($criteriaStr)
    {
        return sprintf('SELECT COUNT(*) FROM %1$sitem WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _afterInsertTrigger1($id, $new)
    {
        if (!empty($new['item_feed_id'])) {
            $this->_db->exec(sprintf('UPDATE %sfeed SET feed_item_count = feed_item_count + 1, feed_item_last = %d, feed_item_lasttime = %d WHERE feed_id = %d', $this->_db->getResourcePrefix(), $id, $new['item_created'], $new['item_feed_id']));
        }
    }

    protected function _afterDeleteTrigger1($id, $old)
    {
        if (!empty($old['item_feed_id'])) {
            $sql = sprintf('SELECT item_id, item_created FROM %sitem WHERE item_feed_id = %d ORDER BY item_created DESC', $this->_db->getResourcePrefix(), $old['item_feed_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %sfeed SET feed_item_count = feed_item_count - 1, feed_item_last = %d, feed_item_lasttime = %d WHERE feed_id = %d', $this->_db->getResourcePrefix(), $row['item_id'], $row['item_created'], $old['item_feed_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %sfeed SET feed_item_count = feed_item_count - 1, feed_item_last = 0, feed_item_lasttime = feed_created WHERE feed_id = %d', $this->_db->getResourcePrefix(), $old['item_feed_id']));
            }
        }
    }

    protected function _afterUpdateTrigger1($id, $new, $old)
    {
        if (empty($old['item_feed_id']) && !empty($new['item_feed_id'])) {
            $this->_db->exec(sprintf('UPDATE %sfeed SET feed_item_count = feed_item_count + 1, feed_item_last = %d, feed_item_lasttime = %d WHERE feed_id = %d', $this->_db->getResourcePrefix(), $id, $new['item_created'], $new['item_feed_id']));
        } elseif (!empty($old['item_feed_id']) && empty($new['item_feed_id'])) {
            $sql = sprintf('SELECT item_id, item_created FROM %sitem WHERE item_feed_id = %d ORDER BY item_created DESC', $this->_db->getResourcePrefix(), $old['item_feed_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %sfeed SET feed_item_count = feed_item_count - 1, feed_item_last = %d, feed_item_lasttime = %d WHERE feed_id = %d', $this->_db->getResourcePrefix(), $row['item_id'], $row['item_created'], $old['item_feed_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %sfeed SET feed_item_count = feed_item_count - 1, feed_item_last = 0, feed_item_lasttime = feed_created WHERE feed_id = %d', $this->_db->getResourcePrefix(), $old['item_feed_id']));
            }
        } elseif ($old['item_feed_id'] != $new['item_feed_id']) {
            $sql = sprintf('SELECT item_id, item_created FROM %sitem WHERE item_feed_id = %d ORDER BY item_created DESC', $this->_db->getResourcePrefix(), $old['item_feed_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %sfeed SET feed_item_count = feed_item_count - 1, feed_item_last = %d, feed_item_lasttime = %d WHERE feed_id = %d', $this->_db->getResourcePrefix(), $row['item_id'], $row['item_created'], $old['item_feed_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %sfeed SET feed_item_count = feed_item_count - 1, feed_item_last = 0, feed_item_lasttime = feed_created WHERE feed_id = %d', $this->_db->getResourcePrefix(), $old['item_feed_id']));
            }
            $this->_db->exec(sprintf('UPDATE %sfeed SET feed_item_count = feed_item_count + 1, feed_item_last = %d, feed_item_lasttime = %d WHERE feed_id = %d', $this->_db->getResourcePrefix(), $id, $new['item_created'], $new['item_feed_id']));
        }
    }

    protected function _afterInsertTrigger($id, $new)
    {
        $this->_afterInsertTrigger1($id, $new);
    }

    protected function _afterUpdateTrigger($id, $new, $old)
    {
        $this->_afterUpdateTrigger1($id, $new, $old);
    }

    protected function _afterDeleteTrigger($id, $old)
    {
        $this->_afterDeleteTrigger1($id, $old);
    }
}