<?php
/*
This file has been generated by the Sabai scaffold script. Do not edit this file directly.
If you need to customize the class, use the following file:
pluginsy/Groups/Model/MemberGateway.php
*/
abstract class Plugg_Groups_Model_Base_MemberGateway extends Sabai_Model_Gateway
{
    public function getName()
    {
        return 'member';
    }

    public function getFields()
    {
        return array('member_id' => Sabai_Model::KEY_TYPE_INT, 'member_created' => Sabai_Model::KEY_TYPE_INT, 'member_updated' => Sabai_Model::KEY_TYPE_INT, 'member_role' => Sabai_Model::KEY_TYPE_INT, 'member_status' => Sabai_Model::KEY_TYPE_INT, 'member_group_id' => Sabai_Model::KEY_TYPE_INT, 'member_user_id' => Sabai_Model::KEY_TYPE_INT);
    }

    protected function _getSelectByIdQuery($id, $fields)
    {
        return sprintf(
            'SELECT %s FROM %smember WHERE member_id = %d',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $id
        );
    }

    protected function _getSelectByIdsQuery($ids, $fields)
    {
        return sprintf(
            'SELECT %s FROM %smember WHERE member_id IN (%s)',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            implode(',', array_map('intval', $ids))
        );
    }

    protected function _getSelectByCriteriaQuery($criteriaStr, $fields)
    {
        return sprintf(
            'SELECT %1$s FROM %2$smember WHERE %3$s',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $criteriaStr
        );
    }

    protected function _getInsertQuery($values)
    {
        $values['member_created'] = time();
        $values['member_updated'] = 0;
        return sprintf("INSERT INTO %smember(member_created, member_updated, member_role, member_status, member_group_id, member_user_id) VALUES(%d, %d, %d, %d, %d, %d)", $this->_db->getResourcePrefix(), $values['member_created'], $values['member_updated'], $values['member_role'], $values['member_status'], $values['member_group_id'], $values['member_user_id']);
    }

    protected function _getUpdateQuery($id, $values)
    {
        $last_update = $values['member_updated'];
        $values['member_updated'] = time();
        return sprintf("UPDATE %smember SET member_updated = %d, member_role = %d, member_status = %d, member_group_id = %d, member_user_id = %d WHERE member_id = %d AND member_updated = %d", $this->_db->getResourcePrefix(), $values['member_updated'], $values['member_role'], $values['member_status'], $values['member_group_id'], $values['member_user_id'], $id, $last_update);
    }

    protected function _getDeleteQuery($id)
    {
        return sprintf('DELETE FROM %1$smember WHERE member_id = %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getUpdateByCriteriaQuery($criteriaStr, $sets)
    {
        $sets['member_updated'] = 'member_updated=' . time();
        return sprintf('UPDATE %smember SET %s WHERE %s', $this->_db->getResourcePrefix(), implode(',', $sets), $criteriaStr);
    }

    protected function _getDeleteByCriteriaQuery($criteriaStr)
    {
        return sprintf('DELETE FROM %1$smember WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getCountByCriteriaQuery($criteriaStr)
    {
        return sprintf('SELECT COUNT(*) FROM %1$smember WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _afterInsertTrigger1($id, $new)
    {
        if (!empty($new['member_group_id'])) {
            $this->_db->exec(sprintf('UPDATE %sgroup SET group_member_count = group_member_count + 1, group_member_last = %d, group_member_lasttime = %d WHERE group_id = %d', $this->_db->getResourcePrefix(), $id, $new['member_created'], $new['member_group_id']));
        }
    }

    protected function _afterDeleteTrigger1($id, $old)
    {
        if (!empty($old['member_group_id'])) {
            $sql = sprintf('SELECT member_id, member_created FROM %smember WHERE member_group_id = %d ORDER BY member_created DESC', $this->_db->getResourcePrefix(), $old['member_group_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %sgroup SET group_member_count = group_member_count - 1, group_member_last = %d, group_member_lasttime = %d WHERE group_id = %d', $this->_db->getResourcePrefix(), $row['member_id'], $row['member_created'], $old['member_group_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %sgroup SET group_member_count = group_member_count - 1, group_member_last = 0, group_member_lasttime = group_created WHERE group_id = %d', $this->_db->getResourcePrefix(), $old['member_group_id']));
            }
        }
    }

    protected function _afterUpdateTrigger1($id, $new, $old)
    {
        if (empty($old['member_group_id']) && !empty($new['member_group_id'])) {
            $this->_db->exec(sprintf('UPDATE %sgroup SET group_member_count = group_member_count + 1, group_member_last = %d, group_member_lasttime = %d WHERE group_id = %d', $this->_db->getResourcePrefix(), $id, $new['member_created'], $new['member_group_id']));
        } elseif (!empty($old['member_group_id']) && empty($new['member_group_id'])) {
            $sql = sprintf('SELECT member_id, member_created FROM %smember WHERE member_group_id = %d ORDER BY member_created DESC', $this->_db->getResourcePrefix(), $old['member_group_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %sgroup SET group_member_count = group_member_count - 1, group_member_last = %d, group_member_lasttime = %d WHERE group_id = %d', $this->_db->getResourcePrefix(), $row['member_id'], $row['member_created'], $old['member_group_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %sgroup SET group_member_count = group_member_count - 1, group_member_last = 0, group_member_lasttime = group_created WHERE group_id = %d', $this->_db->getResourcePrefix(), $old['member_group_id']));
            }
        } elseif ($old['member_group_id'] != $new['member_group_id']) {
            $sql = sprintf('SELECT member_id, member_created FROM %smember WHERE member_group_id = %d ORDER BY member_created DESC', $this->_db->getResourcePrefix(), $old['member_group_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %sgroup SET group_member_count = group_member_count - 1, group_member_last = %d, group_member_lasttime = %d WHERE group_id = %d', $this->_db->getResourcePrefix(), $row['member_id'], $row['member_created'], $old['member_group_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %sgroup SET group_member_count = group_member_count - 1, group_member_last = 0, group_member_lasttime = group_created WHERE group_id = %d', $this->_db->getResourcePrefix(), $old['member_group_id']));
            }
            $this->_db->exec(sprintf('UPDATE %sgroup SET group_member_count = group_member_count + 1, group_member_last = %d, group_member_lasttime = %d WHERE group_id = %d', $this->_db->getResourcePrefix(), $id, $new['member_created'], $new['member_group_id']));
        }
    }

    protected function _afterInsertTrigger($id, $new)
    {
        $this->_afterInsertTrigger1($id, $new);
    }

    protected function _afterUpdateTrigger($id, $new, $old)
    {
        $this->_afterUpdateTrigger1($id, $new, $old);
    }

    protected function _afterDeleteTrigger($id, $old)
    {
        $this->_afterDeleteTrigger1($id, $old);
    }
}