<?php
/*
This file has been generated by the Sabai scaffold script. Do not edit this file directly.
If you need to customize the class, use the following file:
plugins/Uploads/Model/File.php
*/
abstract class Plugg_Uploads_Model_Base_File extends Sabai_Model_Entity
{
    public function __construct(Sabai_Model $model)
    {
        parent::__construct('File', $model);
        $this->_vars = array('file_id' => 0, 'file_created' => 0, 'file_updated' => 0, 'file_name' => null, 'file_file_name' => null, 'file_type' => null, 'file_size' => 0, 'file_is_image' => 0, 'file_image_width' => 0, 'file_image_height' => 0, 'file_thumbnail' => null, 'file_thumbnail_width' => 0, 'file_thumbnail_height' => 0, 'file_protected' => 0, 'file_user_id' => 0, 'file_group_id' => 0);
    }

    public function __clone()
    {
        $this->_vars = array_merge($this->_vars, array('file_id' => 0, 'file_created' => 0, 'file_updated' => 0));
    }

    public function __toString()
    {
        return $this->_get('name', null, null);
    }

    public function assignUser($user, $markDirty = true)
    {
        $this->_set('user_id', $user->id, $markDirty);
        return $this;
    }

    protected function _fetchUser($withData = false)
    {
        if (!isset($this->_objects['User'])) {
            $this->_objects['User'] = $this->_model->User_Identity($this->_vars['file_user_id'], $withData);
        }

        return $this->_objects['User'];
    }

    public function isOwnedBy($user)
    {
        return $this->user_id && $this->user_id == $user->id;
    }

    public function assignGroup(Plugg_Groups_Model_Group $group, $markDirty = true)
    {
        $this->_set('group_id', $group->id, $markDirty);
        return $this;
    }

    protected function _fetchGroup()
    {
        if (!isset($this->_objects['Group'])) {
            if (empty($this->_vars['file_group_id'])) {
                $this->_objects['Group'] = false;
            } else {
                $this->_objects['Group'] = $this->_model->Groups_Group($this->group_id);
            }
        }

        return $this->_objects['Group'];
    }

    protected function _get($name, $sort, $order, $limit = 0, $offset = 0)
    {
        switch ($name) {
        case 'id':
            return $this->_vars['file_id'];
        case 'created':
            return $this->_vars['file_created'];
        case 'updated':
            return $this->_vars['file_updated'];
        case 'name':
            return $this->_vars['file_name'];
        case 'file_name':
            return $this->_vars['file_file_name'];
        case 'type':
            return $this->_vars['file_type'];
        case 'size':
            return $this->_vars['file_size'];
        case 'is_image':
            return $this->_vars['file_is_image'];
        case 'image_width':
            return $this->_vars['file_image_width'];
        case 'image_height':
            return $this->_vars['file_image_height'];
        case 'thumbnail':
            return $this->_vars['file_thumbnail'];
        case 'thumbnail_width':
            return $this->_vars['file_thumbnail_width'];
        case 'thumbnail_height':
            return $this->_vars['file_thumbnail_height'];
        case 'protected':
            return $this->_vars['file_protected'];
        case 'user_id':
            return $this->_vars['file_user_id'];
        case 'group_id':
            return $this->_vars['file_group_id'];
        case 'User':
            return $this->_fetchUser();
        case 'UserWithData':
            return $this->_fetchUser(true);
        case 'Group':
            return $this->_fetchGroup();
default:
return isset($this->_objects[$name]) ? $this->_objects[$name] : null;
        }
    }

    protected function _set($name, $value, $markDirty)
    {
        switch ($name) {
        case 'id':
            $this->_setVar('file_id', $value, $markDirty);
            break;
        case 'name':
            $this->_setVar('file_name', $value, $markDirty);
            break;
        case 'file_name':
            $this->_setVar('file_file_name', $value, $markDirty);
            break;
        case 'type':
            $this->_setVar('file_type', $value, $markDirty);
            break;
        case 'size':
            $this->_setVar('file_size', $value, $markDirty);
            break;
        case 'is_image':
            $this->_setVar('file_is_image', $value, $markDirty);
            break;
        case 'image_width':
            $this->_setVar('file_image_width', $value, $markDirty);
            break;
        case 'image_height':
            $this->_setVar('file_image_height', $value, $markDirty);
            break;
        case 'thumbnail':
            $this->_setVar('file_thumbnail', $value, $markDirty);
            break;
        case 'thumbnail_width':
            $this->_setVar('file_thumbnail_width', $value, $markDirty);
            break;
        case 'thumbnail_height':
            $this->_setVar('file_thumbnail_height', $value, $markDirty);
            break;
        case 'protected':
            $this->_setVar('file_protected', $value, $markDirty);
            break;
        case 'user_id':
            $this->_setVar('file_user_id', $value, $markDirty);
            break;
        case 'group_id':
            $this->_setVar('file_group_id', $value, $markDirty);
            break;
        }
    }

    protected function _initVar($name, $value)
    {
        switch ($name) {
        default:
            $this->_vars[$name] = $value;
            break;
        }
    }
}

abstract class Plugg_Uploads_Model_Base_FileRepository extends Sabai_Model_EntityRepository
{
    public function __construct(Sabai_Model $model)
    {
        parent::__construct('File', $model);
    }

    public function fetchByUser($id, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeign('file_user_id', $id, $limit, $offset, $sort, $order);
    }

    public function paginateByUser($id, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntity('User', $id, $perpage, $sort, $order);
    }

    public function countByUser($id)
    {
        return $this->_countByForeign('file_user_id', $id);
    }

    public function fetchByUserAndCriteria($id, Sabai_Model_Criteria $criteria, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeignAndCriteria('file_user_id', $id, $criteria, $limit, $offset, $sort, $order);
    }

    public function paginateByUserAndCriteria($id, Sabai_Model_Criteria $criteria, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntityAndCriteria('User', $id, $criteria, $perpage, $sort, $order);
    }

    public function countByUserAndCriteria($id, Sabai_Model_Criteria $criteria)
    {
        return $this->_countByForeignAndCriteria('file_user_id', $id, $criteria);
    }

    public function fetchByGroup($id, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeign('file_group_id', $id, $limit, $offset, $sort, $order);
    }

    public function paginateByGroup($id, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntity('User', $id, $perpage, $sort, $order);
    }

    public function countByGroup($id)
    {
        return $this->_countByForeign('file_group_id', $id);
    }

    public function fetchByGroupAndCriteria($id, Sabai_Model_Criteria $criteria, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeignAndCriteria('file_group_id', $id, $criteria, $limit, $offset, $sort, $order);
    }

    public function paginateByGroupAndCriteria($id, Sabai_Model_Criteria $criteria, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntityAndCriteria('User', $id, $criteria, $perpage, $sort, $order);
    }

    public function countByGroupAndCriteria($id, Sabai_Model_Criteria $criteria)
    {
        return $this->_countByForeignAndCriteria('file_group_id', $id, $criteria);
    }

    protected function _getCollectionByRowset(Sabai_DB_Rowset $rs)
    {
        return new Plugg_Uploads_Model_Base_FilesByRowset($rs, $this->_model->create('File'), $this->_model);
    }

    public function createCollection(array $entities = array())
    {
        return new Plugg_Uploads_Model_Base_Files($this->_model, $entities);
    }
}

class Plugg_Uploads_Model_Base_FilesByRowset extends Sabai_Model_EntityCollection_Rowset
{
    public function __construct(Sabai_DB_Rowset $rs, Plugg_Uploads_Model_File $emptyEntity, Sabai_Model $model)
    {
        parent::__construct('Files', $rs, $emptyEntity, $model);
    }

    protected function _loadRow(Sabai_Model_Entity $entity, array $row)
    {
        $entity->initVars($row);
    }
}

class Plugg_Uploads_Model_Base_Files extends Sabai_Model_EntityCollection_Array
{
    public function __construct(Sabai_Model $model, array $entities = array())
    {
        parent::__construct($model, 'Files', $entities);
    }
}