/*
 * Copyright (C) 2002-2003 chik, s.hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// DraftFrame.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "Pochy.h"
#include "DraftFrame.h"
#include "sock.h"
#include "mainfrm.h"
#include "SendMail.h"
#include "MailEditView.h"
#include "lib.h"
#include "direct.h"
#include "MimeEncode.h"
#include <imm.h>
#include "Gpg.h"
#include "GpgKeyListDlg.h"
#include "GpgDlg.h"
#include "SummaryView.h"
#include "AddressView.h"
#include "ExEditor.h"
#include "DraftAddressBookDlg.h"
#include "DraftSendDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDraftFrame

IMPLEMENT_DYNCREATE(CDraftFrame, CFrameWnd)

CDraftFrame::CDraftFrame()
{
	CGpg gpg;
	CPochyApp *app = (CPochyApp*)AfxGetApp();
	CMainFrame *mf = (CMainFrame *)app->m_pMainWnd;
	this->m_hide = FALSE;
	this->m_flag = FALSE;
//	this->m_account = mf->m_pAcntV->GetCurrentAccountName();
	this->m_hide_attach = FALSE;
	this->m_button_gpg = app->m_gpg_enable;
	this->m_button_gpgenc = app->m_gpg_enable;
	this->m_button_gpgexp = app->m_gpg_enable;
	this->m_button_addfile = TRUE;
	this->m_button_address = TRUE;
	this->m_button_exteditor = TRUE;
	this->m_button_savedraft = TRUE;
	this->m_button_sendmail = TRUE;
	this->m_send_dlg = NULL;
}

CDraftFrame::~CDraftFrame()
{
}

BEGIN_MESSAGE_MAP(CDraftFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CDraftFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_SEND_MAIL, OnSend)
	ON_COMMAND(ID_SAVE_TO_DRAFT, OnSaveToDraft)
	ON_COMMAND(ID_ADD_FILE, OnAddFile)
	ON_COMMAND(ID_DRAFT_EXT_EDITOR, OnExtEditor)
	ON_WM_SIZE()
	ON_UPDATE_COMMAND_UI(ID_SEND_MAIL, OnUpdateSend)
	ON_UPDATE_COMMAND_UI(ID_DRAFT_GPG, OnUpdateGpg)
	ON_UPDATE_COMMAND_UI(ID_GPG_ENC, OnUpdateGpgEnc)
	ON_UPDATE_COMMAND_UI(ID_GPG_EXP, OnUpdateGpgExp)
	ON_UPDATE_COMMAND_UI(ID_ADD_FILE, OnUpdateAddFile)
	ON_UPDATE_COMMAND_UI(ID_DRAFT_ADDRESS, OnUpdateAddress)
	ON_UPDATE_COMMAND_UI(ID_SAVE_TO_DRAFT, OnUpdateSaveDraft)
	ON_UPDATE_COMMAND_UI(ID_DRAFT_EXT_EDITOR, OnUpdateExtEditor)
	ON_COMMAND(ID_GPG_ENC, OnGpgEnc)
	ON_COMMAND(ID_DRAFT_ADDRESS, OnAddress)
	ON_COMMAND(ID_DRAFT_GPG, OnGpg)
	ON_COMMAND(ID_GPG_EXP, OnGpgExport)
	ON_WM_CLOSE()
	ON_WM_DESTROY()
	ON_NOTIFY(TBN_DROPDOWN, AFX_IDW_TOOLBAR, OnToolbarDropDown)
	ON_COMMAND(ID_CHANGE_BK_COLOR_DRAFT, OnChangeBkColorDraft)
	ON_COMMAND(ID_CHANGE_TXT_COLOR_DRAFT, OnChangeTxtColorDraft)
	ON_COMMAND(ID_GPG_DRAFT_KEY_MANAGEMENT, OnGpgKeyManagement)
	ON_WM_COPYDATA()
	ON_WM_CHAR()
	ON_UPDATE_COMMAND_UI(ID_DRAFT_GPG, OnUpdateGpg)
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
	ON_COMMAND(WM_END, OnEnd)
	ON_COMMAND(WM_PROGCREATE, OnProgCreate)
	ON_COMMAND(WM_PROGDESTROY, OnProgDestroy)
	ON_WM_GETMINMAXINFO()
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,		// Xe[^X C CWP[^
	ID_INDICATOR_KANA,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CDraftFrame bZ[W nh

int CDraftFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if(CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
/*	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_DRAFTFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}*/

	if(m_me.GetMode() == ME_MODE_PGP){
		this->m_button_addfile = FALSE;
		this->m_button_exteditor = FALSE;
		this->m_button_gpgenc = FALSE;
		this->m_button_gpgexp = FALSE;
	}

	if(!this->CreateToolbar())
		return -1;

	if (!this->m_wndStatusBar.Create(this) ||
		!this->m_wndStatusBar.SetIndicators(indicators, sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create.
	}

  	// get previous window position from ini fileini.
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CRect rcWnd;

	// resurrect previous window position.
	rcWnd.left = app->GetProfileInt("DraftWndPlace", "Left", 0);
	rcWnd.top = app->GetProfileInt("DraftWndPlace", "Top", 0);
	rcWnd.right = app->GetProfileInt("DraftWndPlace", "Right", 700);
	rcWnd.bottom = app->GetProfileInt("DraftWndPlace", "Bottom", 520);
	this->MoveWindow(rcWnd);

	return 0;
}

void CDraftFrame::OnSend()
{
	CPochyApp* app=(CPochyApp*)AfxGetApp();
	this->EnableWindow(FALSE);

	CString body;
	this->m_pEditV->GetText(body);

	this->m_send_dlg = new CDraftSendDlg();
	this->m_send_dlg->Create(IDD_DRAFT_SEND_STATUS, this);
	this->m_send_dlg->ShowWindow(SW_SHOW);
	this->m_send_dlg->CenterWindow();

	this->m_me.SetTo(m_pAddrsV->GetTo());
	this->m_me.SetCc(m_pAddrsV->GetCc());
	this->m_me.SetBcc(m_pAddrsV->GetBcc());
	this->m_me.SetFrom(m_pAddrsV->GetFrom());
	this->m_me.SetSubject(m_pAddrsV->GetSubject());
	this->m_me.SetReplyTo(m_pAddrsV->GetReplyTo());
	this->m_me.SetXMailer(X_MAILER);
	// 12 Apr 2003 15:40:48 +0900
	CTime time = CTime::GetCurrentTime();
	this->m_me.SetDate(time.Format("%d %b %Y %H:%M:%S ")+DEF_TIME_ZONE);
	// setting mail body.
	if(this->m_me.GetMode() == ME_MODE_NONE)
		this->m_me.SetMultipartBody(0, body);

	AfxBeginThread(SendMail, this);
}

void CDraftFrame::OnSaveToDraft()
{
	this->SaveToDraft(FALSE);

	CPochyApp *app = (CPochyApp*)AfxGetApp();
	// confirm whether or not draft is saved.
	for(int i=0; i<app->m_draft_array.GetSize(); i++){
		if(this == app->m_draft_array[i])
			app->m_draft_array.RemoveAt(i);
	}
	CFrameWnd::OnClose();
}

void CDraftFrame::OnEnd()
{
	DestroyWindow();
}

void CDraftFrame::OnProgCreate()
{
	this->m_pd.Create(IDD_DIALOG1,&m_wndStatusBar);
}

void CDraftFrame::OnProgDestroy()
{
	this->m_pd.DestroyWindow();
}

BOOL CDraftFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	CPochyApp* app=(CPochyApp*)AfxGetApp();
	CMainFrame *mf = (CMainFrame *)app->m_pMainWnd;

	this->m_wndSplit.CreateStatic(this, 2, 1);
	this->m_wndSplit.SetStaticBorder(TRUE);
	this->m_wndSplit1.CreateStatic(&m_wndSplit, 2, 1, WS_CHILD|WS_VISIBLE|WS_BORDER, m_wndSplit.IdFromRowCol(0,0));

	this->m_wndSplit1.CreateView(0, 0, RUNTIME_CLASS(CAddressView), CSize(0,HT_HEAD), pContext);
	this->m_wndSplit1.CreateView(1, 0, RUNTIME_CLASS(CMailEditView), CSize(0, 0), pContext);
	this->m_wndSplit1.NoBorder();
	this->m_wndSplit1.SetStaticBorder(TRUE);
	this->m_wndSplit.CreateView(1, 0, RUNTIME_CLASS(CAttachedFileView), CSize(0, 0), pContext);

	this->m_pAddrsV = (CAddressView*)m_wndSplit1.GetPane(0, 0);
	this->m_pEditV = (CMailEditView*)m_wndSplit1.GetPane(1, 0);
	this->m_pListV2 = (CAttachedFileView*)m_wndSplit.GetPane(1, 0);
	this->m_me.CopyFrom(&app->m_me);

	// CAddressView̃TCY
	CSize size = this->m_pAddrsV->GetTotalSize();
	this->m_wndSplit1.SetRowInfo(0, size.cy, size.cy);

	// initialyzation
	this->m_pAddrsV->OnInitialUpdate();
	this->m_pEditV->OnInitialUpdate();
	this->m_pListV2->OnInitialUpdate();

	if(this->m_me.HowManyPart() > 1 && this->m_me.GetMode() != ME_MODE_PGP){
		this->HideAttachedFileView(FALSE);
	}else{
		this->HideAttachedFileView(TRUE);
	}

	this->m_flag=TRUE;

	// setting account name in window title.
	// below is stupid, but cannot find out better way.
//	CString title;
//	CString account = mf->m_pAcntV->GetCurrentAccountName();
//	title.Format("%s - %s", m_account, "draft");
//	this->SetWindowText(title);

	return TRUE;
}

void CDraftFrame::OnAddFile() 
{
	// prepare for dialog.
	CString path;
	CFileDialog dlg(TRUE, NULL, NULL, OFN_PATHMUSTEXIST, NULL, this);
	dlg.m_ofn.lpstrTitle = _T( "Ytt@C" );
	if(dlg.DoModal() == IDOK){
		path = dlg.GetPathName();
	}else{
		return;
	}

	// put path variable into m_me (MimeEncode)
	if(!m_me.AddAttachedFile(path))
		AfxMessageBox("cannot open file");

	// add item to attachedfileview.
	this->m_pListV2->AddFile(path.GetBuffer(0));
	path.ReleaseBuffer();

	// adjust someplace that is associated with gui.
	this->HideAttachedFileView(FALSE);
	this->ReArrangeSplit();
	this->m_pEditV->SetFocus();
}

void CDraftFrame::OnSize(UINT nType, int cx, int cy) 
{
	CFrameWnd::OnSize(nType, cx, cy);
	CPochyApp *app = (CPochyApp*)AfxGetApp();
	CMainFrame *mf = (CMainFrame *)app->m_pMainWnd;

	if(this->m_flag)
		this->ReArrangeSplit();
}

void CDraftFrame::OnAddress()
{
	this->m_me.SetTo(this->m_pAddrsV->GetTo());
	this->m_me.SetCc(this->m_pAddrsV->GetCc());
	this->m_me.SetBcc(this->m_pAddrsV->GetBcc());
	this->m_me.SetFrom(this->m_pAddrsV->GetFrom());
	this->m_me.SetSubject(this->m_pAddrsV->GetSubject());
	this->m_me.SetReplyTo(this->m_pAddrsV->GetReplyTo());

	CStringArray to;
	CStringArray cc;
	CStringArray bcc;

	g_cstr2cstra_ex(this->m_me.GetTo(),to, ",");
	g_cstr2cstra_ex(this->m_me.GetCc(),cc, ",");
	g_cstr2cstra_ex(this->m_me.GetBcc(),bcc, ",");

	int i;
	for(i=0; i<to.GetSize(); i++){
		if(to.GetAt(i).IsEmpty())
			to.RemoveAt(i);
	}
	for(i=0; i<cc.GetSize(); i++){
		if(cc.GetAt(i).IsEmpty())
			cc.RemoveAt(i);
	}
	for(i=0; i<bcc.GetSize(); i++){
		if(bcc.GetAt(i).IsEmpty())
			bcc.RemoveAt(i);
	}

	CDraftAddressBookDlg ad;
	ad.SetTo(to);
	ad.SetCc(cc);
	ad.SetBcc(bcc);
	ad.SetMode(ADDRESS_MODE_TO);
	ad.DoModal();
}

void CDraftFrame::OnGpg()
{
	this->OnGpgKeyManagement();
}

void CDraftFrame::CloseIME(CView* view)
{
	HIMC hImc = ImmGetContext(view->GetSafeHwnd());
	m_ime_status = ImmGetOpenStatus(hImc);
	ImmSetOpenStatus(hImc, FALSE);
	ImmReleaseContext(view->GetSafeHwnd(), hImc);
}

void CDraftFrame::RecoverIME(CView* view)
{
	if(view == NULL){
		return;
	}
	HIMC hImc = ImmGetContext(view->GetSafeHwnd());
	ImmSetOpenStatus(hImc, this->m_ime_status);
	ImmReleaseContext(view->GetSafeHwnd(), hImc);
}

BOOL CDraftFrame::KeyDown(UINT nChar,CView* view)
{
	CPochyApp* app = (CPochyApp*)AfxGetApp();
	CStatusBar& sb = this->m_wndStatusBar;
	if(::GetKeyState(VK_CONTROL) & 0xff00){	// whether or not pressing CTRL
		switch(nChar){
		case 'C':
			if(sb.GetPaneText(0)=="C-c"){
				this->RecoverIME(view);
				if(!m_button_sendmail)
					return TRUE;
				sb.SetPaneText(0,"C-c C-c");
				this->OnSend();
				sb.SetPaneText(0, "");
				return TRUE;
			}
			if(sb.GetPaneText(0)!="C-x"){
				this->CloseIME(view);
				sb.SetPaneText(0,"C-c");
				return TRUE;
			}else{
				this->RecoverIME(view);
				return TRUE;
			}
		case 'X':
			if(sb.GetPaneText(0)=="C-x" || sb.GetPaneText(0)=="C-c"){
				this->RecoverIME(view);
				sb.SetPaneText(0,"");
			}
			else{
				this->CloseIME(view);
				sb.SetPaneText(0,"C-x");
			}
			return TRUE;
		case 'G':
			sb.SetPaneText(0, "");
		}
	}
	return FALSE;
}

BOOL CDraftFrame::Char(UINT nChar,CView* view)
{
	if(m_wndStatusBar.GetPaneText(0)=="C-x"){
		switch(nChar){
		case 'o':
			this->m_wndStatusBar.SetPaneText(0,"C-x o");
			this->RecoverIME(view);
			this->SwitchView();
			this->m_wndStatusBar.SetPaneText(0,"");
			return TRUE;
		case 19:
			this->m_wndStatusBar.SetPaneText(0, "C-x C-s");
			this->RecoverIME(view);
			this->OnSaveToDraft();
			return TRUE;
		case 9:
			this->m_wndStatusBar.SetPaneText(0,"C-x C-i");
			this->RecoverIME(view);
			this->OnAddFile();
			this->m_wndStatusBar.SetPaneText(0, "");
			return TRUE;
		case 24:	// ignore Ctrl-X in OnChar()
			return TRUE;
		}
		this->RecoverIME(view);
		this->m_wndStatusBar.SetPaneText(0,"");
		return TRUE;
	}
	if(m_wndStatusBar.GetPaneText(0)=="C-c"){
		switch(nChar){
		case 3:		// ignore Ctrl-C in OnChar()
			return TRUE;
		}
		this->RecoverIME(view);
		this->m_wndStatusBar.SetPaneText(0,"");
		return TRUE;
	}
	return FALSE;
}

void CDraftFrame::OnUpdateSend(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_button_sendmail);
}

void CDraftFrame::OnUpdateGpgExp(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_button_gpgexp);
}

void CDraftFrame::OnUpdateAddress(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(m_button_address);
}

void CDraftFrame::OnUpdateSaveDraft(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(m_button_savedraft);
}

void CDraftFrame::OnUpdateExtEditor(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(m_button_exteditor);
}

void CDraftFrame::SwitchView()
{
	CWnd* wnd = GetFocus();
	if(wnd == m_pEditV)
		this->m_pAddrsV->m_to.SetFocus();
	else
		this->m_pEditV->SetFocus();
}

void CDraftFrame::OnGpgEnc()
{
	CGpg gpg;

	// selection of key.
	CPochyApp* app = (CPochyApp*)AfxGetApp();
	CGpgKeyListDlg lkd(this);
	CString recipient;
	recipient.Empty();
	if(lkd.DoModal()==IDOK && this->m_key_id_list.GetSize()){
		// preparation of executing process.
		CStringArray list;
		CString recipient;
		for(int i=0; i<this->m_key_id_list.GetSize(); i++){
			recipient = this->m_key_id_list[i];
			list.Add(recipient);
		}
		CString body;
		this->m_pEditV->GetText(body);
		this->m_me.SetMultipartBody(0, body);

		if(!gpg.Encode(list, m_me.GetMail(ME_GET_PRE_ENC_PGP), body)){
			this->MessageBox(gpg.GetErrorMsg(), "GPG error");
			return;
		}

		// display
		this->m_pEditV->SetWindowText(body);
		// for pgp/mime
		this->m_me.AddPgpEncrypted(body);
		this->m_pEditV->GetRichEditCtrl().SetReadOnly();
		this->HideAttachedFileView(TRUE);
		this->m_button_addfile = FALSE;
		this->m_button_exteditor = FALSE;
		this->m_button_gpgenc = FALSE;
		this->m_button_gpgexp = FALSE;
	}
}

void CDraftFrame::OnUpdateGpgEnc(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(m_button_gpgenc);
}

void CDraftFrame::OnUpdateGpg(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(m_button_gpg);
}

void CDraftFrame::OnUpdateAddFile(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(m_button_addfile);
}

void CDraftFrame::OnGpgExport() 
{
	CGpg gpg;

	// selection of key.
	CPochyApp* app = (CPochyApp*)AfxGetApp();
	CGpgKeyListDlg lkd;
	if(lkd.DoModal()==IDOK && this->m_key_id_list.GetSize()){
		// below may work under conditon that GpgKeyListDlg cannot accept multiple selection.
		CString id = this->m_key_id_list[0];
		CString out = gpg.ExportKey(id);
		this->m_me.AddPgpKey(out);
		this->m_pListV2->AddPgpKey();
		this->HideAttachedFileView(FALSE);
	}
}

void CDraftFrame::OnClose() 
{
	if(m_send_dlg != NULL)
		return;

	if(!SaveToDraft(TRUE)){
		this->SetForegroundWindow();
		return;
	}

	CPochyApp *app = (CPochyApp*)AfxGetApp();
	for(int i=0; i<app->m_draft_array.GetSize(); i++){
		if(this == app->m_draft_array[i])
			app->m_draft_array.RemoveAt(i);
	}

	CFrameWnd::OnClose();
}

void CDraftFrame::SetStatusBarText(int pane, LPSTR buf)
{
    // cannot use PostMessage, as the panel type is not set correctly
	::SendMessage(m_wndStatusBar, SB_SETTEXT, (WPARAM)pane | 0, (LPARAM)(LPSTR)buf);
}

void CDraftFrame::AttachFileFromCxCi()
{
/*	if(!m_hide){
		m_wndSplit.HideRow(1);
		m_hide=TRUE;
		if(!m_hide2){
			m_wndSplit1.HideRow(3);
			m_hide2=TRUE;
		}
		ArrangeSplit();
		m_pEditV->SetFocus();
	}else{
		// t@C͗pEBhEo
		m_wndSplit.ShowRow();
		m_hide=FALSE;
		ArrangeSplit();
//		m_wndSplit2.SetActivePane(0,0);
		m_wndSplit1.SetActivePane(3, 0);

		char buf[1024];
		_getdcwd(_getdrive(),buf,1023);
		CString wd = buf;
		wd.Replace("\\","/");// ̕\L̂ق肭
		m_wndStatusBar.SetPaneText(0,"t@C͂܂傤");// b
		wd=wd+"/";
		m_pFileV->SetWindowText(wd);
		m_pFileV->GetRichEditCtrl().SetSel(wd.GetLength(),wd.GetLength());
		m_pFileV->SetFocus();
	}*/
}


BOOL CDraftFrame::CreateToolbar()
{
	DWORD dwTBStyle, dwStyle;

	dwTBStyle = TBSTYLE_FLAT; // ̕ӂ̃X^C͓K
	dwStyle = WS_CHILD | WS_VISIBLE | CBRS_TOP | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC;
	if(!m_wndToolBar.CreateEx(this, dwTBStyle, dwStyle)){
		TRACE0("Failed to create toolbar\n");
		return FALSE;    // fail to create
	}

	CImageList img;
	HINSTANCE hInst = AfxFindResourceHandle((LPCTSTR)IDR_TEST, RT_BITMAP);
	ASSERT(hInst != NULL);
	img.Attach(ImageList_LoadImage(hInst, (LPCTSTR)IDR_DRAFTFRAME, WIDTH_ICON_DRAFT, 0, /*CLR_NONE*/RGB(255, 255, 255), IMAGE_BITMAP, LR_CREATEDIBSECTION));
	m_wndToolBar.GetToolBarCtrl().SetImageList(&img);
	img.Detach();

	m_wndToolBar.SetSizes(CSize(WIDTH_ICON_DRAFT+7, HEIGHT_ICON_DRAFT+6), CSize(WIDTH_ICON_DRAFT, HEIGHT_ICON_DRAFT));

	m_wndToolBar.SetButtons(NULL, 6);

	m_wndToolBar.SetButtonInfo(0, ID_SEND_MAIL, TBSTYLE_BUTTON, 0);
	m_wndToolBar.SetButtonInfo(1, ID_ADD_FILE, TBSTYLE_BUTTON, 1);
	m_wndToolBar.SetButtonInfo(2, ID_DRAFT_GPG, TBSTYLE_BUTTON, 2);
	m_wndToolBar.SetButtonInfo(3, ID_DRAFT_ADDRESS, TBSTYLE_BUTTON, 3);
	m_wndToolBar.SetButtonInfo(4, ID_SAVE_TO_DRAFT, TBSTYLE_BUTTON, 4);
	m_wndToolBar.SetButtonInfo(5, ID_DRAFT_EXT_EDITOR, TBSTYLE_BUTTON, 5);

	// dropdown menu
    m_wndToolBar.GetToolBarCtrl().SetExtendedStyle(TBSTYLE_EX_DRAWDDARROWS);
	// gpg
	this->m_wndToolBar.GetToolBarCtrl().SetExtendedStyle(TBSTYLE_EX_DRAWDDARROWS);
	DWORD style = this->m_wndToolBar.GetButtonStyle(m_wndToolBar.CommandToIndex(ID_DRAFT_GPG));
	style |= TBSTYLE_DROPDOWN;
	this->m_wndToolBar.SetButtonStyle(m_wndToolBar.CommandToIndex(ID_DRAFT_GPG), style);

	return TRUE;
}

BOOL CDraftFrame::SaveToDraft(BOOL confirm)
{
	CPochyApp *app = (CPochyApp*)AfxGetApp();
	CMainFrame *mf = (CMainFrame *)app->m_pMainWnd;
	CSummaryView *sv = mf->m_pListV;
	CString path = app->m_app_path+"\\"+m_account+"\\draft";

	CString body;
	m_pEditV->GetText(body);

	m_me.SetTo(m_pAddrsV->GetTo());
	m_me.SetCc(m_pAddrsV->GetCc());
	m_me.SetBcc(m_pAddrsV->GetBcc());
	m_me.SetFrom(m_pAddrsV->GetFrom());
	m_me.SetSubject(m_pAddrsV->GetSubject());
	m_me.SetReplyTo(m_pAddrsV->GetReplyTo());
	CTime time = CTime::GetCurrentTime();
	m_me.SetDate(time.Format("%d %b %Y %H:%M:%S ")+DEF_TIME_ZONE);

	// setting body.
	if(m_me.GetMode() == ME_MODE_NONE)
		m_me.SetMultipartBody(0, body);

	// need or not confirmation dialog.
	if(confirm){
		CString message;
		message.Format("%s\r\n\r\ndraft֕ۑ܂H", m_me.GetSubject());
		int check = this->MessageBox(message, "[̕ۑ", MB_YESNOCANCEL);
		if(check == IDYES){
			sv->SaveMail(path, m_me.GetMail(ME_GET_DRAFT), SMRY_STATUS_NONE, SMRY_COLUMN_TO);
		}else if(check == IDCANCEL){
			return FALSE;
		}
	}else{
		sv->SaveMail(path, m_me.GetMail(ME_GET_DRAFT), SMRY_STATUS_NONE, SMRY_COLUMN_TO);
	}
	return TRUE;
}

void CDraftFrame::OnDestroy() 
{
	WINDOWPLACEMENT wndPlace;
	GetWindowPlacement(&wndPlace);

	// save window position in ini file.
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	app->WriteProfileInt("DraftWndPlace", "Left", wndPlace.rcNormalPosition.left);
	app->WriteProfileInt("DraftWndPlace", "Top", wndPlace.rcNormalPosition.top);
	app->WriteProfileInt("DraftWndPlace", "Right", wndPlace.rcNormalPosition.right);
	app->WriteProfileInt("DraftWndPlace", "Bottom", wndPlace.rcNormalPosition.bottom);

	// save window status in ini file (maximum, iconize, other)
	if(this->IsZoomed())
		app->WriteProfileInt("DraftWndPlace", "Zoom", 1);
	else if(this->IsIconic()) 
		app->WriteProfileInt("DraftWndPlace", "Zoom", 1);
	else 
		app->WriteProfileInt("DraftWndPlace", "Zoom", 0);

	CFrameWnd::OnDestroy();
}

void CDraftFrame::OnChangeBkColorDraft() 
{

}

void CDraftFrame::OnChangeTxtColorDraft() 
{

}

void CDraftFrame::OnToolbarDropDown(NMTOOLBAR* pnmtb, LRESULT *plr)
{
	CWnd *pWnd;
	UINT nID;

	// Switch on button command id's
	switch (pnmtb->iItem){
	case ID_DRAFT_GPG:
		pWnd = &m_wndToolBar;
		nID  = IDR_DRAFTFRAME_POPUP_GPG;
		break;
	default:
		return;
	}

	// load and display popup menu
	CMenu menu;
	menu.LoadMenu(nID);
	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup);

	CRect rc;
	pWnd->SendMessage(TB_GETRECT, pnmtb->iItem, (LPARAM)&rc);
	pWnd->ClientToScreen(&rc);

	pPopup->TrackPopupMenu( TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_VERTICAL, rc.left, rc.bottom, this, &rc);
}

BOOL CDraftFrame::PreCreateWindow(CREATESTRUCT& cs) 
{
    // EBhENXo^
    // EBhE₷Ȃ邩HOOG
	if (cs.lpszName){
		WNDCLASS wc;
		::GetClassInfo(AfxGetInstanceHandle(), cs.lpszClass, &wc);
		// _T()ň͂ĂȂdebug[hŎsiHj
		wc.lpszClassName = _T("_PochyClass"); // DȖOݒ
		AfxRegisterClass(&wc);
		cs.lpszClass = wc.lpszClassName;
	}

	BOOL r = CFrameWnd::PreCreateWindow(cs);
	cs.style ^= FWS_ADDTOTITLE;
	return r;
}

void CDraftFrame::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI)
{
	lpMMI->ptMinTrackSize.x = 200;
//	lpMMI->ptMinTrackSize.y = 0;
	// minimum size of window

//	lpMMI->ptMaxTrackSize.x = ;
//	lpMMI->ptMaxTrackSize.y = ;
	// maximum size of window
}

void CDraftFrame::OnExtEditor()
{
	AfxBeginThread(ExEditor, this);

}

void CDraftFrame::ReArrangeSplit()
{
	CRect rect;
	m_wndSplit.GetClientRect(&rect);
	rect.NormalizeRect();
	int height = rect.Height()-4/* may be width of frame */;
	rect.SetRectEmpty();

	m_wndSplit.SetRowInfo(0, height-HT_ATTACHED_HEIGHT, 0);
	m_wndSplit.RecalcLayout();

	this->Invalidate(FALSE);
}

void CDraftFrame::HideAttachedFileView(BOOL b)
{
	if(b && m_hide_attach == FALSE){
		m_wndSplit.HideRow(1);
		m_hide_attach = TRUE;
		this->Invalidate(FALSE);
	}else if(!b && m_hide_attach == TRUE){
		m_wndSplit.ShowRow();
		m_hide_attach = FALSE;
		this->Invalidate(FALSE);
	}
}

void CDraftFrame::DisableButton(BOOL b)
{
	
}

void CDraftFrame::OnGpgKeyManagement() 
{
	CGpgDlg gd;
	gd.DoModal();
}

BOOL CDraftFrame::OnCopyData(CWnd* pWnd, COPYDATASTRUCT* pCopyDataStruct) 
{
	if(pCopyDataStruct->dwData == WM_TITLE){
		CString title = (char *)pCopyDataStruct->lpData;
		this->SetWindowText(title);
	}
	return CFrameWnd::OnCopyData(pWnd, pCopyDataStruct);
}

void CDraftFrame::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	this->Char(nChar, NULL);
	CFrameWnd::OnChar(nChar, nRepCnt, nFlags);
}

void CDraftFrame::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	this->KeyDown(nChar, NULL);
	CFrameWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}
