// Background Bitmap Tree View class - Copyright(C) 2003 minamina
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <assert.h>
#include "BitmapTreeView.h"
#include "MemoryDC.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBitmapTreeView

IMPLEMENT_DYNCREATE(CBitmapTreeView, CTreeView)

CBitmapTreeView::CBitmapTreeView()
{
}

CBitmapTreeView::~CBitmapTreeView()
{
}

BEGIN_MESSAGE_MAP(CBitmapTreeView, CTreeView)
	//{{AFX_MSG_MAP(CBitmapTreeView)
	ON_WM_ERASEBKGND()
	ON_WM_PAINT()
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
	ON_NOTIFY_REFLECT(TVN_ITEMEXPANDING, OnItemexpanding)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBitmapTreeView bZ[W nh

// \[Xwi摜ݒ
bool CBitmapTreeView::SetBkImage(WORD wResourceID)
{
	assert(m_hWnd != NULL);

	bool bResult = false;

	HDC hDC = ::GetDC(m_hWnd);
	bResult = m_bkBitmapDC.CreateFromBitmap(hDC, ::AfxGetInstanceHandle(), wResourceID);
	::ReleaseDC(m_hWnd, hDC);

	return bResult;
}

// t@C烊\[X摜ݒ
bool CBitmapTreeView::SetBkImage(LPCTSTR lpszFilename)
{
	assert(m_hWnd != NULL);

	bool bResult = false;

	HDC hDC = ::GetDC(m_hWnd);
	bResult = m_bkBitmapDC.CreateFromBitmap(hDC, lpszFilename);
	::ReleaseDC(m_hWnd, hDC);

	return bResult;
}

bool CBitmapTreeView::HasBkBitmap()
{
	return m_bkBitmapDC.IsValid();
}

BOOL CBitmapTreeView::OnEraseBkgnd(CDC* pDC) 
{
	if (HasBkBitmap())
	{
		return TRUE;
	}

	return CTreeView::OnEraseBkgnd(pDC);
}

void CBitmapTreeView::OnPaint() 
{
	if (!HasBkBitmap())
	{
		CTreeView::OnPaint();
	}
	else
	{
		CPaintDC dc(this);

		CRect clipBoxRect, clientRect;
		dc.GetClipBox(&clipBoxRect);
		GetClientRect(&clientRect);

		const int nWidth = clientRect.Width();
		const int nHeight = clientRect.Height();

		HDC hDC = dc.GetSafeHdc();

		CMemoryDC memDC, maskDC;
		if (memDC.Create(hDC, nWidth, nHeight) &&
			maskDC.Create(hDC, nWidth, nHeight))
		{
			WORD wBitsPixel = memDC.GetBitmap().bmBitsPixel;
			wBitsPixel = (wBitsPixel <= 16) ? static_cast<WORD>(16) : static_cast<WORD>(32);

			// c[r[`悵ĕۑ
			CMemoryDC memDCDIB;
			if (memDCDIB.CreateDIB(hDC, nWidth, nHeight, wBitsPixel))
			{
				CWnd::DefWindowProc(WM_PAINT, (WPARAM)memDCDIB.GetDC(), 0);
				::BitBlt(memDC.GetDC(), 0, 0, nWidth, nHeight,
					memDCDIB.GetDC(), 0, 0, SRCCOPY);
			}
			// }XNĕۑ
			CMemoryDC* pMaskDCDIB = memDCDIB.CreateMaskDC(GetTreeCtrl().GetBkColor());
			if (pMaskDCDIB != NULL)
			{
				::BitBlt(maskDC.GetDC(), 0, 0, nWidth, nHeight,
					pMaskDCDIB->GetDC(), 0, 0, SRCCOPY);
				delete pMaskDCDIB;
			}
		}

		CMemoryDC tileDC;
		if (tileDC.Create(hDC, nWidth, nHeight))
		{
			CRect rootRect;
			GetTreeCtrl().GetItemRect(GetTreeCtrl().GetRootItem(), &rootRect, FALSE);
			rootRect.left = -GetScrollPos(SB_HORZ);

			// wi^Cɕ`悵ĕۑ
			int nX, nY, nBitmapWidth, nBitmapHeight;
			nBitmapWidth = m_bkBitmapDC.GetBitmap().bmWidth;
			nBitmapHeight = m_bkBitmapDC.GetBitmap().bmHeight;
			for (nY = rootRect.top; nY < clientRect.bottom; nY += nBitmapHeight)
			{
				for (nX = rootRect.left; nX < clientRect.right; nX += nBitmapWidth)
				{
					::BitBlt(tileDC.GetDC(), nX, nY, nBitmapWidth, nBitmapHeight,
						m_bkBitmapDC.GetDC(), 0, 0, SRCCOPY);
				}
			}
		}

		// gݍ킹
		if (memDC.IsValid() && maskDC.IsValid() && tileDC.IsValid())
		{
			::BitBlt(memDC.GetDC(), clipBoxRect.left, clipBoxRect.top, clipBoxRect.Width(), clipBoxRect.Height(),
				maskDC.GetDC(), clipBoxRect.left, clipBoxRect.top, SRCAND);

			::BitBlt(maskDC.GetDC(), clipBoxRect.left, clipBoxRect.top, clipBoxRect.Width(), clipBoxRect.Height(),
				tileDC.GetDC(), clipBoxRect.left, clipBoxRect.top, SRCERASE);

			::BitBlt(memDC.GetDC(), clipBoxRect.left, clipBoxRect.top, clipBoxRect.Width(), clipBoxRect.Height(),
				maskDC.GetDC(), clipBoxRect.left, clipBoxRect.top, SRCPAINT);
		}

		::BitBlt(hDC, 0, 0, nWidth, nHeight, memDC.GetDC(), 0, 0, SRCCOPY);
	}
}

void CBitmapTreeView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	if (HasBkBitmap())
	{
		InvalidateRect(NULL);
	}
	
	CTreeView::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CBitmapTreeView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	if (HasBkBitmap())
	{
		InvalidateRect(NULL);
	}
	
	CTreeView::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CBitmapTreeView::OnItemexpanding(NMHDR* /*pNMHDR*/, LRESULT* pResult) 
{
//	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;

	if (HasBkBitmap())
	{
		InvalidateRect(NULL);
	}
	
	*pResult = 0;
}
