/*
 * Copyright (C) 2002-2003 chik, s.hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// Sock.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "Sock.h"

#ifdef _IPV6_
#include "ws2tcpip.h"
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSock

CSock::CSock()
{
	WSADATA wsaData;
	WSAStartup(MAKEWORD(1,1), &wsaData);
}

CSock::~CSock()
{
}

// ClassWizard KvƂȉ̍sҏWȂłB
#if 0
BEGIN_MESSAGE_MAP(CSock, CSocket)
	//{{AFX_MSG_MAP(CSock)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif	// 0

/////////////////////////////////////////////////////////////////////////////
// CSock o֐

void CSock::DisConnect()
{
	closesocket(m_sock);
	WSACleanup();
}

int CSock::SockRead(CString& out)
{
	char buf[1024];
	LPSTR end;
	int n;
	out.Empty();

	do{
		if((n = recv(m_sock, buf, sizeof(buf)-1, MSG_PEEK)) <= 0)
			return(-1);
		if((end = (char *)memchr(buf, '\n', n)) != NULL)
			n = end-buf+1;			
		if((n = recv(m_sock, buf, n, 0)) == -1)
			return(-1);
		buf[n] = '\0';
		out += buf;
	}while(!end);
	return out.GetLength();
}

#ifndef _IPV6_
int CSock::GetIP(LPCTSTR addr, LPSTR ip)
{
	unsigned long addr_32bit;	// ip address
	struct hostent *hostent;
	IN_ADDR in;

	addr_32bit = inet_addr(addr);
	if(addr_32bit == -1){
		hostent = gethostbyname(addr);
		if(hostent == NULL){
			return 0;
		}else{
			memcpy(&in, hostent->h_addr_list[0], 4);
			strcpy(ip, inet_ntoa(in));
			return strlen(ip);
		}
	}
	strcpy(ip, addr);
	return strlen(ip);
}
#endif

int CSock::Connect6(char *server_name, char *port)
{
#ifdef _IPV6_
	ADDRINFO hints, *ai, *ai_tmp;

	memset(&hints, 0, sizeof(hints));
	hints.ai_family = PF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;

	if(getaddrinfo(server_name, port, &hints, &ai) != 0){
		return INVALID_SOCKET;
	}

	for(ai_tmp = ai; ai_tmp != NULL; ai_tmp = ai_tmp->ai_next){
		m_sock = socket(ai_tmp->ai_family, ai_tmp->ai_socktype, ai_tmp->ai_protocol);
		if(m_sock == INVALID_SOCKET){
			continue;
		}
		break;
	}

	if(m_sock == INVALID_SOCKET)
		return INVALID_SOCKET;

	int result = connect(m_sock, ai_tmp->ai_addr, ai_tmp->ai_addrlen);
	if(SOCKET_ERROR == result){
		return INVALID_SOCKET;
	}
#else
	CString ip;
	int len;
	if((len = this->GetIP(server_name, ip.GetBuffer(20))) == 0)
		return INVALID_SOCKET;

	ip.ReleaseBuffer(len);

	SOCKADDR_IN sockad;
	int result;

	m_sock = socket(AF_INET, SOCK_STREAM, 0);

	sockad.sin_family = AF_INET;
	sockad.sin_addr.s_addr = inet_addr(ip);
	sockad.sin_port = htons(atoi(port));

	result = connect(m_sock, (PSOCKADDR)&sockad, sizeof(sockad));
#endif

	return result;
}
