/*
 * Copyright (C) 2002-2003 chik, hiranaka
 * For license terms, see the file COPYING in this directory.
 */

#include "stdafx.h"
#include "pochy.h"
#include "AddressView.h"
#include "DraftAddressBookDlg.h"
#include "Csv.h"
#include "lib.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAddressView

IMPLEMENT_DYNCREATE(CAddressView, CFormView)

CAddressView::CAddressView()
	: CFormView(CAddressView::IDD)
{
	//{{AFX_DATA_INIT(CAddressView)
		// : ClassWizard ͂̈ʒuɃȍǉ܂
	//}}AFX_DATA_INIT
	m_index_address = 0;
}

CAddressView::~CAddressView()
{
}

void CAddressView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddressView)
	DDX_Control(pDX, IDC_SUBJECT, m_subject);
	DDX_Control(pDX, IDC_REPLY_TO, m_reply_to);
	DDX_Control(pDX, IDC_FROM, m_from);
	DDX_Control(pDX, IDC_CC, m_cc);
	DDX_Control(pDX, IDC_BCC, m_bcc);
	DDX_Control(pDX, IDC_TO, m_to);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAddressView, CFormView)
	//{{AFX_MSG_MAP(CAddressView)
	ON_WM_SIZE()
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_BUTTON_TO, OnTo)
	ON_BN_CLICKED(IDC_BUTTON_CC, OnCc)
	ON_BN_CLICKED(IDC_BUTTON_BCC, OnBcc)
	ON_COMMAND(ID_ADDRESS_COMPLEMENT, Complete)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddressView ff

#ifdef _DEBUG
void CAddressView::AssertValid() const
{
	CFormView::AssertValid();
}

void CAddressView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAddressView bZ[W nh

void CAddressView::OnInitialUpdate() 
{
	CFormView::OnInitialUpdate();

	CDraftFrame* df = (CDraftFrame*)GetParentFrame();

	this->SetDlgItemText(IDC_TO, df->m_me.GetTo());
	this->SetDlgItemText(IDC_FROM, df->m_me.GetFrom());
	this->SetDlgItemText(IDC_SUBJECT, df->m_me.GetSubject());
	this->SetDlgItemText(IDC_CC, df->m_me.GetCc());
	this->SetDlgItemText(IDC_BCC, df->m_me.GetBcc());

/*	CWnd *wnd;
	wnd = this->GetDlgItem(IDC_STATIC_SUBJECT);
	wnd->setd*/


	if(!df->m_me.GetReplyTo().IsEmpty())
		this->SetDlgItemText(IDC_REPLY_TO, df->m_me.GetReplyTo());
}

void CAddressView::OnSize(UINT nType, int cx, int cy) 
{
	CFormView::OnSize(nType, cx, cy);

	CRect rect1;
	this->GetWindowRect(rect1);
	ScreenToClient(&rect1);

	CRect rect2;
	CRect rect3;
	CWnd *wnd;
	wnd = this->GetDlgItem(IDC_TO);
	if(wnd != NULL){
		wnd->GetWindowRect(rect2);
		ScreenToClient(&rect2);
		rect2.right = rect1.right-6;
		wnd->MoveWindow(rect2);
	}
	wnd = this->GetDlgItem(IDC_CC);
	if(wnd != NULL){
		wnd->GetWindowRect(rect2);
		ScreenToClient(&rect2);
		rect2.right = rect1.right-6;
		wnd->MoveWindow(rect2);
	}
	wnd = this->GetDlgItem(IDC_BCC);
	if(wnd != NULL){
		wnd->GetWindowRect(rect2);
		ScreenToClient(&rect2);
		rect2.right = rect1.right-6;
		wnd->MoveWindow(rect2);
	}
	wnd = this->GetDlgItem(IDC_SUBJECT);
	if(wnd != NULL){
		wnd->GetWindowRect(rect2);
		ScreenToClient(&rect2);
		rect2.right = rect1.right-6;
		wnd->MoveWindow(rect2);
	}
	wnd = this->GetDlgItem(IDC_REPLY_TO);
	if(wnd != NULL){
		wnd->GetWindowRect(rect2);
		ScreenToClient(&rect2);
		rect2.right = rect1.right/2-5;
		wnd->MoveWindow(rect2);
	}
	wnd = this->GetDlgItem(IDC_STATIC_FROM);
	if(wnd != NULL){
		wnd->GetWindowRect(rect3);
		ScreenToClient(&rect3);
		int l=rect3.right-rect3.left;
		rect3.left = rect2.right+6;
		rect3.right = rect3.left+l;
		wnd->MoveWindow(rect3);
	}
	wnd = this->GetDlgItem(IDC_FROM);
	if(wnd != NULL){
		wnd->GetWindowRect(rect2);
		ScreenToClient(&rect2);
		rect2.left = rect3.right+5;
		rect2.right = rect1.right-6;
		wnd->MoveWindow(rect2);
	}
	wnd = this->GetDlgItem(IDC_STATIC_SUBJECT);
	if(wnd != NULL){
		wnd->Invalidate();
		wnd->UpdateWindow();
	}
}

BOOL CAddressView::PreCreateWindow(CREATESTRUCT& cs) 
{
//	BOOL r = CFormView::PreCreateWindow(cs);
//	cs.style &= ~(WS_VSCROLL | WS_HSCROLL);
//	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;

	return CFormView::PreCreateWindow(cs);
}

CString CAddressView::GetTo()
{
	CString to;
	this->GetDlgItemText(IDC_TO, to);
	return to;
}

CString CAddressView::GetCc()
{
	CString cc;
	this->GetDlgItemText(IDC_CC, cc);
	return cc;
}

CString CAddressView::GetBcc()
{
	CString bcc;
	this->GetDlgItemText(IDC_BCC, bcc);
	return bcc;
}

CString CAddressView::GetSubject()
{
	CString subject;
	this->GetDlgItemText(IDC_SUBJECT, subject);
	return subject;
}

CString CAddressView::GetReplyTo()
{
	CString reply_to;
	this->GetDlgItemText(IDC_REPLY_TO, reply_to);
	return reply_to;
}

CString CAddressView::GetFrom()
{
	CString from;
	this->GetDlgItemText(IDC_FROM, from);
	return from;
}

BOOL CAddressView::PreTranslateMessage(MSG* pMsg) 
{
	CPochyApp* app = (CPochyApp*)AfxGetApp();
	if(app->GetProfileInt("Customize", "MewKeyBind", 0)){
		CDraftFrame* df = (CDraftFrame*)GetParentFrame();
		if(pMsg->message == WM_CHAR){
			if(df->Char(pMsg->wParam, this))
				return TRUE;
		}
		if(pMsg->message == WM_KEYDOWN){

			if(df->KeyDown(pMsg->wParam, this))
				return TRUE;

			if(pMsg->wParam == VK_TAB){
				this->Complete();
				return TRUE;
			}
			else if(pMsg->wParam == VK_RETURN){
				CEdit *edit = this->GetFocusedEditCtrl();
				if(edit != NULL){
					edit->SetSel(edit->GetWindowTextLength(), edit->GetWindowTextLength());
				}
				return TRUE;
			}
			else if(pMsg->wParam == 40/*pressing [PgDn] work as pressing [TAB]*/){
				pMsg->wParam = VK_TAB;
			}
		}
	} else {
		CDraftFrame* df = (CDraftFrame*)GetParentFrame();
		if(pMsg->message == WM_KEYDOWN){
			/*
			if((pMsg->wParam>=0x30 && pMsg->wParam <= 0x39) || (pMsg->wParam>=0x41 && pMsg->wParam <= 0x5A)){
				this->Complete();
			}
			*/
			if(pMsg->wParam == VK_UP || pMsg->wParam == VK_DOWN){
				this->Complete();
				return TRUE;
			}
		}
	}

	return CFormView::PreTranslateMessage(pMsg);
}

void CAddressView::Complete()
{
	CEdit *edit = this->GetFocusedEditCtrl();
	if(edit == NULL){
		return;
	}

	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CCsv csv(app->m_app_path+"\\address.csv");

	int start, end;
	edit->GetSel(start, end);

	CString buf;
	edit->GetWindowText(buf);

	int i;
	int n;
	CString piece;
	CString address;
	int nLength = buf.GetLength();
	if((n = buf.ReverseFind(',')) != -1){
		n++;
		while(n < nLength && (buf[n] == ' ' || buf[n] == '\t'))  /* 󔒂ǂݔ΂ */
			++n;
		CString left = buf.Left(n);
		CString right = buf.Mid(n);
		if(start == end){
			piece = right;
			for(i=0; i<csv.GetRowSize(); i++){
				address = csv.GetValue(i, 1);
				if(address.Find(piece) == 0){
					edit->SetWindowText(left+address);
					edit->SetSel(buf.GetLength(), -1);
					this->m_complete_next = i+1;
					break;
				}
			}
		}else if(start != end && end == buf.GetLength()){
			piece = right.Left(start-(n+2));
			for(i=this->m_complete_next; i<csv.GetRowSize(); i++){
				address = csv.GetValue(i, 1);
				if(address.Find(piece) == 0){
					edit->SetWindowText(left+address);
					edit->SetSel(start, -1);
					this->m_complete_next = i+1;
					break;
				}
			}
			if(i == csv.GetRowSize()){
				edit->SetWindowText(left+piece);
				edit->SetSel(left.GetLength()+piece.GetLength(), -1);
			}
		}
	}else{
		piece = buf;
		if(start == end){
			for(i=0; i<csv.GetRowSize(); i++){
				address = csv.GetValue(i, 1);
				if(address.Find(piece) == 0){
					edit->SetWindowText(address);
					edit->SetSel(start, -1);
					this->m_complete_next = i+1;
					break;
				}
			}
		}else if(start != end && end == piece.GetLength()){
			for(i=this->m_complete_next; i<csv.GetRowSize(); i++){
				address = csv.GetValue(i, 1);
				if(address.Find(piece.Left(start)) == 0){
					edit->SetWindowText(address);
					edit->SetSel(start, -1);
					this->m_complete_next = i+1;
					break;
				}
			}
			if(i == csv.GetRowSize() && end == piece.GetLength()){
				piece = piece.Left(start);
				edit->SetWindowText(piece);
				edit->SetSel(start, start);
			}
		}
	}
}

HBRUSH CAddressView::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CFormView::OnCtlColor(pDC, pWnd, nCtlColor);
	
	// TODO: here you can change DC attribute.	
/*	switch(nCtlColor){
	case CTLCOLOR_BTN:
	case CTLCOLOR_STATIC:
		pDC->SetBkMode(TRANSPARENT);
	case CTLCOLOR_DLG:
		m_br.DeleteObject();
		return (HBRUSH)m_br.GetSafeHandle();
	default:
		break;
	}*/
	// TODO: here you can change default brush.
	return hbr;
}

void CAddressView::OnTo() 
{
	CDraftFrame* df = (CDraftFrame*)GetParentFrame();

	df->m_me.SetTo(GetTo());
	df->m_me.SetCc(GetCc());
	df->m_me.SetBcc(GetBcc());
	df->m_me.SetFrom(GetFrom());
	df->m_me.SetSubject(GetSubject());
	df->m_me.SetReplyTo(GetReplyTo());

	CStringArray to;
	CStringArray cc;
	CStringArray bcc;

	this->SplitAddress(df->m_me.GetTo(), to);
	this->SplitAddress(df->m_me.GetCc(), cc);
	this->SplitAddress(df->m_me.GetBcc(), bcc);

	int i;
	for(i=0; i<to.GetSize(); i++){
		if(to.GetAt(i).IsEmpty())
			to.RemoveAt(i);
	}
	for(i=0; i<cc.GetSize(); i++){
		if(cc.GetAt(i).IsEmpty())
			cc.RemoveAt(i);
	}
	for(i=0; i<bcc.GetSize(); i++){
		if(bcc.GetAt(i).IsEmpty())
			bcc.RemoveAt(i);
	}

	CDraftAddressBookDlg ad(this); // parent window is designated in constructor
	ad.SetTo(to);
	ad.SetCc(cc);
	ad.SetBcc(bcc);
	ad.SetMode(ADDRESS_MODE_TO);
	ad.DoModal();
}

void CAddressView::OnCc()
{
	CDraftFrame* df = (CDraftFrame*)GetParentFrame();

	df->m_me.SetTo(GetTo());
	df->m_me.SetCc(GetCc());
	df->m_me.SetBcc(GetBcc());
	df->m_me.SetFrom(GetFrom());
	df->m_me.SetSubject(GetSubject());
	df->m_me.SetReplyTo(GetReplyTo());

	CStringArray to;
	CStringArray cc;
	CStringArray bcc;

	this->SplitAddress(df->m_me.GetTo(), to);
	this->SplitAddress(df->m_me.GetCc(), cc);
	this->SplitAddress(df->m_me.GetBcc(), bcc);

	int i;
	for(i=0; i<to.GetSize(); i++){
		if(to.GetAt(i).IsEmpty())
			to.RemoveAt(i);
	}
	for(i=0; i<cc.GetSize(); i++){
		if(cc.GetAt(i).IsEmpty())
			cc.RemoveAt(i);
	}
	for(i=0; i<bcc.GetSize(); i++){
		if(bcc.GetAt(i).IsEmpty())
			bcc.RemoveAt(i);
	}

	CDraftAddressBookDlg ad(this); // parent window of CDraftAddressBookDlg is designated in constructor
	ad.SetTo(to);
	ad.SetCc(cc);
	ad.SetBcc(bcc);
	ad.SetMode(ADDRESS_MODE_CC);
	ad.DoModal();
}

void CAddressView::OnBcc() 
{
	CDraftFrame* df = (CDraftFrame*)GetParentFrame();

	df->m_me.SetTo(GetTo());
	df->m_me.SetCc(GetCc());
	df->m_me.SetBcc(GetBcc());
	df->m_me.SetFrom(GetFrom());
	df->m_me.SetSubject(GetSubject());
	df->m_me.SetReplyTo(GetReplyTo());

	CStringArray to;
	CStringArray cc;
	CStringArray bcc;

	this->SplitAddress(df->m_me.GetTo(), to);
	this->SplitAddress(df->m_me.GetCc(), cc);
	this->SplitAddress(df->m_me.GetBcc(), bcc);

	int i;
	for(i=0; i<to.GetSize(); i++){
		if(to.GetAt(i).IsEmpty())
			to.RemoveAt(i);
	}
	for(i=0; i<cc.GetSize(); i++){
		if(cc.GetAt(i).IsEmpty())
			cc.RemoveAt(i);
	}
	for(i=0; i<bcc.GetSize(); i++){
		if(bcc.GetAt(i).IsEmpty())
			bcc.RemoveAt(i);
	}

	CDraftAddressBookDlg ad(this); // parent window of CDraftAddressBookDlg is designated in constructor
	ad.SetTo(to);
	ad.SetCc(cc);
	ad.SetBcc(bcc);
	ad.SetMode(ADDRESS_MODE_BCC);
	ad.DoModal();
}

void CAddressView::SplitAddress(CString &cstr, CStringArray &cstra)
{
	CString buf;
	BOOL quotation = FALSE;

	for(int n=0; n < cstr.GetLength(); n++){
		// in case that comment exit in each address field.
		if(cstr[n] == '"'){
			if(quotation == TRUE) quotation = FALSE;
			else quotation = TRUE;
		}
		if(!quotation && cstr[n] == ','){
			cstra.Add(buf);
			buf.Empty();
			continue;
		}
		buf += cstr[n];
	}
	cstra.Add(buf);
}

CEdit *CAddressView::GetFocusedEditCtrl()
{
	CEdit *edit;

	if(this->GetFocus()->m_hWnd == m_to.m_hWnd){
		edit = (CEdit *)this->GetDlgItem(IDC_TO);
	}else if(this->GetFocus()->m_hWnd == m_cc.m_hWnd){
		edit = (CEdit *)this->GetDlgItem(IDC_CC);
	}else if(this->GetFocus()->m_hWnd == m_bcc.m_hWnd){
		edit = (CEdit *)this->GetDlgItem(IDC_BCC);
	}else if(this->GetFocus()->m_hWnd == m_from.m_hWnd){
		edit = (CEdit *)this->GetDlgItem(IDC_FROM);
	}else if(this->GetFocus()->m_hWnd == m_reply_to.m_hWnd){
		edit = (CEdit *)this->GetDlgItem(IDC_REPLY_TO);
	}else{
		// not focus any ecit control, do nothing.
		edit = NULL;
	}
	return edit;
}

void CAddressView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	// change background color
	m_br.DeleteObject();
	m_br.CreateSolidBrush(RGB(0,0,0));
	this->Invalidate(TRUE);
	this->UpdateWindow();
}
