/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.List;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordBase;
import org.apache.poi.hssf.record.aggregates.ColumnInfoRecordsAggregate;
import org.apache.poi.hssf.record.aggregates.ConditionalFormattingTable;
import org.apache.poi.hssf.record.aggregates.DataValidityTable;
import org.apache.poi.hssf.record.aggregates.MergedCellsTable;
import org.apache.poi.hssf.record.aggregates.PageSettingsBlock;

final class RecordOrderer {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    private RecordOrderer() {
    }

    public static void addNewSheetRecord(List sheetRecords, RecordBase newRecord) {
        int index = RecordOrderer.findSheetInsertPos(sheetRecords, newRecord.getClass());
        sheetRecords.add(index, newRecord);
    }

    private static int findSheetInsertPos(List records, Class recClass) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hssf.record.aggregates.DataValidityTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (recClass == clazz) {
            return RecordOrderer.findDataValidationTableInsertPos(records);
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.apache.poi.hssf.record.aggregates.MergedCellsTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (recClass == clazz2) {
            return RecordOrderer.findInsertPosForNewMergedRecordTable(records);
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.apache.poi.hssf.record.aggregates.ConditionalFormattingTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (recClass == clazz3) {
            return RecordOrderer.findInsertPosForNewCondFormatTable(records);
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.apache.poi.hssf.record.GutsRecord");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (recClass == clazz4) {
            return RecordOrderer.getGutsRecordInsertPos(records);
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.apache.poi.hssf.record.aggregates.PageSettingsBlock");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (recClass == clazz5) {
            return RecordOrderer.getPageBreakRecordInsertPos(records);
        }
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.apache.poi.hssf.record.aggregates.WorksheetProtectionBlock");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (recClass == clazz6) {
            return RecordOrderer.getWorksheetProtectionBlockInsertPos(records);
        }
        throw new RuntimeException("Unexpected record class (" + recClass.getName() + ")");
    }

    private static int getWorksheetProtectionBlockInsertPos(List records) {
        int i = RecordOrderer.getDimensionsIndex(records);
        while (i > 0) {
            Object rb;
            if (RecordOrderer.isProtectionSubsequentRecord(rb = records.get(--i))) continue;
            return i + 1;
        }
        throw new IllegalStateException("did not find insert pos for protection block");
    }

    private static boolean isProtectionSubsequentRecord(Object rb) {
        if (rb instanceof ColumnInfoRecordsAggregate) {
            return true;
        }
        if (rb instanceof Record) {
            Record record = (Record)rb;
            switch (record.getSid()) {
                case 85: 
                case 144: {
                    return true;
                }
            }
        }
        return false;
    }

    private static int getPageBreakRecordInsertPos(List records) {
        int dimensionsIndex = RecordOrderer.getDimensionsIndex(records);
        int i = dimensionsIndex - 1;
        while (i > 0) {
            Object rb;
            if (!RecordOrderer.isPageBreakPriorRecord(rb = records.get(--i))) continue;
            return i + 1;
        }
        throw new RuntimeException("Did not find insert point for GUTS");
    }

    private static boolean isPageBreakPriorRecord(Object rb) {
        if (rb instanceof Record) {
            Record record = (Record)rb;
            switch (record.getSid()) {
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 34: 
                case 42: 
                case 43: 
                case 94: 
                case 95: 
                case 129: 
                case 130: 
                case 523: 
                case 549: 
                case 2057: {
                    return true;
                }
            }
        }
        return false;
    }

    private static int findInsertPosForNewCondFormatTable(List records) {
        int i = records.size() - 2;
        while (i >= 0) {
            Object rb = records.get(i);
            if (rb instanceof MergedCellsTable) {
                return i + 1;
            }
            if (!(rb instanceof DataValidityTable)) {
                Record rec = (Record)rb;
                switch (rec.getSid()) {
                    case 29: 
                    case 65: 
                    case 153: 
                    case 160: 
                    case 239: 
                    case 351: 
                    case 574: {
                        return i + 1;
                    }
                }
            }
            --i;
        }
        throw new RuntimeException("Did not find Window2 record");
    }

    private static int findInsertPosForNewMergedRecordTable(List records) {
        int i = records.size() - 2;
        while (i >= 0) {
            Object rb = records.get(i);
            if (rb instanceof Record) {
                Record rec = (Record)rb;
                switch (rec.getSid()) {
                    case 29: 
                    case 65: 
                    case 153: 
                    case 160: 
                    case 574: {
                        return i + 1;
                    }
                }
            }
            --i;
        }
        throw new RuntimeException("Did not find Window2 record");
    }

    /*
     * Unable to fully structure code
     */
    private static int findDataValidationTableInsertPos(List records) {
        i = records.size() - 1;
        if (records.get(i) instanceof EOFRecord) ** GOTO lbl12
        throw new IllegalStateException("Last sheet record should be EOFRecord");
lbl-1000:
        // 1 sources

        {
            if (RecordOrderer.isDVTPriorRecord(rb = (RecordBase)records.get(--i))) {
                nextRec = (Record)records.get(i + 1);
                if (!RecordOrderer.isDVTSubsequentRecord(nextRec.getSid())) {
                    throw new IllegalStateException("Unexpected (" + nextRec.getClass().getName() + ") found after (" + rb.getClass().getName() + ")");
                }
                return i + 1;
            }
            rec = (Record)rb;
            if (RecordOrderer.isDVTSubsequentRecord(rec.getSid())) continue;
            throw new IllegalStateException("Unexpected (" + rec.getClass().getName() + ") while looking for DV Table insert pos");
lbl12:
            // 2 sources

            ** while (i > 0)
        }
lbl13:
        // 1 sources

        return 0;
    }

    private static boolean isDVTPriorRecord(RecordBase rb) {
        if (rb instanceof MergedCellsTable || rb instanceof ConditionalFormattingTable) {
            return true;
        }
        short sid = ((Record)rb).getSid();
        switch (sid) {
            case 29: 
            case 65: 
            case 153: 
            case 160: 
            case 239: 
            case 351: 
            case 440: 
            case 442: 
            case 574: 
            case 2048: {
                return true;
            }
        }
        return false;
    }

    private static boolean isDVTSubsequentRecord(short sid) {
        switch (sid) {
            case 10: 
            case 2146: 
            case 2151: 
            case 2152: {
                return true;
            }
        }
        return false;
    }

    private static int getDimensionsIndex(List records) {
        int nRecs = records.size();
        int i = 0;
        while (i < nRecs) {
            if (records.get(i) instanceof DimensionsRecord) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("DimensionsRecord not found");
    }

    private static int getGutsRecordInsertPos(List records) {
        int dimensionsIndex = RecordOrderer.getDimensionsIndex(records);
        int i = dimensionsIndex - 1;
        while (i > 0) {
            RecordBase rb;
            if (!RecordOrderer.isGutsPriorRecord(rb = (RecordBase)records.get(--i))) continue;
            return i + 1;
        }
        throw new RuntimeException("Did not find insert point for GUTS");
    }

    private static boolean isGutsPriorRecord(RecordBase rb) {
        if (rb instanceof Record) {
            Record record = (Record)rb;
            switch (record.getSid()) {
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 34: 
                case 42: 
                case 43: 
                case 94: 
                case 95: 
                case 130: 
                case 523: 
                case 2057: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isEndOfRowBlock(int sid) {
        switch (sid) {
            case 61: 
            case 93: 
            case 176: 
            case 236: 
            case 237: 
            case 438: 
            case 574: {
                return true;
            }
            case 434: {
                return true;
            }
            case 10: {
                throw new RuntimeException("Found EOFRecord before WindowTwoRecord was encountered");
            }
        }
        return PageSettingsBlock.isComponentRecord(sid);
    }

    public static boolean isRowBlockRecord(int sid) {
        switch (sid) {
            case 6: 
            case 253: 
            case 513: 
            case 515: 
            case 516: 
            case 517: 
            case 520: 
            case 545: 
            case 566: 
            case 638: 
            case 1212: {
                return true;
            }
        }
        return false;
    }
}

