/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.ss.SpreadsheetVersion;

public final class SheetNameFormatter {
    private static final char DELIMITER = '\'';
    private static final Pattern CELL_REF_PATTERN = Pattern.compile("([A-Za-z]+)([0-9]+)");

    private SheetNameFormatter() {
    }

    public static String format(String rawSheetName) {
        StringBuffer sb = new StringBuffer(rawSheetName.length() + 2);
        SheetNameFormatter.appendFormat(sb, rawSheetName);
        return sb.toString();
    }

    public static void appendFormat(StringBuffer out, String rawSheetName) {
        boolean needsQuotes = SheetNameFormatter.needsDelimiting(rawSheetName);
        if (needsQuotes) {
            out.append('\'');
            SheetNameFormatter.appendAndEscape(out, rawSheetName);
            out.append('\'');
        } else {
            out.append(rawSheetName);
        }
    }

    public static void appendFormat(StringBuffer out, String workbookName, String rawSheetName) {
        boolean needsQuotes;
        boolean bl = needsQuotes = SheetNameFormatter.needsDelimiting(workbookName) || SheetNameFormatter.needsDelimiting(rawSheetName);
        if (needsQuotes) {
            out.append('\'');
            out.append('[');
            SheetNameFormatter.appendAndEscape(out, workbookName.replace('[', '(').replace(']', ')'));
            out.append(']');
            SheetNameFormatter.appendAndEscape(out, rawSheetName);
            out.append('\'');
        } else {
            out.append('[');
            out.append(workbookName);
            out.append(']');
            out.append(rawSheetName);
        }
    }

    private static void appendAndEscape(StringBuffer sb, String rawSheetName) {
        int len = rawSheetName.length();
        int i = 0;
        while (i < len) {
            char ch = rawSheetName.charAt(i);
            if (ch == '\'') {
                sb.append('\'');
            }
            sb.append(ch);
            ++i;
        }
    }

    private static boolean needsDelimiting(String rawSheetName) {
        int len = rawSheetName.length();
        if (len < 1) {
            throw new RuntimeException("Zero length string is an invalid sheet name");
        }
        if (Character.isDigit(rawSheetName.charAt(0))) {
            return true;
        }
        int i = 0;
        while (i < len) {
            char ch = rawSheetName.charAt(i);
            if (SheetNameFormatter.isSpecialChar(ch)) {
                return true;
            }
            ++i;
        }
        if (Character.isLetter(rawSheetName.charAt(0)) && Character.isDigit(rawSheetName.charAt(len - 1)) && SheetNameFormatter.nameLooksLikePlainCellReference(rawSheetName)) {
            return true;
        }
        return SheetNameFormatter.nameLooksLikeBooleanLiteral(rawSheetName);
    }

    private static boolean nameLooksLikeBooleanLiteral(String rawSheetName) {
        switch (rawSheetName.charAt(0)) {
            case 'T': 
            case 't': {
                return "TRUE".equalsIgnoreCase(rawSheetName);
            }
            case 'F': 
            case 'f': {
                return "FALSE".equalsIgnoreCase(rawSheetName);
            }
        }
        return false;
    }

    static boolean isSpecialChar(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return false;
        }
        switch (ch) {
            case '.': 
            case '_': {
                return false;
            }
            case '\t': 
            case '\n': 
            case '\r': {
                throw new RuntimeException("Illegal character (0x" + Integer.toHexString(ch) + ") found in sheet name");
            }
        }
        return true;
    }

    static boolean cellReferenceIsWithinRange(String lettersPrefix, String numbersSuffix) {
        return CellReference.cellReferenceIsWithinRange(lettersPrefix, numbersSuffix, SpreadsheetVersion.EXCEL97);
    }

    static boolean nameLooksLikePlainCellReference(String rawSheetName) {
        Matcher matcher = CELL_REF_PATTERN.matcher(rawSheetName);
        if (!matcher.matches()) {
            return false;
        }
        String lettersPrefix = matcher.group(1);
        String numbersSuffix = matcher.group(2);
        return SheetNameFormatter.cellReferenceIsWithinRange(lettersPrefix, numbersSuffix);
    }
}

