/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellUtil;

public final class RegionUtil {
    private RegionUtil() {
    }

    public static void setBorderLeft(int border, CellRangeAddress region, Sheet sheet, Workbook workbook) {
        int rowStart = region.getFirstRow();
        int rowEnd = region.getLastRow();
        int column = region.getFirstColumn();
        CellPropertySetter cps = new CellPropertySetter(workbook, "borderLeft", border);
        int i = rowStart;
        while (i <= rowEnd) {
            cps.setProperty(CellUtil.getRow(i, sheet), column);
            ++i;
        }
    }

    public static void setLeftBorderColor(int color, CellRangeAddress region, Sheet sheet, Workbook workbook) {
        int rowStart = region.getFirstRow();
        int rowEnd = region.getLastRow();
        int column = region.getFirstColumn();
        CellPropertySetter cps = new CellPropertySetter(workbook, "leftBorderColor", color);
        int i = rowStart;
        while (i <= rowEnd) {
            cps.setProperty(CellUtil.getRow(i, sheet), column);
            ++i;
        }
    }

    public static void setBorderRight(int border, CellRangeAddress region, Sheet sheet, Workbook workbook) {
        int rowStart = region.getFirstRow();
        int rowEnd = region.getLastRow();
        int column = region.getLastColumn();
        CellPropertySetter cps = new CellPropertySetter(workbook, "borderRight", border);
        int i = rowStart;
        while (i <= rowEnd) {
            cps.setProperty(CellUtil.getRow(i, sheet), column);
            ++i;
        }
    }

    public static void setRightBorderColor(int color, CellRangeAddress region, Sheet sheet, Workbook workbook) {
        int rowStart = region.getFirstRow();
        int rowEnd = region.getLastRow();
        int column = region.getLastColumn();
        CellPropertySetter cps = new CellPropertySetter(workbook, "rightBorderColor", color);
        int i = rowStart;
        while (i <= rowEnd) {
            cps.setProperty(CellUtil.getRow(i, sheet), column);
            ++i;
        }
    }

    public static void setBorderBottom(int border, CellRangeAddress region, Sheet sheet, Workbook workbook) {
        int colStart = region.getFirstColumn();
        int colEnd = region.getLastColumn();
        int rowIndex = region.getLastRow();
        CellPropertySetter cps = new CellPropertySetter(workbook, "borderBottom", border);
        Row row = CellUtil.getRow(rowIndex, sheet);
        int i = colStart;
        while (i <= colEnd) {
            cps.setProperty(row, i);
            ++i;
        }
    }

    public static void setBottomBorderColor(int color, CellRangeAddress region, Sheet sheet, Workbook workbook) {
        int colStart = region.getFirstColumn();
        int colEnd = region.getLastColumn();
        int rowIndex = region.getLastRow();
        CellPropertySetter cps = new CellPropertySetter(workbook, "bottomBorderColor", color);
        Row row = CellUtil.getRow(rowIndex, sheet);
        int i = colStart;
        while (i <= colEnd) {
            cps.setProperty(row, i);
            ++i;
        }
    }

    public static void setBorderTop(int border, CellRangeAddress region, Sheet sheet, Workbook workbook) {
        int colStart = region.getFirstColumn();
        int colEnd = region.getLastColumn();
        int rowIndex = region.getFirstRow();
        CellPropertySetter cps = new CellPropertySetter(workbook, "borderTop", border);
        Row row = CellUtil.getRow(rowIndex, sheet);
        int i = colStart;
        while (i <= colEnd) {
            cps.setProperty(row, i);
            ++i;
        }
    }

    public static void setTopBorderColor(int color, CellRangeAddress region, Sheet sheet, Workbook workbook) {
        int colStart = region.getFirstColumn();
        int colEnd = region.getLastColumn();
        int rowIndex = region.getFirstRow();
        CellPropertySetter cps = new CellPropertySetter(workbook, "topBorderColor", color);
        Row row = CellUtil.getRow(rowIndex, sheet);
        int i = colStart;
        while (i <= colEnd) {
            cps.setProperty(row, i);
            ++i;
        }
    }

    private static final class CellPropertySetter {
        private final Workbook _workbook;
        private final String _propertyName;
        private final Short _propertyValue;

        public CellPropertySetter(Workbook workbook, String propertyName, int value) {
            this._workbook = workbook;
            this._propertyName = propertyName;
            this._propertyValue = new Short((short)value);
        }

        public void setProperty(Row row, int column) {
            Cell cell = CellUtil.getCell(row, column);
            CellUtil.setCellStyleProperty(cell, this._workbook, this._propertyName, this._propertyValue);
        }
    }
}

