/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.crypto;

import org.apache.poi.util.HexDump;

final class RC4 {
    private int _i;
    private int _j;
    private final byte[] _s = new byte[256];

    public RC4(byte[] key) {
        int key_length = key.length;
        int i = 0;
        while (i < 256) {
            this._s[i] = (byte)i;
            ++i;
        }
        i = 0;
        int j = 0;
        while (i < 256) {
            j = j + key[i % key_length] + this._s[i] & 0xFF;
            byte temp = this._s[i];
            this._s[i] = this._s[j];
            this._s[j] = temp;
            ++i;
        }
        this._i = 0;
        this._j = 0;
    }

    public byte output() {
        this._i = this._i + 1 & 0xFF;
        this._j = this._j + this._s[this._i] & 0xFF;
        byte temp = this._s[this._i];
        this._s[this._i] = this._s[this._j];
        this._s[this._j] = temp;
        return this._s[this._s[this._i] + this._s[this._j] & 0xFF];
    }

    public void encrypt(byte[] in) {
        int i = 0;
        while (i < in.length) {
            in[i] = (byte)(in[i] ^ this.output());
            ++i;
        }
    }

    public void encrypt(byte[] in, int offset, int len) {
        int end = offset + len;
        int i = offset;
        while (i < end) {
            in[i] = (byte)(in[i] ^ this.output());
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" [");
        sb.append("i=").append(this._i);
        sb.append(" j=").append(this._j);
        sb.append("]");
        sb.append("\n");
        sb.append(HexDump.dump(this._s, 0L, 0));
        return sb.toString();
    }
}

