/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormat;

public final class HSSFDataFormat
implements DataFormat {
    private static final String[] _builtinFormats = BuiltinFormats.getAll();
    private final Vector _formats = new Vector();
    private final InternalWorkbook _workbook;
    private boolean _movedBuiltins = false;

    HSSFDataFormat(InternalWorkbook workbook) {
        this._workbook = workbook;
        Iterator i = workbook.getFormats().iterator();
        while (i.hasNext()) {
            FormatRecord r = (FormatRecord)i.next();
            if (this._formats.size() < r.getIndexCode() + 1) {
                this._formats.setSize(r.getIndexCode() + 1);
            }
            this._formats.set(r.getIndexCode(), r.getFormatString());
        }
    }

    public static List getBuiltinFormats() {
        return Arrays.asList(_builtinFormats);
    }

    public static short getBuiltinFormat(String format) {
        return (short)BuiltinFormats.getBuiltinFormat(format);
    }

    public short getFormat(String pFormat) {
        int ind;
        String format = pFormat.toUpperCase().equals("TEXT") ? "@" : pFormat;
        if (!this._movedBuiltins) {
            int i = 0;
            while (i < _builtinFormats.length) {
                if (this._formats.size() < i + 1) {
                    this._formats.setSize(i + 1);
                }
                this._formats.set(i, _builtinFormats[i]);
                ++i;
            }
            this._movedBuiltins = true;
        }
        ListIterator i = this._formats.listIterator();
        while (i.hasNext()) {
            ind = i.nextIndex();
            if (!format.equals(i.next())) continue;
            return (short)ind;
        }
        ind = this._workbook.getFormat(format, true);
        if (this._formats.size() <= ind) {
            this._formats.setSize(ind + 1);
        }
        this._formats.set(ind, format);
        return (short)ind;
    }

    public String getFormat(short index) {
        if (this._movedBuiltins) {
            return (String)this._formats.get(index);
        }
        if (_builtinFormats.length > index && _builtinFormats[index] != null) {
            return _builtinFormats[index];
        }
        return (String)this._formats.get(index);
    }

    public static String getBuiltinFormat(short index) {
        return BuiltinFormats.getBuiltinFormat(index);
    }

    public static int getNumberOfBuiltinBuiltinFormats() {
        return _builtinFormats.length;
    }
}

