/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

public abstract class HeaderFooter
implements org.apache.poi.ss.usermodel.HeaderFooter {
    protected HeaderFooter() {
    }

    protected abstract String getRawText();

    private String[] splitParts() {
        String text = this.getRawText();
        String _left = "";
        String _center = "";
        String _right = "";
        block5: while (text.length() > 1) {
            if (text.charAt(0) != '&') {
                _center = text;
                break;
            }
            int pos = text.length();
            switch (text.charAt(1)) {
                case 'L': {
                    if (text.indexOf("&C") >= 0) {
                        pos = Math.min(pos, text.indexOf("&C"));
                    }
                    if (text.indexOf("&R") >= 0) {
                        pos = Math.min(pos, text.indexOf("&R"));
                    }
                    _left = text.substring(2, pos);
                    text = text.substring(pos);
                    break;
                }
                case 'C': {
                    if (text.indexOf("&L") >= 0) {
                        pos = Math.min(pos, text.indexOf("&L"));
                    }
                    if (text.indexOf("&R") >= 0) {
                        pos = Math.min(pos, text.indexOf("&R"));
                    }
                    _center = text.substring(2, pos);
                    text = text.substring(pos);
                    break;
                }
                case 'R': {
                    if (text.indexOf("&C") >= 0) {
                        pos = Math.min(pos, text.indexOf("&C"));
                    }
                    if (text.indexOf("&L") >= 0) {
                        pos = Math.min(pos, text.indexOf("&L"));
                    }
                    _right = text.substring(2, pos);
                    text = text.substring(pos);
                    break;
                }
                default: {
                    _center = text;
                    break block5;
                }
            }
        }
        return new String[]{_left, _center, _right};
    }

    public final String getLeft() {
        return this.splitParts()[0];
    }

    public final void setLeft(String newLeft) {
        this.updatePart(0, newLeft);
    }

    public final String getCenter() {
        return this.splitParts()[1];
    }

    public final void setCenter(String newCenter) {
        this.updatePart(1, newCenter);
    }

    public final String getRight() {
        return this.splitParts()[2];
    }

    public final void setRight(String newRight) {
        this.updatePart(2, newRight);
    }

    private void updatePart(int partIndex, String newValue) {
        String[] parts = this.splitParts();
        parts[partIndex] = newValue == null ? "" : newValue;
        this.updateHeaderFooterText(parts);
    }

    private void updateHeaderFooterText(String[] parts) {
        String _left = parts[0];
        String _center = parts[1];
        String _right = parts[2];
        if (_center.length() < 1 && _left.length() < 1 && _right.length() < 1) {
            this.setHeaderFooterText("");
            return;
        }
        StringBuffer sb = new StringBuffer(64);
        sb.append("&C");
        sb.append(_center);
        sb.append("&L");
        sb.append(_left);
        sb.append("&R");
        sb.append(_right);
        String text = sb.toString();
        this.setHeaderFooterText(text);
    }

    protected abstract void setHeaderFooterText(String var1);

    public static String fontSize(short size) {
        return "&" + size;
    }

    public static String font(String font, String style) {
        return "&\"" + font + "," + style + "\"";
    }

    public static String page() {
        return MarkupTag.PAGE_FIELD.getRepresentation();
    }

    public static String numPages() {
        return MarkupTag.NUM_PAGES_FIELD.getRepresentation();
    }

    public static String date() {
        return MarkupTag.DATE_FIELD.getRepresentation();
    }

    public static String time() {
        return MarkupTag.TIME_FIELD.getRepresentation();
    }

    public static String file() {
        return MarkupTag.FILE_FIELD.getRepresentation();
    }

    public static String tab() {
        return MarkupTag.SHEET_NAME_FIELD.getRepresentation();
    }

    public static String startBold() {
        return MarkupTag.BOLD_FIELD.getRepresentation();
    }

    public static String endBold() {
        return MarkupTag.BOLD_FIELD.getRepresentation();
    }

    public static String startUnderline() {
        return MarkupTag.UNDERLINE_FIELD.getRepresentation();
    }

    public static String endUnderline() {
        return MarkupTag.UNDERLINE_FIELD.getRepresentation();
    }

    public static String startDoubleUnderline() {
        return MarkupTag.DOUBLE_UNDERLINE_FIELD.getRepresentation();
    }

    public static String endDoubleUnderline() {
        return MarkupTag.DOUBLE_UNDERLINE_FIELD.getRepresentation();
    }

    public static String stripFields(String pText) {
        if (pText == null || pText.length() == 0) {
            return pText;
        }
        String text = pText;
        int i = 0;
        while (i < MarkupTag.values().length) {
            int pos;
            MarkupTag mt = MarkupTag.values()[i];
            String seq = mt.getRepresentation();
            while ((pos = text.indexOf(seq)) > -1) {
                text = String.valueOf(text.substring(0, pos)) + text.substring(pos + seq.length());
            }
            ++i;
        }
        text = text.replaceAll("\\&\\d+", "");
        text = text.replaceAll("\\&\".*?,.*?\"", "");
        return text;
    }

    private static final class MarkupTag {
        public static final MarkupTag SHEET_NAME_FIELD = new MarkupTag("&A", false);
        public static final MarkupTag DATE_FIELD = new MarkupTag("&D", false);
        public static final MarkupTag FILE_FIELD = new MarkupTag("&F", false);
        public static final MarkupTag FULL_FILE_FIELD = new MarkupTag("&Z", false);
        public static final MarkupTag PAGE_FIELD = new MarkupTag("&P", false);
        public static final MarkupTag TIME_FIELD = new MarkupTag("&T", false);
        public static final MarkupTag NUM_PAGES_FIELD = new MarkupTag("&N", false);
        public static final MarkupTag PICTURE_FIELD = new MarkupTag("&G", false);
        public static final MarkupTag BOLD_FIELD = new MarkupTag("&B", true);
        public static final MarkupTag ITALIC_FIELD = new MarkupTag("&I", true);
        public static final MarkupTag STRIKETHROUGH_FIELD = new MarkupTag("&S", true);
        public static final MarkupTag SUBSCRIPT_FIELD = new MarkupTag("&Y", true);
        public static final MarkupTag SUPERSCRIPT_FIELD = new MarkupTag("&X", true);
        public static final MarkupTag UNDERLINE_FIELD = new MarkupTag("&U", true);
        public static final MarkupTag DOUBLE_UNDERLINE_FIELD = new MarkupTag("&E", true);
        private final String _representation;
        private final boolean _occursInPairs;

        public static MarkupTag[] values() {
            return new MarkupTag[]{SHEET_NAME_FIELD, DATE_FIELD, FILE_FIELD, FULL_FILE_FIELD, PAGE_FIELD, TIME_FIELD, NUM_PAGES_FIELD, PICTURE_FIELD, BOLD_FIELD, ITALIC_FIELD, STRIKETHROUGH_FIELD, SUBSCRIPT_FIELD, SUPERSCRIPT_FIELD, UNDERLINE_FIELD, DOUBLE_UNDERLINE_FIELD};
        }

        private MarkupTag(String sequence, boolean occursInPairs) {
            this._representation = sequence;
            this._occursInPairs = occursInPairs;
        }

        public String getRepresentation() {
            return this._representation;
        }

        public boolean occursPairs() {
            return this._occursInPairs;
        }
    }
}

