/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */

package org.apache.poi.ss.usermodel;

/**
 * The enumeration value indicating the line style of a border in a cell,
 * i.e., whether it is borded dash dot, dash dot dot, dashed, dotted, double, hair, medium,
 * medium dash dot, medium dash dot dot, medium dashed, none, slant dash dot, thick or thin.
 */
 public class BorderStyle {

    /**
     * No border
     */

    public static final BorderStyle NONE = new BorderStyle(0);

    /**
     * Thin border
     */

    public static final BorderStyle THIN = new BorderStyle(1);

    /**
     * Medium border
     */

    public static final BorderStyle MEDIUM = new BorderStyle(2);

    /**
     * dash border
     */

    public static final BorderStyle DASHED = new BorderStyle(3);

    /**
     * dot border
     */

    public static final BorderStyle HAIR = new BorderStyle(4);

    /**
     * Thick border
     */

    public static final BorderStyle THICK = new BorderStyle(5);

    /**
     * double-line border
     */

    public static final BorderStyle DOUBLE = new BorderStyle(6);

    /**
     * hair-line border
     */

    public static final BorderStyle DOTTED = new BorderStyle(7);

    /**
     * Medium dashed border
     */

    public static final BorderStyle MEDIUM_DASHED = new BorderStyle(8);

    /**
     * dash-dot border
     */

    public static final BorderStyle DASH_DOT = new BorderStyle(9);

    /**
     * medium dash-dot border
     */

    public static final BorderStyle MEDIUM_DASH_DOT = new BorderStyle(10);

    /**
     * dash-dot-dot border
     */

    public static final BorderStyle DASH_DOT_DOT = new BorderStyle(11);

    /**
     * medium dash-dot-dot border
     */

    public static final BorderStyle MEDIUM_DASH_DOT_DOTC = new BorderStyle(12);

    /**
     * slanted dash-dot border
     */

    public static final BorderStyle SLANTED_DASH_DOT = new BorderStyle(13);

    public BorderStyle(int i) {
    	ordinal = i;
    }

    private int ordinal;

    public int getOrdinal() {
    	return ordinal;
    }

	public static BorderStyle[] values() {
		return new BorderStyle[] { NONE, THIN, MEDIUM, DASHED, HAIR, THICK,
				DOUBLE, DOTTED, MEDIUM_DASHED, DASH_DOT, MEDIUM_DASH_DOT,
				DASH_DOT_DOT, MEDIUM_DASH_DOT_DOTC, SLANTED_DASH_DOT };
	}
}
