/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Fixed0ArgFunction;
import org.apache.poi.hssf.record.formula.functions.Fixed1ArgFunction;
import org.apache.poi.hssf.record.formula.functions.Function;
import org.apache.poi.ss.formula.TwoDEval;

public abstract class BooleanFunction
implements Function {
    public static final Function AND = new BooleanFunction(){

        protected boolean getInitialResultValue() {
            return true;
        }

        protected boolean partialEvaluate(boolean cumulativeResult, boolean currentValue) {
            return cumulativeResult && currentValue;
        }
    };
    public static final Function OR = new BooleanFunction(){

        protected boolean getInitialResultValue() {
            return false;
        }

        protected boolean partialEvaluate(boolean cumulativeResult, boolean currentValue) {
            return cumulativeResult || currentValue;
        }
    };
    public static final Function FALSE = new Fixed0ArgFunction(){

        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex) {
            return BoolEval.FALSE;
        }
    };
    public static final Function TRUE = new Fixed0ArgFunction(){

        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex) {
            return BoolEval.TRUE;
        }
    };
    public static final Function NOT = new Fixed1ArgFunction(){

        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0) {
            boolean boolArgVal;
            try {
                ValueEval ve = OperandResolver.getSingleValue(arg0, srcRowIndex, srcColumnIndex);
                Boolean b = OperandResolver.coerceValueToBoolean(ve, false);
                boolArgVal = b == null ? false : b;
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
            return BoolEval.valueOf(!boolArgVal);
        }
    };

    public final ValueEval evaluate(ValueEval[] args, int srcRow, int srcCol) {
        boolean boolResult;
        if (args.length < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            boolResult = this.calculate(args);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return BoolEval.valueOf(boolResult);
    }

    private boolean calculate(ValueEval[] args) throws EvaluationException {
        boolean result = this.getInitialResultValue();
        boolean atleastOneNonBlank = false;
        int i = 0;
        int iSize = args.length;
        while (i < iSize) {
            ValueEval arg = args[i];
            if (arg instanceof TwoDEval) {
                TwoDEval ae = (TwoDEval)arg;
                int height = ae.getHeight();
                int width = ae.getWidth();
                int rrIx = 0;
                while (rrIx < height) {
                    int rcIx = 0;
                    while (rcIx < width) {
                        ValueEval ve = ae.getValue(rrIx, rcIx);
                        Boolean tempVe = OperandResolver.coerceValueToBoolean(ve, true);
                        if (tempVe != null) {
                            result = this.partialEvaluate(result, tempVe);
                            atleastOneNonBlank = true;
                        }
                        ++rcIx;
                    }
                    ++rrIx;
                }
            } else {
                Boolean tempVe;
                if (arg instanceof RefEval) {
                    ValueEval ve = ((RefEval)arg).getInnerValueEval();
                    tempVe = OperandResolver.coerceValueToBoolean(ve, true);
                } else {
                    tempVe = OperandResolver.coerceValueToBoolean(arg, false);
                }
                if (tempVe != null) {
                    result = this.partialEvaluate(result, tempVe);
                    atleastOneNonBlank = true;
                }
            }
            ++i;
        }
        if (!atleastOneNonBlank) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return result;
    }

    protected abstract boolean getInitialResultValue();

    protected abstract boolean partialEvaluate(boolean var1, boolean var2);
}

