/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.poi.poifs.common.POIFSBigBlockSize;
import org.apache.poi.poifs.storage.BigBlock;
import org.apache.poi.util.IntegerField;

public final class BATBlock
extends BigBlock {
    private static final byte _default_value = -1;
    private IntegerField[] _fields;
    private byte[] _data;

    private BATBlock(POIFSBigBlockSize bigBlockSize) {
        super(bigBlockSize);
        int _entries_per_block = bigBlockSize.getBATEntriesPerBlock();
        this._data = new byte[bigBlockSize.getBigBlockSize()];
        Arrays.fill(this._data, (byte)-1);
        this._fields = new IntegerField[_entries_per_block];
        int offset = 0;
        int j = 0;
        while (j < _entries_per_block) {
            this._fields[j] = new IntegerField(offset);
            offset += 4;
            ++j;
        }
    }

    public static BATBlock[] createBATBlocks(POIFSBigBlockSize bigBlockSize, int[] entries) {
        int block_count = BATBlock.calculateStorageRequirements(bigBlockSize, entries.length);
        BATBlock[] blocks = new BATBlock[block_count];
        int index = 0;
        int remaining = entries.length;
        int _entries_per_block = bigBlockSize.getBATEntriesPerBlock();
        int j = 0;
        while (j < entries.length) {
            blocks[index++] = new BATBlock(bigBlockSize, entries, j, remaining > _entries_per_block ? j + _entries_per_block : entries.length);
            remaining -= _entries_per_block;
            j += _entries_per_block;
        }
        return blocks;
    }

    public static BATBlock[] createXBATBlocks(POIFSBigBlockSize bigBlockSize, int[] entries, int startBlock) {
        int block_count = BATBlock.calculateXBATStorageRequirements(bigBlockSize, entries.length);
        BATBlock[] blocks = new BATBlock[block_count];
        int index = 0;
        int remaining = entries.length;
        int _entries_per_xbat_block = bigBlockSize.getXBATEntriesPerBlock();
        if (block_count != 0) {
            int j = 0;
            while (j < entries.length) {
                blocks[index++] = new BATBlock(bigBlockSize, entries, j, remaining > _entries_per_xbat_block ? j + _entries_per_xbat_block : entries.length);
                remaining -= _entries_per_xbat_block;
                j += _entries_per_xbat_block;
            }
            index = 0;
            while (index < blocks.length - 1) {
                blocks[index].setXBATChain(bigBlockSize, startBlock + index + 1);
                ++index;
            }
            blocks[index].setXBATChain(bigBlockSize, -2);
        }
        return blocks;
    }

    public static int calculateStorageRequirements(POIFSBigBlockSize bigBlockSize, int entryCount) {
        int _entries_per_block = bigBlockSize.getBATEntriesPerBlock();
        return (entryCount + _entries_per_block - 1) / _entries_per_block;
    }

    public static int calculateXBATStorageRequirements(POIFSBigBlockSize bigBlockSize, int entryCount) {
        int _entries_per_xbat_block = bigBlockSize.getXBATEntriesPerBlock();
        return (entryCount + _entries_per_xbat_block - 1) / _entries_per_xbat_block;
    }

    private void setXBATChain(POIFSBigBlockSize bigBlockSize, int chainIndex) {
        int _entries_per_xbat_block = bigBlockSize.getXBATEntriesPerBlock();
        this._fields[_entries_per_xbat_block].set(chainIndex, this._data);
    }

    private BATBlock(POIFSBigBlockSize bigBlockSize, int[] entries, int start_index, int end_index) {
        this(bigBlockSize);
        int k = start_index;
        while (k < end_index) {
            this._fields[k - start_index].set(entries[k], this._data);
            ++k;
        }
    }

    void writeData(OutputStream stream) throws IOException {
        this.doWriteData(stream, this._data);
    }
}

