/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdgf.dev;

import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.hdgf.HDGFDiagram;
import org.apache.poi.hdgf.chunks.Chunk;
import org.apache.poi.hdgf.pointers.Pointer;
import org.apache.poi.hdgf.streams.ChunkStream;
import org.apache.poi.hdgf.streams.PointerContainingStream;
import org.apache.poi.hdgf.streams.Stream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class VSDDumper {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Use:");
            System.err.println("  VSDDumper <filename>");
            System.exit(1);
        }
        HDGFDiagram hdgf = new HDGFDiagram(new POIFSFileSystem((InputStream)new FileInputStream(args[0])));
        System.out.println("Opened " + args[0]);
        System.out.println("The document claims a size of " + hdgf.getDocumentSize() + "   (" + Long.toHexString(hdgf.getDocumentSize()) + ")");
        System.out.println();
        VSDDumper.dumpStream(hdgf.getTrailerStream(), 0);
    }

    public static void dumpStream(Stream stream, int indent) {
        int i;
        String ind = "";
        int i2 = 0;
        while (i2 < indent) {
            ind = String.valueOf(ind) + "    ";
            ++i2;
        }
        String ind2 = String.valueOf(ind) + "    ";
        String ind3 = String.valueOf(ind2) + "    ";
        Pointer ptr = stream.getPointer();
        System.out.println(String.valueOf(ind) + "Stream at\t" + ptr.getOffset() + " - " + Integer.toHexString(ptr.getOffset()));
        System.out.println(String.valueOf(ind) + "  Type is\t" + ptr.getType() + " - " + Integer.toHexString(ptr.getType()));
        System.out.println(String.valueOf(ind) + "  Format is\t" + ptr.getFormat() + " - " + Integer.toHexString(ptr.getFormat()));
        System.out.println(String.valueOf(ind) + "  Length is\t" + ptr.getLength() + " - " + Integer.toHexString(ptr.getLength()));
        if (ptr.destinationCompressed()) {
            int decompLen = stream._getContentsLength();
            System.out.println(String.valueOf(ind) + "  DC.Length is\t" + decompLen + " - " + Integer.toHexString(decompLen));
        }
        System.out.println(String.valueOf(ind) + "  Compressed is\t" + ptr.destinationCompressed());
        System.out.println(String.valueOf(ind) + "  Stream is\t" + stream.getClass().getName());
        byte[] db = stream._getStore()._getContents();
        String ds = "";
        if (db.length >= 8) {
            int i3 = 0;
            while (i3 < 8) {
                if (i3 > 0) {
                    ds = String.valueOf(ds) + ", ";
                }
                ds = String.valueOf(ds) + db[i3];
                ++i3;
            }
        }
        System.out.println(String.valueOf(ind) + "  First few bytes are\t" + ds);
        if (stream instanceof PointerContainingStream) {
            PointerContainingStream pcs = (PointerContainingStream)stream;
            System.out.println(String.valueOf(ind) + "  Has " + pcs.getPointedToStreams().length + " children:");
            i = 0;
            while (i < pcs.getPointedToStreams().length) {
                VSDDumper.dumpStream(pcs.getPointedToStreams()[i], indent + 1);
                ++i;
            }
        }
        if (stream instanceof ChunkStream) {
            ChunkStream cs = (ChunkStream)stream;
            System.out.println(String.valueOf(ind) + "  Has " + cs.getChunks().length + " chunks:");
            i = 0;
            while (i < cs.getChunks().length) {
                Chunk chunk = cs.getChunks()[i];
                System.out.println(String.valueOf(ind2) + chunk.getName());
                System.out.println(String.valueOf(ind2) + "  Length is " + chunk._getContents().length + " (" + Integer.toHexString(chunk._getContents().length) + ")");
                System.out.println(String.valueOf(ind2) + "  OD Size is " + chunk.getOnDiskSize() + " (" + Integer.toHexString(chunk.getOnDiskSize()) + ")");
                System.out.println(String.valueOf(ind2) + "  T / S is " + chunk.getTrailer() + " / " + chunk.getSeparator());
                System.out.println(String.valueOf(ind2) + "  Holds " + chunk.getCommands().length + " commands");
                int j = 0;
                while (j < chunk.getCommands().length) {
                    Chunk.Command command = chunk.getCommands()[j];
                    System.out.println(String.valueOf(ind3) + command.getDefinition().getName() + " " + command.getValue());
                    ++j;
                }
                ++i;
            }
        }
    }
}

