/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi;

import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLFactory;
import org.apache.poi.POIXMLRelation;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.xmlbeans.XmlOptions;

public class POIXMLDocumentPart {
    private static POILogger logger;
    public static final XmlOptions DEFAULT_XML_OPTIONS;
    private PackagePart packagePart;
    private PackageRelationship packageRel;
    private POIXMLDocumentPart parent;
    private List relations;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.POIXMLDocumentPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = POILogFactory.getLogger((Class)clazz);
        DEFAULT_XML_OPTIONS = new XmlOptions();
        DEFAULT_XML_OPTIONS.setSaveOuter();
        DEFAULT_XML_OPTIONS.setUseDefaultNamespace();
        DEFAULT_XML_OPTIONS.setSaveAggressiveNamespaces();
    }

    public POIXMLDocumentPart(OPCPackage pkg) {
        PackageRelationship coreRel = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
        this.relations = new LinkedList();
        this.packagePart = pkg.getPart(coreRel);
        this.packageRel = coreRel;
    }

    public POIXMLDocumentPart() {
        this.relations = new LinkedList();
    }

    public POIXMLDocumentPart(PackagePart part, PackageRelationship rel) {
        this.relations = new LinkedList();
        this.packagePart = part;
        this.packageRel = rel;
    }

    protected final void rebase(OPCPackage pkg) throws InvalidFormatException {
        PackageRelationshipCollection cores = this.packagePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        if (cores.size() != 1) {
            throw new IllegalStateException("Tried to rebase using http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument but found " + cores.size() + " parts of the right type");
        }
        this.packageRel = cores.getRelationship(0);
        this.packagePart = POIXMLDocument.getTargetPart(pkg, this.packageRel);
    }

    public final PackagePart getPackagePart() {
        return this.packagePart;
    }

    public final PackageRelationship getPackageRelationship() {
        return this.packageRel;
    }

    public final List getRelations() {
        return this.relations;
    }

    protected final void addRelation(POIXMLDocumentPart part) {
        this.relations.add(part);
    }

    public final void removeRelation(POIXMLDocumentPart part) {
        this.getPackagePart().removeRelationship(part.getPackageRelationship().getId());
        this.getPackagePart().getPackage().removePart(part.getPackagePart());
        this.relations.remove(part);
    }

    public final POIXMLDocumentPart getParent() {
        return this.parent;
    }

    public String toString() {
        return this.packagePart == null ? null : this.packagePart.toString();
    }

    protected void commit() throws IOException {
    }

    protected final void onSave(Set alreadySaved) throws IOException {
        this.commit();
        alreadySaved.add(this.getPackagePart());
        Iterator iterator = this.relations.iterator();
        while (iterator.hasNext()) {
            POIXMLDocumentPart p = (POIXMLDocumentPart)iterator.next();
            if (alreadySaved.contains(p.getPackagePart())) continue;
            p.onSave(alreadySaved);
        }
    }

    public final POIXMLDocumentPart createRelationship(POIXMLRelation descriptor, POIXMLFactory factory) {
        return this.createRelationship(descriptor, factory, -1, false);
    }

    public final POIXMLDocumentPart createRelationship(POIXMLRelation descriptor, POIXMLFactory factory, int idx) {
        return this.createRelationship(descriptor, factory, idx, false);
    }

    protected final POIXMLDocumentPart createRelationship(POIXMLRelation descriptor, POIXMLFactory factory, int idx, boolean noRelation) {
        try {
            PackagePartName ppName = PackagingURIHelper.createPartName(descriptor.getFileName(idx));
            PackageRelationship rel = null;
            if (!noRelation) {
                rel = this.packagePart.addRelationship(ppName, TargetMode.INTERNAL, descriptor.getRelation());
            }
            PackagePart part = this.packagePart.getPackage().createPart(ppName, descriptor.getContentType());
            POIXMLDocumentPart doc = factory.newDocumentPart(descriptor);
            doc.packageRel = rel;
            doc.packagePart = part;
            doc.parent = this;
            this.addRelation(doc);
            return doc;
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    protected void read(POIXMLFactory factory, Map context) throws OpenXML4JException {
        PackageRelationshipCollection rels = this.packagePart.getRelationships();
        Iterator iterator = rels.iterator();
        while (iterator.hasNext()) {
            PackagePart p;
            PackageRelationship rel = (PackageRelationship)iterator.next();
            if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
            URI uri = rel.getTargetURI();
            if (uri.getRawFragment() != null) {
                p = null;
            } else {
                PackagePartName relName = PackagingURIHelper.createPartName(uri);
                p = this.packagePart.getPackage().getPart(relName);
                if (p == null) {
                    logger.log(POILogger.ERROR, (Object)("Skipped invalid entry " + rel.getTargetURI()));
                    continue;
                }
            }
            if (!context.containsKey(p)) {
                POIXMLDocumentPart childPart = factory.createDocumentPart(rel, p);
                childPart.parent = this;
                this.addRelation(childPart);
                if (p == null) continue;
                context.put(p, childPart);
                if (!p.hasRelationships()) continue;
                childPart.read(factory, context);
                continue;
            }
            this.addRelation((POIXMLDocumentPart)context.get(p));
        }
    }

    protected void onDocumentCreate() throws IOException {
    }

    protected void onDocumentRead() throws IOException {
    }
}

