/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.opc.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageProperties;
import org.apache.poi.openxml4j.util.Nullable;

public final class PackagePropertiesPart
extends PackagePart
implements PackageProperties {
    public static final String NAMESPACE_DC_URI = "http://purl.org/dc/elements/1.1/";
    public static final String NAMESPACE_CP_URI = "http://schemas.openxmlformats.org/package/2006/metadata/core-properties";
    public static final String NAMESPACE_DCTERMS_URI = "http://purl.org/dc/terms/";
    public static final String NAMESPACE_XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    protected Nullable category = new Nullable();
    protected Nullable contentStatus = new Nullable();
    protected Nullable contentType = new Nullable();
    protected Nullable created = new Nullable();
    protected Nullable creator = new Nullable();
    protected Nullable description = new Nullable();
    protected Nullable identifier = new Nullable();
    protected Nullable keywords = new Nullable();
    protected Nullable language = new Nullable();
    protected Nullable lastModifiedBy = new Nullable();
    protected Nullable lastPrinted = new Nullable();
    protected Nullable modified = new Nullable();
    protected Nullable revision = new Nullable();
    protected Nullable subject = new Nullable();
    protected Nullable title = new Nullable();
    protected Nullable version = new Nullable();

    public PackagePropertiesPart(OPCPackage pack, PackagePartName partName) throws InvalidFormatException {
        super(pack, partName, "application/vnd.openxmlformats-package.core-properties+xml");
    }

    public Nullable getCategoryProperty() {
        return this.category;
    }

    public Nullable getContentStatusProperty() {
        return this.contentStatus;
    }

    public Nullable getContentTypeProperty() {
        return this.contentType;
    }

    public Nullable getCreatedProperty() {
        return this.created;
    }

    public String getCreatedPropertyString() {
        return this.getDateValue(this.created);
    }

    public Nullable getCreatorProperty() {
        return this.creator;
    }

    public Nullable getDescriptionProperty() {
        return this.description;
    }

    public Nullable getIdentifierProperty() {
        return this.identifier;
    }

    public Nullable getKeywordsProperty() {
        return this.keywords;
    }

    public Nullable getLanguageProperty() {
        return this.language;
    }

    public Nullable getLastModifiedByProperty() {
        return this.lastModifiedBy;
    }

    public Nullable getLastPrintedProperty() {
        return this.lastPrinted;
    }

    public String getLastPrintedPropertyString() {
        return this.getDateValue(this.created);
    }

    public Nullable getModifiedProperty() {
        return this.modified;
    }

    public String getModifiedPropertyString() {
        if (this.modified.hasValue()) {
            return this.getDateValue(this.modified);
        }
        return this.getDateValue(new Nullable(new Date()));
    }

    public Nullable getRevisionProperty() {
        return this.revision;
    }

    public Nullable getSubjectProperty() {
        return this.subject;
    }

    public Nullable getTitleProperty() {
        return this.title;
    }

    public Nullable getVersionProperty() {
        return this.version;
    }

    public void setCategoryProperty(String category) {
        this.category = this.setStringValue(category);
    }

    public void setContentStatusProperty(String contentStatus) {
        this.contentStatus = this.setStringValue(contentStatus);
    }

    public void setContentTypeProperty(String contentType) {
        this.contentType = this.setStringValue(contentType);
    }

    public void setCreatedProperty(String created) {
        try {
            this.created = this.setDateValue(created);
        }
        catch (InvalidFormatException e) {
            new IllegalArgumentException("created  : " + e.getLocalizedMessage());
        }
    }

    public void setCreatedProperty(Nullable created) {
        if (created.hasValue()) {
            this.created = created;
        }
    }

    public void setCreatorProperty(String creator) {
        this.creator = this.setStringValue(creator);
    }

    public void setDescriptionProperty(String description) {
        this.description = this.setStringValue(description);
    }

    public void setIdentifierProperty(String identifier) {
        this.identifier = this.setStringValue(identifier);
    }

    public void setKeywordsProperty(String keywords) {
        this.keywords = this.setStringValue(keywords);
    }

    public void setLanguageProperty(String language) {
        this.language = this.setStringValue(language);
    }

    public void setLastModifiedByProperty(String lastModifiedBy) {
        this.lastModifiedBy = this.setStringValue(lastModifiedBy);
    }

    public void setLastPrintedProperty(String lastPrinted) {
        try {
            this.lastPrinted = this.setDateValue(lastPrinted);
        }
        catch (InvalidFormatException e) {
            new IllegalArgumentException("lastPrinted  : " + e.getLocalizedMessage());
        }
    }

    public void setLastPrintedProperty(Nullable lastPrinted) {
        if (lastPrinted.hasValue()) {
            this.lastPrinted = lastPrinted;
        }
    }

    public void setModifiedProperty(String modified) {
        try {
            this.modified = this.setDateValue(modified);
        }
        catch (InvalidFormatException e) {
            new IllegalArgumentException("modified  : " + e.getLocalizedMessage());
        }
    }

    public void setModifiedProperty(Nullable modified) {
        if (modified.hasValue()) {
            this.modified = modified;
        }
    }

    public void setRevisionProperty(String revision) {
        this.revision = this.setStringValue(revision);
    }

    public void setSubjectProperty(String subject) {
        this.subject = this.setStringValue(subject);
    }

    public void setTitleProperty(String title) {
        this.title = this.setStringValue(title);
    }

    public void setVersionProperty(String version) {
        this.version = this.setStringValue(version);
    }

    private Nullable setStringValue(String s) {
        if (s == null || s.equals("")) {
            return new Nullable();
        }
        return new Nullable(s);
    }

    private Nullable setDateValue(String s) throws InvalidFormatException {
        if (s == null || s.equals("")) {
            return new Nullable();
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date d = df.parse(s, new ParsePosition(0));
        if (d == null) {
            throw new InvalidFormatException("Date not well formated");
        }
        return new Nullable(d);
    }

    private String getDateValue(Nullable d) {
        if (d == null) {
            return "";
        }
        Date date = (Date)d.getValue();
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(date);
    }

    protected InputStream getInputStreamImpl() {
        throw new InvalidOperationException("Operation not authorized");
    }

    protected OutputStream getOutputStreamImpl() {
        throw new InvalidOperationException("Can't use output stream to set properties !");
    }

    public boolean save(OutputStream zos) {
        throw new InvalidOperationException("Operation not authorized");
    }

    public boolean load(InputStream ios) {
        throw new InvalidOperationException("Operation not authorized");
    }

    public void close() {
    }

    public void flush() {
    }
}

