/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.PackageHelper;
import org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.Document;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.TOC;
import org.apache.poi.xwpf.usermodel.XWPFComment;
import org.apache.poi.xwpf.usermodel.XWPFFactory;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFFootnote;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFHyperlink;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFSettings;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTComment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocument1;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFtnEdn;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyles;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CommentsDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.DocumentDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.EndnotesDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FootnotesDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STDocProtect;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.StylesDocument;

public class XWPFDocument
extends POIXMLDocument
implements Document,
IBody {
    private CTDocument1 ctDocument;
    private XWPFSettings settings;
    protected List footers;
    protected List headers;
    protected List comments;
    protected List hyperlinks;
    protected List paragraphs;
    protected List tables;
    protected List bodyElements;
    protected List pictures;
    protected Map footnotes;
    protected Map endnotes;
    protected XWPFNumbering numbering;
    protected XWPFStyles styles;
    private XWPFHeaderFooterPolicy headerFooterPolicy;

    public XWPFDocument(OPCPackage pkg) throws IOException {
        super(pkg);
        this.load(XWPFFactory.getInstance());
    }

    public XWPFDocument(InputStream is) throws IOException {
        super(PackageHelper.open(is));
        this.load(XWPFFactory.getInstance());
    }

    public XWPFDocument() {
        super(XWPFDocument.newPackage());
        this.onDocumentCreate();
    }

    protected void onDocumentRead() throws IOException {
        this.hyperlinks = new ArrayList();
        this.comments = new ArrayList();
        this.paragraphs = new ArrayList();
        this.tables = new ArrayList();
        this.bodyElements = new ArrayList();
        this.footers = new ArrayList();
        this.headers = new ArrayList();
        this.footnotes = new HashMap();
        this.endnotes = new HashMap();
        try {
            Object p;
            DocumentDocument doc = DocumentDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
            this.ctDocument = doc.getDocument();
            this.initFootnotes();
            XmlCursor cursor = this.ctDocument.getBody().newCursor();
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                XmlObject o = cursor.getObject();
                if (o instanceof CTP) {
                    p = new XWPFParagraph((CTP)o, this);
                    this.bodyElements.add(p);
                    this.paragraphs.add(p);
                }
                if (!(o instanceof CTTbl)) continue;
                XWPFTable t = new XWPFTable((CTTbl)o, this);
                this.bodyElements.add(t);
                this.tables.add(t);
            }
            if (doc.getDocument().getBody().getSectPr() != null) {
                this.headerFooterPolicy = new XWPFHeaderFooterPolicy(this);
            }
            Iterator iterator = this.getRelations().iterator();
            while (iterator.hasNext()) {
                p = (POIXMLDocumentPart)iterator.next();
                String relation = ((POIXMLDocumentPart)p).getPackageRelationship().getRelationshipType();
                if (relation.equals(XWPFRelation.STYLES.getRelation())) {
                    this.styles = (XWPFStyles)p;
                    continue;
                }
                if (relation.equals(XWPFRelation.NUMBERING.getRelation())) {
                    this.numbering = (XWPFNumbering)p;
                    continue;
                }
                if (relation.equals(XWPFRelation.FOOTER.getRelation())) {
                    this.footers.add((XWPFFooter)p);
                    continue;
                }
                if (relation.equals(XWPFRelation.HEADER.getRelation())) {
                    this.headers.add((XWPFHeader)p);
                    continue;
                }
                if (relation.equals(XWPFRelation.COMMENT.getRelation())) {
                    CommentsDocument cmntdoc = CommentsDocument.Factory.parse((InputStream)((POIXMLDocumentPart)p).getPackagePart().getInputStream());
                    Iterator<CTComment> iterator2 = Arrays.asList(cmntdoc.getComments().getCommentArray()).iterator();
                    while (iterator2.hasNext()) {
                        CTComment ctcomment = iterator2.next();
                        this.comments.add(new XWPFComment(ctcomment));
                    }
                    continue;
                }
                if (!relation.equals(XWPFRelation.SETTINGS.getRelation())) continue;
                this.settings = (XWPFSettings)p;
            }
            this.initHyperlinks();
        }
        catch (XmlException e) {
            throw new POIXMLException(e);
        }
        this.getAllPictures();
    }

    private void initHyperlinks() {
        try {
            Iterator relIter = this.getPackagePart().getRelationshipsByType(XWPFRelation.HYPERLINK.getRelation()).iterator();
            while (relIter.hasNext()) {
                PackageRelationship rel = (PackageRelationship)relIter.next();
                this.hyperlinks.add(new XWPFHyperlink(rel.getId(), rel.getTargetURI().toString()));
            }
        }
        catch (InvalidFormatException e) {
            throw new POIXMLException(e);
        }
    }

    private void initFootnotes() throws XmlException, IOException {
        Iterator iterator = this.getRelations().iterator();
        while (iterator.hasNext()) {
            CTFtnEdn ctFtnEdn;
            Iterator<CTFtnEdn> iterator2;
            POIXMLDocumentPart p = (POIXMLDocumentPart)iterator.next();
            String relation = p.getPackageRelationship().getRelationshipType();
            if (relation.equals(XWPFRelation.FOOTNOTE.getRelation())) {
                FootnotesDocument footnotesDocument = FootnotesDocument.Factory.parse((InputStream)p.getPackagePart().getInputStream());
                iterator2 = Arrays.asList(footnotesDocument.getFootnotes().getFootnoteArray()).iterator();
                while (iterator2.hasNext()) {
                    ctFtnEdn = iterator2.next();
                    this.footnotes.put(ctFtnEdn.getId(), new XWPFFootnote(this, ctFtnEdn));
                }
                continue;
            }
            if (!relation.equals(XWPFRelation.ENDNOTE.getRelation())) continue;
            EndnotesDocument endnotesDocument = EndnotesDocument.Factory.parse((InputStream)p.getPackagePart().getInputStream());
            iterator2 = Arrays.asList(endnotesDocument.getEndnotes().getEndnoteArray()).iterator();
            while (iterator2.hasNext()) {
                ctFtnEdn = iterator2.next();
                this.endnotes.put(ctFtnEdn.getId(), new XWPFFootnote(this, ctFtnEdn));
            }
        }
    }

    protected static OPCPackage newPackage() {
        try {
            OPCPackage pkg = (OPCPackage)OPCPackage.create(new ByteArrayOutputStream());
            PackagePartName corePartName = PackagingURIHelper.createPartName(XWPFRelation.DOCUMENT.getDefaultFileName());
            pkg.addRelationship(corePartName, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
            pkg.createPart(corePartName, XWPFRelation.DOCUMENT.getContentType());
            pkg.getPackageProperties().setCreatorProperty("Apache POI");
            return pkg;
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    protected void onDocumentCreate() {
        this.hyperlinks = new ArrayList();
        this.comments = new ArrayList();
        this.paragraphs = new ArrayList();
        this.tables = new ArrayList();
        this.ctDocument = CTDocument1.Factory.newInstance();
        this.ctDocument.addNewBody();
        this.settings = (XWPFSettings)this.createRelationship(XWPFRelation.SETTINGS, XWPFFactory.getInstance());
        POIXMLProperties.ExtendedProperties expProps = this.getProperties().getExtendedProperties();
        expProps.getUnderlyingProperties().setApplication("Apache POI");
    }

    public CTDocument1 getDocument() {
        return this.ctDocument;
    }

    public List getBodyElements() {
        return Collections.unmodifiableList(this.bodyElements);
    }

    public List getParagraphs() {
        return Collections.unmodifiableList(this.paragraphs);
    }

    public List getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    public XWPFTable getTableArray(int pos) {
        if (pos > 0 && pos < this.tables.size()) {
            return (XWPFTable)this.tables.get(pos);
        }
        return null;
    }

    public List getFooterList() {
        return Collections.unmodifiableList(this.footers);
    }

    public XWPFFooter getFooterArray(int pos) {
        return (XWPFFooter)this.footers.get(pos);
    }

    public List getHeaderList() {
        return Collections.unmodifiableList(this.headers);
    }

    public XWPFHeader getHeaderArray(int pos) {
        return (XWPFHeader)this.headers.get(pos);
    }

    public String getTblStyle(XWPFTable table) {
        return table.getStyleID();
    }

    public XWPFHyperlink getHyperlinkByID(String id) {
        Iterator iter = this.hyperlinks.iterator();
        while (iter.hasNext()) {
            XWPFHyperlink link = (XWPFHyperlink)iter.next();
            if (!link.getId().equals(id)) continue;
            return link;
        }
        return null;
    }

    public XWPFFootnote getFootnoteByID(int id) {
        return (XWPFFootnote)this.footnotes.get(new Integer(id));
    }

    public XWPFFootnote getEndnoteByID(int id) {
        return (XWPFFootnote)this.endnotes.get(new Integer(id));
    }

    public Collection getFootnotes() {
        return Collections.unmodifiableCollection(this.footnotes == null ? new ArrayList() : this.footnotes.values());
    }

    public XWPFHyperlink[] getHyperlinks() {
        return this.hyperlinks.toArray(new XWPFHyperlink[this.hyperlinks.size()]);
    }

    public XWPFComment getCommentByID(String id) {
        Iterator iter = this.comments.iterator();
        while (iter.hasNext()) {
            XWPFComment comment = (XWPFComment)iter.next();
            if (!comment.getId().equals(id)) continue;
            return comment;
        }
        return null;
    }

    public XWPFComment[] getComments() {
        return this.comments.toArray(new XWPFComment[this.comments.size()]);
    }

    public PackagePart getPartById(String id) {
        try {
            return this.getTargetPart(this.getCorePart().getRelationship(id));
        }
        catch (InvalidFormatException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public XWPFHeaderFooterPolicy getHeaderFooterPolicy() {
        return this.headerFooterPolicy;
    }

    public CTStyles getStyle() throws XmlException, IOException {
        PackagePart[] parts;
        try {
            parts = this.getRelatedByType(XWPFRelation.STYLES.getRelation());
        }
        catch (InvalidFormatException e) {
            throw new IllegalStateException(e.getMessage());
        }
        if (parts.length != 1) {
            throw new IllegalStateException("Expecting one Styles document part, but found " + parts.length);
        }
        StylesDocument sd = StylesDocument.Factory.parse((InputStream)parts[0].getInputStream());
        return sd.getStyles();
    }

    public List getAllEmbedds() throws OpenXML4JException {
        PackageRelationship rel;
        LinkedList<PackagePart> embedds = new LinkedList<PackagePart>();
        Iterator iterator = this.getPackagePart().getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject").iterator();
        while (iterator.hasNext()) {
            rel = (PackageRelationship)iterator.next();
            embedds.add(this.getTargetPart(rel));
        }
        iterator = this.getPackagePart().getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/package").iterator();
        while (iterator.hasNext()) {
            rel = (PackageRelationship)iterator.next();
            embedds.add(this.getTargetPart(rel));
        }
        return embedds;
    }

    public int getParagraphPos(int pos) {
        if (pos >= 0 && pos < this.bodyElements.size() && ((IBodyElement)this.bodyElements.get(pos)).getElementType() == BodyElementType.PARAGRAPH) {
            int startPos = pos < this.paragraphs.size() ? pos : this.paragraphs.size();
            int i = startPos;
            while (i < 0) {
                if (this.paragraphs.get(i) == this.bodyElements.get(pos)) {
                    return i;
                }
                --i;
            }
        }
        if (this.paragraphs.size() == 0) {
            return 0;
        }
        return -1;
    }

    public int getTablePos(int pos) {
        if (pos >= 0 && pos < this.bodyElements.size() && ((IBodyElement)this.bodyElements.get(pos)).getElementType() == BodyElementType.TABLE) {
            int startPos = pos < this.tables.size() ? pos : this.tables.size();
            int i = startPos;
            while (i > 0) {
                if (this.tables.get(i) == this.bodyElements.get(pos)) {
                    return i;
                }
                --i;
            }
        }
        if (this.tables.size() == 0) {
            return 0;
        }
        return -1;
    }

    public XWPFParagraph insertNewParagraph(XmlCursor cursor) {
        if (this.isCursorInBody(cursor)) {
            String uri = CTP.type.getName().getNamespaceURI();
            String localPart = "p";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTP p = (CTP)cursor.getObject();
            XWPFParagraph newP = new XWPFParagraph(p, this);
            XmlObject o = null;
            while (!(o instanceof CTP) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTP) || (CTP)o == p) {
                this.paragraphs.add(0, newP);
            } else {
                int pos = this.paragraphs.indexOf(this.getParagraph((CTP)o)) + 1;
                this.paragraphs.add(pos, newP);
            }
            int i = 0;
            cursor.toCursor(p.newCursor());
            while (cursor.toPrevSibling()) {
                o = cursor.getObject();
                if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                ++i;
            }
            this.bodyElements.add(i, newP);
            cursor.toCursor(p.newCursor());
            cursor.toEndToken();
            return newP;
        }
        return null;
    }

    public XWPFTable insertNewTbl(XmlCursor cursor) {
        if (this.isCursorInBody(cursor)) {
            String uri = CTTbl.type.getName().getNamespaceURI();
            String localPart = "tbl";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTTbl t = (CTTbl)cursor.getObject();
            XWPFTable newT = new XWPFTable(t, this);
            cursor.removeXmlContents();
            XmlObject o = null;
            while (!(o instanceof CTTbl) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTTbl)) {
                this.tables.add(0, newT);
            } else {
                int pos = this.tables.indexOf(this.getTable((CTTbl)o)) + 1;
                this.tables.add(pos, newT);
            }
            int i = 0;
            cursor = t.newCursor();
            while (cursor.toPrevSibling()) {
                o = cursor.getObject();
                if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                ++i;
            }
            this.bodyElements.add(i, newT);
            cursor = t.newCursor();
            cursor.toEndToken();
            return newT;
        }
        return null;
    }

    private boolean isCursorInBody(XmlCursor cursor) {
        XmlCursor verify = cursor.newCursor();
        verify.toParent();
        if (verify.getObject() == this.ctDocument.getBody()) {
            return true;
        }
        XmlObject o = verify.getObject();
        return false;
    }

    public Integer getPosOfParagraph(XWPFParagraph p) {
        int pos = 0;
        int i = 0;
        while (i < this.bodyElements.size()) {
            if (this.bodyElements.get(i) instanceof XWPFParagraph) {
                if (this.bodyElements.get(i).equals(p)) {
                    return new Integer(pos);
                }
                ++pos;
            }
            ++i;
        }
        return null;
    }

    public Integer getPosOfTable(XWPFTable t) {
        int pos = 0;
        int i = 0;
        while (i < this.bodyElements.size()) {
            if (((IBodyElement)this.bodyElements.get(i)).getElementType() == BodyElementType.TABLE) {
                if (this.bodyElements.get(i) == t) {
                    return new Integer(pos);
                }
                ++pos;
            }
            ++i;
        }
        return null;
    }

    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTDocument1.type.getName().getNamespaceURI(), "document"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("http://schemas.openxmlformats.org/officeDocument/2006/math", "m");
        map.put("urn:schemas-microsoft-com:office:office", "o");
        map.put("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "r");
        map.put("urn:schemas-microsoft-com:vml", "v");
        map.put("http://schemas.openxmlformats.org/markup-compatibility/2006", "ve");
        map.put("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "w");
        map.put("urn:schemas-microsoft-com:office:word", "w10");
        map.put("http://schemas.microsoft.com/office/word/2006/wordml", "wne");
        map.put("http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing", "wp");
        xmlOptions.setSaveSuggestedPrefixes(map);
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.ctDocument.save(out, xmlOptions);
        out.close();
    }

    public XWPFParagraph createParagraph() {
        return new XWPFParagraph(this.ctDocument.getBody().addNewP(), this);
    }

    public boolean removeBodyElement(int pos) {
        if (pos >= 0 && pos < this.bodyElements.size()) {
            if (((IBodyElement)this.bodyElements.get(pos)).getElementType() == BodyElementType.TABLE) {
                this.bodyElements.remove(pos);
                Integer tablePos = new Integer(this.getTablePos(pos));
                this.tables.remove(tablePos);
                this.ctDocument.getBody().removeTbl(tablePos.intValue());
                return true;
            }
            if (((IBodyElement)this.bodyElements.get(pos)).getElementType() == BodyElementType.PARAGRAPH) {
                this.bodyElements.remove(pos);
                Integer paraPos = new Integer(this.getParagraphPos(pos));
                this.paragraphs.remove(paraPos);
                this.ctDocument.getBody().removeP(paraPos.intValue());
                return true;
            }
        }
        return false;
    }

    public void setParagraph(XWPFParagraph paragraph, int pos) {
        this.paragraphs.set(pos, paragraph);
        this.ctDocument.getBody().setPArray(pos, paragraph.getCTP());
    }

    public XWPFParagraph getLastParagraph() {
        int lastPos = this.paragraphs.toArray().length - 1;
        return (XWPFParagraph)this.paragraphs.get(lastPos);
    }

    public XWPFTable createTable() {
        return new XWPFTable(this.ctDocument.getBody().addNewTbl(), this);
    }

    public XWPFTable createTable(int rows, int cols) {
        return new XWPFTable(this.ctDocument.getBody().addNewTbl(), this, rows, cols);
    }

    public void createTOC() {
        CTSdtBlock block = this.getDocument().getBody().addNewSdt();
        TOC toc = new TOC(block);
        Iterator iterator = this.paragraphs.iterator();
        while (iterator.hasNext()) {
            XWPFParagraph par = (XWPFParagraph)iterator.next();
            String parStyle = par.getStyle();
            if (parStyle == null || !parStyle.substring(0, 7).equals("Heading")) continue;
            try {
                int level = Integer.parseInt(parStyle.substring("Heading".length()));
                toc.addRow(level, par.getText(), 1, "112723803");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    public void setTable(int pos, XWPFTable table) {
        this.tables.set(pos, table);
        this.ctDocument.getBody().setTblArray(pos, table.getCTTbl());
    }

    public boolean isEnforcedReadonlyProtection() {
        return this.settings.isEnforcedWith(STDocProtect.READ_ONLY);
    }

    public boolean isEnforcedFillingFormsProtection() {
        return this.settings.isEnforcedWith(STDocProtect.FORMS);
    }

    public boolean isEnforcedCommentsProtection() {
        return this.settings.isEnforcedWith(STDocProtect.COMMENTS);
    }

    public boolean isEnforcedTrackedChangesProtection() {
        return this.settings.isEnforcedWith(STDocProtect.TRACKED_CHANGES);
    }

    public void enforceReadonlyProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.READ_ONLY);
    }

    public void enforceFillingFormsProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.FORMS);
    }

    public void enforceCommentsProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.COMMENTS);
    }

    public void enforceTrackedChangesProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.TRACKED_CHANGES);
    }

    public void removeProtectionEnforcement() {
        this.settings.removeEnforcement();
    }

    public void insertTable(int pos, XWPFTable table) {
        this.bodyElements.add(pos, table);
        int i = 0;
        while (i < this.ctDocument.getBody().getTblArray().length) {
            CTTbl tbl = this.ctDocument.getBody().getTblArray(i);
            if (tbl == table.getCTTbl()) break;
            ++i;
        }
        this.tables.add(i, table);
    }

    public List getAllPictures() {
        if (this.pictures == null) {
            this.pictures = new ArrayList();
            Iterator iterator = this.getRelations().iterator();
            while (iterator.hasNext()) {
                POIXMLDocumentPart poixmlDocumentPart = (POIXMLDocumentPart)iterator.next();
                if (!(poixmlDocumentPart instanceof XWPFPictureData)) continue;
                this.pictures.add((XWPFPictureData)poixmlDocumentPart);
            }
        }
        return this.pictures;
    }

    public List getAllPackagePictures() {
        ArrayList pkgpictures = new ArrayList();
        pkgpictures.addAll(this.getAllPictures());
        Iterator iterator = this.getRelations().iterator();
        while (iterator.hasNext()) {
            POIXMLDocumentPart poixmlDocumentPart = (POIXMLDocumentPart)iterator.next();
            if (!(poixmlDocumentPart instanceof XWPFHeaderFooter)) continue;
            pkgpictures.addAll(((XWPFHeaderFooter)poixmlDocumentPart).getAllPictures());
        }
        return pkgpictures;
    }

    public int addPicture(InputStream is, int format) throws IOException, InvalidFormatException {
        int imageNumber = this.getNextPicNameNumber(format);
        XWPFPictureData img = (XWPFPictureData)this.createRelationship(XWPFPictureData.RELATIONS[format], XWPFFactory.getInstance(), imageNumber, false);
        OutputStream out = img.getPackagePart().getOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)out);
        out.close();
        this.pictures.add(img);
        return this.getAllPictures().size() - 1;
    }

    public int addPicture(byte[] pictureData, int format) throws InvalidFormatException {
        try {
            return this.addPicture(new ByteArrayInputStream(pictureData), format);
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
    }

    public int getNextPicNameNumber(int format) throws InvalidFormatException {
        int img = this.getAllPackagePictures().size() + 1;
        String proposal = XWPFPictureData.RELATIONS[format].getFileName(img);
        PackagePartName createPartName = PackagingURIHelper.createPartName(proposal);
        while (this.getPackage().getPart(createPartName) != null) {
            proposal = XWPFPictureData.RELATIONS[format].getFileName(++img);
            createPartName = PackagingURIHelper.createPartName(proposal);
        }
        return img;
    }

    public XWPFPictureData getPictureDataByID(String blipID) {
        Iterator iterator = this.getRelations().iterator();
        while (iterator.hasNext()) {
            POIXMLDocumentPart part = (POIXMLDocumentPart)iterator.next();
            if (part.getPackageRelationship() == null || part.getPackageRelationship().getId() == null || !part.getPackageRelationship().getId().equals(blipID)) continue;
            return (XWPFPictureData)part;
        }
        return null;
    }

    public XWPFNumbering getNumbering() {
        return this.numbering;
    }

    public XWPFStyles getStyles() {
        return this.styles;
    }

    public XWPFParagraph getParagraph(CTP p) {
        int i = 0;
        while (i < this.getParagraphs().size()) {
            if (((XWPFParagraph)this.getParagraphs().get(i)).getCTP() == p) {
                return (XWPFParagraph)this.getParagraphs().get(i);
            }
            ++i;
        }
        return null;
    }

    public XWPFTable getTable(CTTbl ctTbl) {
        int i = 0;
        while (i < this.tables.size()) {
            if (((XWPFTable)this.getTables().get(i)).getCTTbl() == ctTbl) {
                return (XWPFTable)this.getTables().get(i);
            }
            ++i;
        }
        return null;
    }

    public Iterator getTablesIterator() {
        return this.tables.iterator();
    }

    public Iterator getParagraphsIterator() {
        return this.paragraphs.iterator();
    }

    public XWPFParagraph getParagraphArray(int pos) {
        if (pos >= 0 && pos < this.paragraphs.size()) {
            return (XWPFParagraph)this.paragraphs.get(pos);
        }
        return null;
    }

    public IBody getPart() {
        return this;
    }

    public BodyType getPartType() {
        return BodyType.DOCUMENT;
    }

    public XWPFTableCell getTableCell(CTTc cell) {
        XmlCursor cursor = cell.newCursor();
        cursor.toParent();
        XmlObject o = cursor.getObject();
        if (!(o instanceof CTRow)) {
            return null;
        }
        CTRow row = (CTRow)o;
        cursor.toParent();
        o = cursor.getObject();
        if (!(o instanceof CTTbl)) {
            return null;
        }
        CTTbl tbl = (CTTbl)o;
        XWPFTable table = this.getTable(tbl);
        if (table == null) {
            return null;
        }
        XWPFTableRow tableRow = table.getRow(row);
        if (row == null) {
            // empty if block
        }
        return tableRow.getTableCell(cell);
    }
}

