/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */

package org.apache.poi.xssf.util;

import java.util.Comparator;

import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;

public class CTColComparator implements Comparator{

    public int compare(Object io1, Object io2) {
    	CTCol o1 = (CTCol) io1;
    	CTCol o2 = (CTCol) io2;
        if (o1.getMin() < o2.getMin()) {
            return -1;
        }
        else if (o1.getMin() > o2.getMin()) {
            return 1;
        }
        else {
            if (o1.getMax() < o2.getMax()) {
                return -1;
            }
            if (o1.getMax() > o2.getMax()) {
                return 1;
            }
            return 0;
        }
    }



}
