/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdgf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HDGFLZW {
    public static byte fromInt(int b) {
        if (b < 128) {
            return (byte)b;
        }
        return (byte)(b - 256);
    }

    public static int fromByte(byte b) {
        if (b >= 0) {
            return b;
        }
        return b + 256;
    }

    public byte[] compress(InputStream src) throws IOException {
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        this.compress(src, res);
        return res.toByteArray();
    }

    public byte[] decode(InputStream src) throws IOException {
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        this.decode(src, res);
        return res.toByteArray();
    }

    public void decode(InputStream src, OutputStream res) throws IOException {
        int flag;
        byte[] buffer = new byte[4096];
        int pos = 0;
        block0: while ((flag = src.read()) != -1) {
            int mask = 1;
            while (mask < 256) {
                if ((flag & mask) > 0) {
                    int dataI = src.read();
                    if (dataI != -1) {
                        buffer[pos & 0xFFF] = HDGFLZW.fromInt(dataI);
                        ++pos;
                        res.write(new byte[]{HDGFLZW.fromInt(dataI)});
                    }
                } else {
                    int dataIPt1 = src.read();
                    int dataIPt2 = src.read();
                    if (dataIPt1 == -1 || dataIPt2 == -1) continue block0;
                    int len = (dataIPt2 & 0xF) + 3;
                    int pntr = (dataIPt2 & 0xF0) * 16 + dataIPt1;
                    pntr = pntr > 4078 ? (pntr -= 4078) : (pntr += 18);
                    int i = 0;
                    while (i < len) {
                        buffer[pos + i & 0xFFF] = buffer[pntr + i & 0xFFF];
                        byte dataB = buffer[pntr + i & 0xFFF];
                        res.write(new byte[]{dataB});
                        ++i;
                    }
                    pos += len;
                }
                mask <<= 1;
            }
        }
    }

    public void compress(InputStream src, OutputStream res) throws IOException {
        Compressor c = new Compressor();
        c.compress(src, res);
    }

    private static final class Compressor {
        byte[] dict = new byte[4096];
        byte[] buffer = new byte[16];
        int bufferLen = 0;
        byte[] rawCode = new byte[16];
        int rawCodeLen = 0;
        int posInp = 0;
        int posOut = 0;
        int nextMask = 0;
        int maskBitsSet = 0;

        private int findRawCodeInBuffer() {
            int i = this.buffer.length - this.rawCodeLen;
            while (i >= 0) {
                boolean matches = true;
                int j = 0;
                while (matches && j < this.rawCodeLen) {
                    if (this.buffer[i] != this.rawCode[j]) {
                        matches = false;
                    }
                    ++j;
                }
                if (matches) {
                    return i;
                }
                --i;
            }
            return -1;
        }

        private void outputCompressed(OutputStream res) throws IOException {
            if (this.rawCodeLen < 3) {
                int i = 0;
                while (i < this.rawCodeLen) {
                    this.outputUncompressed(this.rawCode[i], res);
                    ++i;
                }
                return;
            }
            ++this.maskBitsSet;
            this.posOut += 2;
            if (this.maskBitsSet == 8) {
                this.output8Codes(res);
            }
        }

        private void outputUncompressed(byte b, OutputStream res) throws IOException {
            this.nextMask += 1 << this.maskBitsSet;
            this.buffer[this.bufferLen] = HDGFLZW.fromInt(b);
            ++this.bufferLen;
            this.dict[this.posOut & 0xFFF] = HDGFLZW.fromInt(b);
            ++this.posOut;
            if (this.maskBitsSet == 8) {
                this.output8Codes(res);
            }
        }

        private void output8Codes(OutputStream res) throws IOException {
            res.write(new byte[]{HDGFLZW.fromInt(this.nextMask)});
            res.write(this.buffer, 0, this.bufferLen);
            this.nextMask = 0;
            this.maskBitsSet = 0;
            this.bufferLen = 0;
        }

        public void compress(InputStream src, OutputStream res) throws IOException {
            boolean going = true;
            while (going) {
                int dataI = src.read();
                ++this.posInp;
                if (dataI == -1) {
                    going = false;
                }
                byte dataB = HDGFLZW.fromInt(dataI);
                if (!going && this.rawCodeLen > 0) {
                    this.outputCompressed(res);
                    break;
                }
                this.rawCode[this.rawCodeLen] = dataB;
                ++this.rawCodeLen;
                int rawAt = this.findRawCodeInBuffer();
                if (this.rawCodeLen == 16 && rawAt > -1) {
                    this.outputCompressed(res);
                    this.rawCodeLen = 0;
                    continue;
                }
                if (rawAt > -1) continue;
                --this.rawCodeLen;
                if (this.rawCodeLen > 0) {
                    this.outputCompressed(res);
                    this.rawCode[0] = dataB;
                    this.rawCodeLen = 1;
                    if (this.findRawCodeInBuffer() > -1) continue;
                    this.outputUncompressed(dataB, res);
                    this.rawCodeLen = 0;
                    continue;
                }
                this.outputUncompressed(dataB, res);
            }
        }
    }
}

