/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.hwpf.model.io.HWPFFileSystem;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.LittleEndian;

public final class ComplexFileTable {
    private static final byte GRPPRL_TYPE = 1;
    private static final byte TEXT_PIECE_TABLE_TYPE = 2;
    protected TextPieceTable _tpt;

    public ComplexFileTable() {
        this._tpt = new TextPieceTable();
    }

    public ComplexFileTable(byte[] documentStream, byte[] tableStream, int offset, int fcMin) throws IOException {
        while (tableStream[offset] == 1) {
            short skip = LittleEndian.getShort((byte[])tableStream, (int)(++offset));
            offset += 2 + skip;
        }
        if (tableStream[offset] != 2) {
            throw new IOException("The text piece table is corrupted");
        }
        int pieceTableSize = LittleEndian.getInt((byte[])tableStream, (int)(++offset));
        this._tpt = new TextPieceTable(documentStream, tableStream, offset += 4, pieceTableSize, fcMin);
    }

    public TextPieceTable getTextPieceTable() {
        return this._tpt;
    }

    public void writeTo(HWPFFileSystem sys) throws IOException {
        HWPFOutputStream docStream = sys.getStream("WordDocument");
        HWPFOutputStream tableStream = sys.getStream("1Table");
        tableStream.write(2);
        byte[] table = this._tpt.writeTo(docStream);
        byte[] numHolder = new byte[4];
        LittleEndian.putInt((byte[])numHolder, (int)table.length);
        tableStream.write(numHolder);
        tableStream.write(table);
    }
}

