/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.ArrayList;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PropertyNode;
import org.apache.poi.util.LittleEndian;

public final class PlexOfCps {
    private int _count;
    private int _offset;
    private int _sizeOfStruct;
    private ArrayList _props;

    public PlexOfCps(int sizeOfStruct) {
        this._props = new ArrayList();
        this._sizeOfStruct = sizeOfStruct;
    }

    public PlexOfCps(byte[] buf, int start, int size, int sizeOfStruct) {
        this._count = (size - 4) / (4 + sizeOfStruct);
        this._sizeOfStruct = sizeOfStruct;
        this._props = new ArrayList(this._count);
        int x = 0;
        while (x < this._count) {
            this._props.add(this.getProperty(x, buf, start));
            ++x;
        }
    }

    public GenericPropertyNode getProperty(int index) {
        return (GenericPropertyNode)this._props.get(index);
    }

    public void addProperty(GenericPropertyNode node) {
        this._props.add(node);
    }

    public byte[] toByteArray() {
        int size = this._props.size();
        int cpBufSize = (size + 1) * 4;
        int structBufSize = this._sizeOfStruct * size;
        int bufSize = cpBufSize + structBufSize;
        byte[] buf = new byte[bufSize];
        PropertyNode node = null;
        int x = 0;
        while (x < size) {
            node = (GenericPropertyNode)this._props.get(x);
            LittleEndian.putInt((byte[])buf, (int)(4 * x), (int)node.getStart());
            System.arraycopy(((GenericPropertyNode)node).getBytes(), 0, buf, cpBufSize + x * this._sizeOfStruct, this._sizeOfStruct);
            ++x;
        }
        LittleEndian.putInt((byte[])buf, (int)(4 * size), (int)node.getEnd());
        return buf;
    }

    private GenericPropertyNode getProperty(int index, byte[] buf, int offset) {
        int start = LittleEndian.getInt((byte[])buf, (int)(offset + this.getIntOffset(index)));
        int end = LittleEndian.getInt((byte[])buf, (int)(offset + this.getIntOffset(index + 1)));
        byte[] struct = new byte[this._sizeOfStruct];
        System.arraycopy(buf, offset + this.getStructOffset(index), struct, 0, this._sizeOfStruct);
        return new GenericPropertyNode(start, end, struct);
    }

    private int getIntOffset(int index) {
        return index * 4;
    }

    public int length() {
        return this._count;
    }

    private int getStructOffset(int index) {
        return 4 * (this._count + 1) + this._sizeOfStruct * index;
    }
}

