/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.poi.ddf.EscherArrayProperty;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.hslf.model.Line;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.ShapeGroup;
import org.apache.poi.hslf.model.Sheet;
import org.apache.poi.hslf.model.TableCell;
import org.apache.poi.hslf.model.TextShape;
import org.apache.poi.util.LittleEndian;

public final class Table
extends ShapeGroup {
    protected static final int BORDER_TOP = 1;
    protected static final int BORDER_RIGHT = 2;
    protected static final int BORDER_BOTTOM = 3;
    protected static final int BORDER_LEFT = 4;
    protected static final int BORDERS_ALL = 5;
    protected static final int BORDERS_OUTSIDE = 6;
    protected static final int BORDERS_INSIDE = 7;
    protected static final int BORDERS_NONE = 8;
    protected TableCell[][] cells;

    public Table(int numrows, int numcols) {
        if (numrows < 1) {
            throw new IllegalArgumentException("The number of rows must be greater than 1");
        }
        if (numcols < 1) {
            throw new IllegalArgumentException("The number of columns must be greater than 1");
        }
        int x = 0;
        int y = 0;
        int tblWidth = 0;
        int tblHeight = 0;
        this.cells = new TableCell[numrows][numcols];
        int i = 0;
        while (i < this.cells.length) {
            x = 0;
            int j = 0;
            while (j < this.cells[i].length) {
                this.cells[i][j] = new TableCell(this);
                Rectangle anchor = new Rectangle(x, y, 100, 40);
                this.cells[i][j].setAnchor(anchor);
                x += 100;
                ++j;
            }
            y += 40;
            ++i;
        }
        tblWidth = x;
        tblHeight = y;
        this.setAnchor(new Rectangle(0, 0, tblWidth, tblHeight));
        EscherContainerRecord spCont = (EscherContainerRecord)this.getSpContainer().getChild(0);
        EscherOptRecord opt = new EscherOptRecord();
        opt.setRecordId((short)-3806);
        opt.addEscherProperty((EscherProperty)new EscherSimpleProperty(927, 1));
        EscherArrayProperty p = new EscherArrayProperty(17312, false, null);
        p.setSizeOfElements(4);
        p.setNumberOfElementsInArray(numrows);
        p.setNumberOfElementsInMemory(numrows);
        opt.addEscherProperty((EscherProperty)p);
        List lst = spCont.getChildRecords();
        lst.add(lst.size() - 1, opt);
        spCont.setChildRecords(lst);
    }

    public Table(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    public TableCell getCell(int row, int col) {
        return this.cells[row][col];
    }

    public int getNumberOfColumns() {
        return this.cells[0].length;
    }

    public int getNumberOfRows() {
        return this.cells.length;
    }

    protected void afterInsert(Sheet sh) {
        super.afterInsert(sh);
        EscherContainerRecord spCont = (EscherContainerRecord)this.getSpContainer().getChild(0);
        List lst = spCont.getChildRecords();
        EscherOptRecord opt = (EscherOptRecord)lst.get(lst.size() - 2);
        EscherArrayProperty p = (EscherArrayProperty)opt.getEscherProperty(1);
        int i = 0;
        while (i < this.cells.length) {
            TableCell cell = this.cells[i][0];
            int rowHeight = cell.getAnchor().height * 576 / 72;
            byte[] val = new byte[4];
            LittleEndian.putInt((byte[])val, (int)rowHeight);
            p.setElement(i, val);
            int j = 0;
            while (j < this.cells[i].length) {
                Line bl;
                Line bb;
                Line br;
                TableCell c = this.cells[i][j];
                this.addShape(c);
                Line bt = c.getBorderTop();
                if (bt != null) {
                    this.addShape(bt);
                }
                if ((br = c.getBorderRight()) != null) {
                    this.addShape(br);
                }
                if ((bb = c.getBorderBottom()) != null) {
                    this.addShape(bb);
                }
                if ((bl = c.getBorderLeft()) != null) {
                    this.addShape(bl);
                }
                ++j;
            }
            ++i;
        }
    }

    protected void initTable() {
        Shape[] sh = this.getShapes();
        Arrays.sort(sh, new Comparator(){

            public int compare(Object o1, Object o2) {
                Rectangle anchor1 = ((Shape)o1).getAnchor();
                Rectangle anchor2 = ((Shape)o2).getAnchor();
                int delta = anchor1.y - anchor2.y;
                if (delta == 0) {
                    delta = anchor1.x - anchor2.x;
                }
                return delta;
            }
        });
        int y0 = -1;
        int maxrowlen = 0;
        ArrayList lst = new ArrayList();
        ArrayList<Shape> row = null;
        int i = 0;
        while (i < sh.length) {
            if (sh[i] instanceof TextShape) {
                Rectangle anchor = sh[i].getAnchor();
                if (anchor.y != y0) {
                    y0 = anchor.y;
                    row = new ArrayList<Shape>();
                    lst.add(row);
                }
                row.add(sh[i]);
                maxrowlen = Math.max(maxrowlen, row.size());
            }
            ++i;
        }
        this.cells = new TableCell[lst.size()][maxrowlen];
        i = 0;
        while (i < lst.size()) {
            row = (ArrayList<Shape>)lst.get(i);
            int j = 0;
            while (j < row.size()) {
                TextShape tx = (TextShape)row.get(j);
                this.cells[i][j] = new TableCell(tx.getSpContainer(), this.getParent());
                this.cells[i][j].setSheet(tx.getSheet());
                ++j;
            }
            ++i;
        }
    }

    public void setSheet(Sheet sheet) {
        super.setSheet(sheet);
        if (this.cells == null) {
            this.initTable();
        }
    }

    public void setRowHeight(int row, int height) {
        int currentHeight = this.cells[row][0].getAnchor().height;
        int dy = height - currentHeight;
        int i = row;
        while (i < this.cells.length) {
            int j = 0;
            while (j < this.cells[i].length) {
                Rectangle anchor = this.cells[i][j].getAnchor();
                if (i == row) {
                    anchor.height = height;
                } else {
                    anchor.y += dy;
                }
                this.cells[i][j].setAnchor(anchor);
                ++j;
            }
            ++i;
        }
        Rectangle tblanchor = this.getAnchor();
        tblanchor.height += dy;
        this.setAnchor(tblanchor);
    }

    public void setColumnWidth(int col, int width) {
        int currentWidth = this.cells[0][col].getAnchor().width;
        int dx = width - currentWidth;
        int i = 0;
        while (i < this.cells.length) {
            Rectangle anchor = this.cells[i][col].getAnchor();
            anchor.width = width;
            this.cells[i][col].setAnchor(anchor);
            if (col < this.cells[i].length - 1) {
                int j = col + 1;
                while (j < this.cells[i].length) {
                    anchor = this.cells[i][j].getAnchor();
                    anchor.x += dx;
                    this.cells[i][j].setAnchor(anchor);
                    ++j;
                }
            }
            ++i;
        }
        Rectangle tblanchor = this.getAnchor();
        tblanchor.width += dx;
        this.setAnchor(tblanchor);
    }

    public void setAllBorders(Line line) {
        int i = 0;
        while (i < this.cells.length) {
            int j = 0;
            while (j < this.cells[i].length) {
                TableCell cell = this.cells[i][j];
                cell.setBorderTop(this.cloneBorder(line));
                cell.setBorderLeft(this.cloneBorder(line));
                if (j == this.cells[i].length - 1) {
                    cell.setBorderRight(this.cloneBorder(line));
                }
                if (i == this.cells.length - 1) {
                    cell.setBorderBottom(this.cloneBorder(line));
                }
                ++j;
            }
            ++i;
        }
    }

    public void setOutsideBorders(Line line) {
        int i = 0;
        while (i < this.cells.length) {
            int j = 0;
            while (j < this.cells[i].length) {
                TableCell cell = this.cells[i][j];
                if (j == 0) {
                    cell.setBorderLeft(this.cloneBorder(line));
                }
                if (j == this.cells[i].length - 1) {
                    cell.setBorderRight(this.cloneBorder(line));
                } else {
                    cell.setBorderLeft(null);
                    cell.setBorderLeft(null);
                }
                if (i == 0) {
                    cell.setBorderTop(this.cloneBorder(line));
                } else if (i == this.cells.length - 1) {
                    cell.setBorderBottom(this.cloneBorder(line));
                } else {
                    cell.setBorderTop(null);
                    cell.setBorderBottom(null);
                }
                ++j;
            }
            ++i;
        }
    }

    public void setInsideBorders(Line line) {
        int i = 0;
        while (i < this.cells.length) {
            int j = 0;
            while (j < this.cells[i].length) {
                TableCell cell = this.cells[i][j];
                if (j != this.cells[i].length - 1) {
                    cell.setBorderRight(this.cloneBorder(line));
                } else {
                    cell.setBorderLeft(null);
                    cell.setBorderLeft(null);
                }
                if (i != this.cells.length - 1) {
                    cell.setBorderBottom(this.cloneBorder(line));
                } else {
                    cell.setBorderTop(null);
                    cell.setBorderBottom(null);
                }
                ++j;
            }
            ++i;
        }
    }

    private Line cloneBorder(Line line) {
        Line border = this.createBorder();
        border.setLineWidth(line.getLineWidth());
        border.setLineStyle(line.getLineStyle());
        border.setLineDashing(line.getLineDashing());
        border.setLineColor(line.getLineColor());
        return border;
    }

    public Line createBorder() {
        Line line = new Line(this);
        EscherOptRecord opt = (EscherOptRecord)Table.getEscherChild(line.getSpContainer(), -4085);
        Table.setEscherProperty(opt, (short)324, -1);
        Table.setEscherProperty(opt, (short)383, -1);
        Table.setEscherProperty(opt, (short)575, 131072);
        Table.setEscherProperty(opt, (short)703, 524288);
        return line;
    }
}

