/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.constant;

import org.apache.poi.ss.formula.constant.ErrorConstant;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.StringUtil;

public final class ConstantValueParser {
    private static final int TYPE_EMPTY = 0;
    private static final int TYPE_NUMBER = 1;
    private static final int TYPE_STRING = 2;
    private static final int TYPE_BOOLEAN = 4;
    private static final int TYPE_ERROR_CODE = 16;
    private static final int TRUE_ENCODING = 1;
    private static final int FALSE_ENCODING = 0;
    private static final Object EMPTY_REPRESENTATION = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private ConstantValueParser() {
    }

    public static Object[] parse(LittleEndianInput in, int nValues) {
        Object[] result = new Object[nValues];
        int i = 0;
        while (i < result.length) {
            result[i] = ConstantValueParser.readAConstantValue(in);
            ++i;
        }
        return result;
    }

    private static Object readAConstantValue(LittleEndianInput in) {
        byte grbit = in.readByte();
        switch (grbit) {
            case 0: {
                in.readLong();
                return EMPTY_REPRESENTATION;
            }
            case 1: {
                return new Double(in.readDouble());
            }
            case 2: {
                return StringUtil.readUnicodeString(in);
            }
            case 4: {
                return ConstantValueParser.readBoolean(in);
            }
            case 16: {
                int errCode = in.readUShort();
                in.readUShort();
                in.readInt();
                return ErrorConstant.valueOf(errCode);
            }
        }
        throw new RuntimeException("Unknown grbit value (" + grbit + ")");
    }

    private static Object readBoolean(LittleEndianInput in) {
        byte val = (byte)in.readLong();
        switch (val) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        throw new RuntimeException("unexpected boolean encoding (" + val + ")");
    }

    public static int getEncodedSize(Object[] values) {
        int result = values.length * 1;
        int i = 0;
        while (i < values.length) {
            result += ConstantValueParser.getEncodedSize(values[i]);
            ++i;
        }
        return result;
    }

    private static int getEncodedSize(Object object) {
        block17: {
            block16: {
                if (object == EMPTY_REPRESENTATION) {
                    return 8;
                }
                Class<?> cls = object.getClass();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (cls == clazz) break block16;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (cls == clazz2) break block16;
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("org.apache.poi.ss.formula.constant.ErrorConstant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (cls != clazz3) break block17;
            }
            return 8;
        }
        String strVal = (String)object;
        return StringUtil.getEncodedSize(strVal);
    }

    public static void encode(LittleEndianOutput out, Object[] values) {
        int i = 0;
        while (i < values.length) {
            ConstantValueParser.encodeSingleValue(out, values[i]);
            ++i;
        }
    }

    private static void encodeSingleValue(LittleEndianOutput out, Object value) {
        if (value == EMPTY_REPRESENTATION) {
            out.writeByte(0);
            out.writeLong(0L);
            return;
        }
        if (value instanceof Boolean) {
            Boolean bVal = (Boolean)value;
            out.writeByte(4);
            long longVal = bVal != false ? 1L : 0L;
            out.writeLong(longVal);
            return;
        }
        if (value instanceof Double) {
            Double dVal = (Double)value;
            out.writeByte(1);
            out.writeDouble(dVal);
            return;
        }
        if (value instanceof String) {
            String val = (String)value;
            out.writeByte(2);
            StringUtil.writeUnicodeString(out, val);
            return;
        }
        if (value instanceof ErrorConstant) {
            ErrorConstant ecVal = (ErrorConstant)value;
            out.writeByte(16);
            long longVal = ecVal.getErrorCode();
            out.writeLong(longVal);
            return;
        }
        throw new IllegalStateException("Unexpected value type (" + value.getClass().getName() + "'");
    }
}

