/*
 * Decompiled with CFR 0.152.
 */
package poi.support;

import java.io.IOException;
import java.io.OutputStream;
import poi.support.Closeable;
import poi.support.Flushable;
import poi.support.POIFormatterUtil;

public class POIFormatter
implements Closeable,
Flushable {
    private StringBuffer sb;
    private OutputStream os;
    private boolean hasClosed;
    private IOException ioException;

    public POIFormatter(StringBuffer sb) {
        this.os = null;
        this.sb = sb;
        this.hasClosed = false;
        this.ioException = null;
    }

    public POIFormatter(OutputStream os) {
        this.os = os;
        this.sb = new StringBuffer();
        this.hasClosed = false;
        this.ioException = null;
    }

    public void format(String fmt, Object[] parts) {
        if (this.os != null) {
            StringBuffer s = new StringBuffer();
            POIFormatterUtil.format(s, fmt, parts);
            try {
                this.os.write(new String(s).getBytes());
            }
            catch (IOException e) {
                this.ioException = e;
                e.printStackTrace();
            }
        } else {
            POIFormatterUtil.format(this.sb, fmt, parts);
        }
    }

    public void format(String fmt) {
        this.format(fmt, null);
    }

    public String toString() {
        if (this.os != null) {
            return this.os.toString();
        }
        return new String(this.sb);
    }

    public void flush() {
        try {
            this.os.flush();
        }
        catch (IOException e) {
            this.ioException = e;
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.hasClosed) {
            throw new RuntimeException("FormatterClosedException");
        }
        this.hasClosed = true;
        try {
            this.os.close();
        }
        catch (IOException e) {
            this.ioException = e;
            e.printStackTrace();
        }
    }

    public IOException ioException() {
        return this.ioException;
    }
}

