/*
 * Decompiled with CFR 0.152.
 */
package poi.support;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class POIFormatterUtil {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private POIFormatterUtil() {
    }

    public static StringBuffer format(StringBuffer s, String fmt, Object[] parts) {
        Pattern pat = Pattern.compile("%[\\-+ #0]?[0-9\\.]*[hljztL]*[diuoxXeEfFgGaAcspn]");
        Matcher matcher = pat.matcher(fmt);
        int pi = 0;
        int previousEnd = 0;
        block8: while (matcher.find()) {
            String dest;
            String src = matcher.group();
            s.append(fmt.substring(previousEnd, matcher.start()));
            char c = src.charAt(src.length() - 1);
            boolean isZeroPadding = src.charAt(1) == '0';
            int maxLength = 0;
            int decimalLength = 0;
            switch (c) {
                case 's': {
                    if (isZeroPadding) {
                        throw new RuntimeException("FormatFlagsConversionMismatchException: Conversion = s, Flags = 0");
                    }
                    maxLength = src.charAt(1) == 's' ? 0 : Integer.parseInt(src.substring(1, src.length() - 1));
                    if (parts == null) {
                        dest = "null";
                        break;
                    }
                    dest = POIFormatterUtil.getStringValue(parts[pi]);
                    break;
                }
                case 'd': {
                    maxLength = isZeroPadding ? Integer.parseInt(src.substring(2, src.length() - 1)) : (src.charAt(1) == 'd' ? 0 : Integer.parseInt(src.substring(1, src.length() - 1)));
                    if (parts == null) {
                        dest = "null";
                        if (maxLength <= dest.length()) break;
                        StringBuffer sp = new StringBuffer();
                        int i = 0;
                        while (i < maxLength - dest.length()) {
                            sp.append(' ');
                            ++i;
                        }
                        sp.append(dest);
                        dest = new String(sp);
                        break;
                    }
                    DecimalFormat df = new DecimalFormat("0");
                    dest = df.format(POIFormatterUtil.getDecimalValue(parts[pi]));
                    break;
                }
                case 'E': 
                case 'e': {
                    int dotIndex = src.indexOf(46);
                    if (dotIndex < 0) {
                        maxLength = src.length() > 2 ? Integer.parseInt(src.substring(1, src.length() - 1)) : 0;
                        decimalLength = 0;
                        DecimalFormat df = new DecimalFormat("0.000000E00");
                        dest = parts == null ? (c == 'E' ? "NULL" : "null") : df.format(POIFormatterUtil.getDoubleValue(parts[pi]));
                    } else {
                        maxLength = dotIndex > 1 ? Integer.parseInt(src.substring(1, dotIndex)) : 0;
                        decimalLength = Integer.parseInt(src.substring(dotIndex + 1, src.length() - 1));
                        StringBuffer dfmt = new StringBuffer("0.");
                        int i = 0;
                        while (i < decimalLength) {
                            dfmt.append('0');
                            ++i;
                        }
                        dfmt.append("E00");
                        if (parts == null) {
                            dest = c == 'E' ? "NULL" : "null";
                            if (decimalLength > dest.length()) {
                                StringBuffer sp = new StringBuffer();
                                int i2 = 0;
                                while (i2 < decimalLength - dest.length()) {
                                    sp.append(' ');
                                    ++i2;
                                }
                                sp.append(dest);
                                dest = new String(sp);
                            }
                        } else {
                            DecimalFormat df = new DecimalFormat(dfmt.toString());
                            dest = df.format(POIFormatterUtil.getDoubleValue(parts[pi]));
                        }
                    }
                    int eIndex = dest.indexOf(69);
                    if (eIndex >= 0 && '-' != dest.charAt(eIndex + 1)) {
                        dest = String.valueOf(dest.substring(0, eIndex)) + c + "+" + dest.substring(eIndex + 1);
                    }
                    if (c != 'e') break;
                    dest = dest.replace('E', 'e');
                    break;
                }
                case 'f': {
                    int dotIndex = src.indexOf(46);
                    if (dotIndex < 0) {
                        maxLength = src.length() > 2 ? Integer.parseInt(src.substring(1, src.length() - 1)) : 0;
                        decimalLength = 0;
                        DecimalFormat df = new DecimalFormat("0.000000");
                        if (parts == null) {
                            dest = "null";
                            break;
                        }
                        dest = df.format(POIFormatterUtil.getDoubleValue(parts[pi]));
                        break;
                    }
                    maxLength = dotIndex > 1 ? Integer.parseInt(src.substring(1, dotIndex)) : 0;
                    decimalLength = Integer.parseInt(src.substring(dotIndex + 1, src.length() - 1));
                    StringBuffer dfmt = new StringBuffer("0");
                    if (decimalLength > 0) {
                        dfmt.append('.');
                    }
                    int i = 0;
                    while (i < decimalLength) {
                        dfmt.append('0');
                        ++i;
                    }
                    if (parts == null) {
                        dest = "null";
                        if (dotIndex <= dest.length()) break;
                        StringBuffer sp = new StringBuffer();
                        int i3 = 0;
                        while (i3 < maxLength - dest.length()) {
                            sp.append(' ');
                            ++i3;
                        }
                        sp.append(dest);
                        dest = new String(sp);
                        break;
                    }
                    DecimalFormat df = new DecimalFormat(dfmt.toString());
                    dest = df.format(POIFormatterUtil.getDoubleValue(parts[pi]));
                    break;
                }
                case 'x': {
                    StringBuffer dfmt = new StringBuffer();
                    int len = 0;
                    boolean hasLength = false;
                    if (isZeroPadding) {
                        hasLength = true;
                        len = Integer.parseInt(src.substring(2, src.length() - 1));
                        int i = 0;
                        while (i < len) {
                            dfmt.append('0');
                            ++i;
                        }
                    } else if (src.charAt(1) != 'x') {
                        hasLength = true;
                        len = Integer.parseInt(src.substring(1, src.length() - 1));
                        int i = 0;
                        while (i < len) {
                            dfmt.append(' ');
                            ++i;
                        }
                    }
                    if (parts == null) {
                        dest = "null";
                        if (len <= dest.length()) break;
                        StringBuffer sp = new StringBuffer();
                        int i = 0;
                        while (i < len - dest.length()) {
                            sp.append(' ');
                            ++i;
                        }
                        sp.append(dest);
                        dest = new String(sp);
                        break;
                    }
                    String hex = Long.toHexString(POIFormatterUtil.getDecimalValue(parts[pi]));
                    dest = String.valueOf(dfmt.toString()) + hex;
                    if (hasLength && hex.length() < len) {
                        dest = dest.substring(dest.length() - len);
                        break;
                    }
                    dest = hex;
                    break;
                }
                case 'n': {
                    s.append(LINE_SEPARATOR);
                    previousEnd = matcher.end();
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Not supported:" + src);
                }
            }
            if (maxLength > dest.length()) {
                int i;
                StringBuffer sp = new StringBuffer();
                int paddingLength = maxLength - dest.length();
                if (isZeroPadding && parts != null) {
                    i = 0;
                    while (i < paddingLength) {
                        sp.append('0');
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < paddingLength) {
                        sp.append(' ');
                        ++i;
                    }
                }
                s.append(sp);
            }
            s.append(dest);
            previousEnd = matcher.end();
            ++pi;
        }
        if (fmt.length() > previousEnd) {
            s.append(fmt.substring(previousEnd));
        }
        return s;
    }

    private static String getStringValue(Object value) {
        return value.toString();
    }

    private static Long getDecimalValue(Object value) {
        Long result;
        if (value instanceof Integer) {
            result = new Long(((Integer)value).intValue());
        } else if (value instanceof Short) {
            result = new Long(((Short)value).shortValue());
        } else if (value instanceof Byte) {
            result = new Long(((Byte)value).byteValue());
        } else if (value instanceof Long) {
            result = (Long)value;
        } else {
            throw new RuntimeException("not supported.");
        }
        return result;
    }

    private static Double getDoubleValue(Object value) {
        Double result;
        if (value instanceof Float) {
            result = new Double(((Float)value).floatValue());
        } else if (value instanceof Double) {
            result = (Double)value;
        } else if (value instanceof Long) {
            result = new Double(((Long)value).longValue());
        } else {
            throw new RuntimeException("not supported.");
        }
        return result;
    }
}

