/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.extractor;

import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFMap;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xssf.usermodel.helpers.XSSFSingleXmlCell;
import org.apache.poi.xssf.usermodel.helpers.XSSFXmlColumnPr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import poi.support.NodeUtil;

public class XSSFImportFromXML {
    private final XSSFMap _map;
    private static POILogger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.xssf.extractor.XSSFImportFromXML");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = POILogFactory.getLogger((Class)clazz);
    }

    public XSSFImportFromXML(XSSFMap map) {
        this._map = map;
    }

    public void importFromXML(String xmlInputString) throws SAXException, XPathExpressionException, ParserConfigurationException, IOException {
        Object result;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xmlInputString.trim())));
        List singleXmlCells = this._map.getRelatedSingleXMLCell();
        List tables = this._map.getRelatedTables();
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        xpath.setNamespaceContext(new DefaultNamespaceContext(doc));
        Iterator iterator = singleXmlCells.iterator();
        while (iterator.hasNext()) {
            XSSFSingleXmlCell singleXmlCell = (XSSFSingleXmlCell)iterator.next();
            String xpathString = singleXmlCell.getXpath();
            result = (Node)xpath.evaluate(xpathString, doc, XPathConstants.NODE);
            String textContent = NodeUtil.getTextContent((Node)result);
            logger.log(POILogger.DEBUG, (Object)("Extracting with xpath " + xpathString + " : value is '" + textContent + "'"));
            XSSFCell cell = singleXmlCell.getReferencedCell();
            logger.log(POILogger.DEBUG, (Object)("Setting '" + textContent + "' to cell " + cell.getColumnIndex() + "-" + cell.getRowIndex() + " in sheet " + cell.getSheet().getSheetName()));
            cell.setCellValue(textContent);
        }
        iterator = tables.iterator();
        while (iterator.hasNext()) {
            XSSFTable table = (XSSFTable)iterator.next();
            String commonXPath = table.getCommonXpath();
            result = (NodeList)xpath.evaluate(commonXPath, doc, XPathConstants.NODESET);
            int rowOffset = table.getStartCellReference().getRow() + 1;
            int columnOffset = table.getStartCellReference().getCol() - 1;
            int i = 0;
            while (i < result.getLength()) {
                Iterator iterator2 = table.getXmlColumnPrs().iterator();
                while (iterator2.hasNext()) {
                    XSSFCell cell;
                    XSSFXmlColumnPr xmlColumnPr = (XSSFXmlColumnPr)iterator2.next();
                    int localColumnId = (int)xmlColumnPr.getId();
                    int rowId = rowOffset + i;
                    int columnId = columnOffset + localColumnId;
                    String localXPath = xmlColumnPr.getLocalXPath();
                    localXPath = localXPath.substring(localXPath.substring(1).indexOf(47) + 1);
                    String nodeXPath = String.valueOf(commonXPath) + "[" + (i + 1) + "]" + localXPath;
                    String value = (String)xpath.evaluate(nodeXPath, result.item(i), XPathConstants.STRING);
                    logger.log(POILogger.DEBUG, (Object)("Extracting with xpath " + nodeXPath + " : value is '" + value + "'"));
                    XSSFRow row = (XSSFRow)table.getXSSFSheet().getRow(rowId);
                    if (row == null) {
                        row = (XSSFRow)table.getXSSFSheet().createRow(rowId);
                    }
                    if ((cell = (XSSFCell)row.getCell(columnId)) == null) {
                        cell = (XSSFCell)row.createCell(columnId);
                    }
                    logger.log(POILogger.DEBUG, (Object)("Setting '" + value + "' to cell " + cell.getColumnIndex() + "-" + cell.getRowIndex() + " in sheet " + table.getXSSFSheet().getSheetName()));
                    cell.setCellValue(value.trim());
                }
                ++i;
            }
        }
    }

    private static final class DefaultNamespaceContext
    implements NamespaceContext {
        private final Element _docElem;

        public DefaultNamespaceContext(Document doc) {
            this._docElem = doc.getDocumentElement();
        }

        public String getNamespaceURI(String prefix) {
            return this.getNamespaceForPrefix(prefix);
        }

        private String getNamespaceForPrefix(String prefix) {
            if (prefix.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            Node parent = this._docElem;
            while (parent != null) {
                short type = parent.getNodeType();
                if (type == 1) {
                    if (parent.getNodeName().startsWith(String.valueOf(prefix) + ":")) {
                        return parent.getNamespaceURI();
                    }
                    NamedNodeMap nnm = parent.getAttributes();
                    int i = 0;
                    while (i < nnm.getLength()) {
                        Node attr = nnm.item(i);
                        String aname = attr.getNodeName();
                        boolean isPrefix = aname.startsWith("xmlns:");
                        if (isPrefix || aname.equals("xmlns")) {
                            String p;
                            int index = aname.indexOf(58);
                            String string = p = isPrefix ? aname.substring(index + 1) : "";
                            if (p.equals(prefix)) {
                                return attr.getNodeValue();
                            }
                        }
                        ++i;
                    }
                } else {
                    if (type != 5) break;
                    continue;
                }
                parent = parent.getParentNode();
            }
            return null;
        }

        public Iterator getPrefixes(String val) {
            return null;
        }

        public String getPrefix(String uri) {
            return null;
        }
    }
}

