/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xslf.usermodel.Placeholder;
import org.apache.poi.xslf.usermodel.SlideLayout;
import org.apache.poi.xslf.usermodel.XSLFBackground;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColorMapping;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextListStyle;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackground;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideMaster;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideMasterTextStyles;
import org.openxmlformats.schemas.presentationml.x2006.main.SldMasterDocument;

public class XSLFSlideMaster
extends XSLFSheet {
    private CTSlideMaster _slide;
    private Map _layouts;
    private XSLFTheme _theme;

    XSLFSlideMaster() {
        this._slide = CTSlideMaster.Factory.newInstance();
    }

    protected XSLFSlideMaster(PackagePart part, PackageRelationship rel) throws IOException, XmlException {
        super(part, rel);
        SldMasterDocument doc = SldMasterDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
        this._slide = doc.getSldMaster();
        this.setCommonSlideData(this._slide.getCSld());
    }

    public XmlObject getXmlObject() {
        return this._slide;
    }

    protected String getRootElementName() {
        return "sldMaster";
    }

    public XSLFSheet getMasterSheet() {
        return null;
    }

    private Map getLayouts() {
        if (this._layouts == null) {
            this._layouts = new HashMap();
            Iterator iterator = this.getRelations().iterator();
            while (iterator.hasNext()) {
                POIXMLDocumentPart p = (POIXMLDocumentPart)iterator.next();
                if (!(p instanceof XSLFSlideLayout)) continue;
                XSLFSlideLayout layout = (XSLFSlideLayout)p;
                this._layouts.put(layout.getName().toLowerCase(), layout);
            }
        }
        return this._layouts;
    }

    public XSLFSlideLayout[] getSlideLayouts() {
        return this.getLayouts().values().toArray(new XSLFSlideLayout[this._layouts.size()]);
    }

    public XSLFSlideLayout getLayout(SlideLayout type) {
        Iterator iterator = this.getLayouts().values().iterator();
        while (iterator.hasNext()) {
            XSLFSlideLayout layout = (XSLFSlideLayout)iterator.next();
            if (layout.getType() != type) continue;
            return layout;
        }
        return null;
    }

    public XSLFTheme getTheme() {
        if (this._theme == null) {
            Iterator iterator = this.getRelations().iterator();
            while (iterator.hasNext()) {
                POIXMLDocumentPart p = (POIXMLDocumentPart)iterator.next();
                if (!(p instanceof XSLFTheme)) continue;
                this._theme = (XSLFTheme)p;
                CTColorMapping cmap = this._slide.getClrMap();
                if (cmap == null) break;
                this._theme.initColorMap(cmap);
                break;
            }
        }
        return this._theme;
    }

    protected CTTextListStyle getTextProperties(Placeholder textType) {
        CTSlideMasterTextStyles txStyles = ((CTSlideMaster)this.getXmlObject()).getTxStyles();
        CTTextListStyle props = Placeholder.TITLE.equals(textType) || Placeholder.CENTERED_TITLE.equals(textType) || Placeholder.SUBTITLE.equals(textType) ? txStyles.getTitleStyle() : (Placeholder.BODY.equals(textType) ? txStyles.getBodyStyle() : txStyles.getOtherStyle());
        return props;
    }

    protected boolean canDraw(XSLFShape shape) {
        XSLFSimpleShape txt;
        CTPlaceholder ph;
        return !(shape instanceof XSLFSimpleShape) || (ph = (txt = (XSLFSimpleShape)shape).getCTPlaceholder()) == null;
    }

    public XSLFBackground getBackground() {
        CTBackground bg = this._slide.getCSld().getBg();
        if (bg != null) {
            return new XSLFBackground(bg, (XSLFSheet)this);
        }
        return null;
    }
}

