/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ExcelStyleDateFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public class DataFormatter {
    private static final Pattern numPattern = Pattern.compile("[0#]+");
    private static final Pattern daysAsText = Pattern.compile("([d]{3,})", 2);
    private static final Pattern amPmPattern = Pattern.compile("((A|P)[M/P]*)", 2);
    private static final Pattern specialPatternGroup = Pattern.compile("(\\[\\$[^-\\]]*-[0-9A-Z]+\\])");
    private static final Pattern colorPattern = Pattern.compile("(\\[BLACK\\])|(\\[BLUE\\])|(\\[CYAN\\])|(\\[GREEN\\])|(\\[MAGENTA\\])|(\\[RED\\])|(\\[WHITE\\])|(\\[YELLOW\\])|(\\[COLOR\\s*\\d\\])|(\\[COLOR\\s*[0-5]\\d\\])", 2);
    private static final String invalidDateTimeString;
    private final DecimalFormatSymbols decimalSymbols;
    private final DateFormatSymbols dateSymbols;
    private final Format generalWholeNumFormat;
    private final Format generalDecimalNumFormat;
    private Format defaultNumFormat;
    private final Map formats;
    private boolean emulateCsv = false;

    static {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < 255) {
            buf.append('#');
            ++i;
        }
        invalidDateTimeString = buf.toString();
    }

    public DataFormatter() {
        this(false);
    }

    public DataFormatter(boolean emulateCsv) {
        this(Locale.getDefault());
        this.emulateCsv = emulateCsv;
    }

    public DataFormatter(Locale locale, boolean emulateCsv) {
        this(locale);
        this.emulateCsv = emulateCsv;
    }

    public DataFormatter(Locale locale) {
        this.dateSymbols = new DateFormatSymbols(locale);
        this.decimalSymbols = new DecimalFormatSymbols(locale);
        this.generalWholeNumFormat = new DecimalFormat("#", this.decimalSymbols);
        this.generalDecimalNumFormat = new DecimalFormat("#.##########", this.decimalSymbols);
        this.formats = new HashMap();
        Format zipFormat = ZipPlusFourFormat.instance;
        this.addFormat("00000\\-0000", zipFormat);
        this.addFormat("00000-0000", zipFormat);
        Format phoneFormat = PhoneFormat.instance;
        this.addFormat("[<=9999999]###\\-####;\\(###\\)\\ ###\\-####", phoneFormat);
        this.addFormat("[<=9999999]###-####;(###) ###-####", phoneFormat);
        this.addFormat("###\\-####;\\(###\\)\\ ###\\-####", phoneFormat);
        this.addFormat("###-####;(###) ###-####", phoneFormat);
        Format ssnFormat = SSNFormat.instance;
        this.addFormat("000\\-00\\-0000", ssnFormat);
        this.addFormat("000-00-0000", ssnFormat);
    }

    private Format getFormat(Cell cell) {
        if (cell.getCellStyle() == null) {
            return null;
        }
        short formatIndex = cell.getCellStyle().getDataFormat();
        String formatStr = cell.getCellStyle().getDataFormatString();
        if (formatStr == null || formatStr.trim().length() == 0) {
            return null;
        }
        return this.getFormat(cell.getNumericCellValue(), formatIndex, formatStr);
    }

    private Format getFormat(double cellValue, int formatIndex, String formatStrIn) {
        Format format;
        String formatStr = formatStrIn;
        int firstAt = formatStr.indexOf(59);
        int lastAt = formatStr.lastIndexOf(59);
        if (firstAt != -1 && firstAt != lastAt) {
            int secondAt = formatStr.indexOf(59, firstAt + 1);
            formatStr = secondAt == lastAt ? (cellValue == 0.0 ? formatStr.substring(lastAt + 1) : formatStr.substring(0, lastAt)) : (cellValue == 0.0 ? formatStr.substring(secondAt + 1, lastAt) : formatStr.substring(0, secondAt));
        }
        if (this.emulateCsv && cellValue == 0.0 && formatStr.indexOf("#") >= 0 && formatStr.indexOf("0") < 0) {
            formatStr = formatStr.replaceAll("#", "");
        }
        if ((format = (Format)this.formats.get(formatStr)) != null) {
            return format;
        }
        if ("General".equalsIgnoreCase(formatStr) || "@".equals(formatStr)) {
            if (DataFormatter.isWholeNumber(cellValue)) {
                return this.generalWholeNumFormat;
            }
            return this.generalDecimalNumFormat;
        }
        format = this.createFormat(cellValue, formatIndex, formatStr);
        this.formats.put(formatStr, format);
        return format;
    }

    public Format createFormat(Cell cell) {
        short formatIndex = cell.getCellStyle().getDataFormat();
        String formatStr = cell.getCellStyle().getDataFormatString();
        return this.createFormat(cell.getNumericCellValue(), formatIndex, formatStr);
    }

    private Format createFormat(double cellValue, int formatIndex, String sFormat) {
        String formatStr = sFormat;
        Matcher colourM = colorPattern.matcher(formatStr);
        while (colourM.find()) {
            String nFormatStr;
            String colour = colourM.group();
            int at = formatStr.indexOf(colour);
            if (at == -1 || (nFormatStr = String.valueOf(formatStr.substring(0, at)) + formatStr.substring(at + colour.length())).equals(formatStr)) break;
            formatStr = nFormatStr;
            colourM = colorPattern.matcher(formatStr);
        }
        Matcher m = specialPatternGroup.matcher(formatStr);
        while (m.find()) {
            String match = m.group();
            String symbol = match.substring(match.indexOf(36) + 1, match.indexOf(45));
            if (symbol.indexOf(36) > -1) {
                StringBuffer sb = new StringBuffer();
                sb.append(symbol.substring(0, symbol.indexOf(36)));
                sb.append('\\');
                sb.append(symbol.substring(symbol.indexOf(36), symbol.length()));
                symbol = sb.toString();
            }
            formatStr = m.replaceAll(symbol);
            m = specialPatternGroup.matcher(formatStr);
        }
        if (formatStr == null || formatStr.trim().length() == 0) {
            return this.getDefaultFormat(cellValue);
        }
        if (DateUtil.isADateFormat(formatIndex, formatStr) && DateUtil.isValidExcelDate(cellValue)) {
            return this.createDateFormat(formatStr, cellValue);
        }
        if (formatStr.indexOf("-") < 0 && formatStr.indexOf("#/#") >= 0 && formatStr.indexOf("#/#") == formatStr.lastIndexOf("#/#") || formatStr.indexOf("?/?") >= 0 && formatStr.indexOf("?/?") == formatStr.lastIndexOf("?/?")) {
            return new FractionFormat(formatStr);
        }
        if (numPattern.matcher(formatStr).find()) {
            return this.createNumberFormat(formatStr, cellValue);
        }
        if (this.emulateCsv) {
            return new ConstantStringFormat(this.cleanFormatForNumber(formatStr));
        }
        return null;
    }

    private Format createDateFormat(String pFormatStr, double cellValue) {
        String formatStr = pFormatStr;
        formatStr = formatStr.replaceAll("\\\\-", "-");
        formatStr = formatStr.replaceAll("\\\\,", ",");
        formatStr = formatStr.replaceAll("\\\\\\.", ".");
        formatStr = formatStr.replaceAll("\\\\ ", " ");
        formatStr = formatStr.replaceAll("\\\\/", "/");
        formatStr = formatStr.replaceAll(";@", "");
        formatStr = formatStr.replaceAll("\"/\"", "/");
        boolean hasAmPm = false;
        Matcher amPmMatcher = amPmPattern.matcher(formatStr);
        while (amPmMatcher.find()) {
            formatStr = amPmMatcher.replaceAll("@");
            hasAmPm = true;
            amPmMatcher = amPmPattern.matcher(formatStr);
        }
        Matcher dateMatcher = daysAsText.matcher(formatStr = formatStr.replaceAll("@", "a"));
        if (dateMatcher.find()) {
            String match = dateMatcher.group(0);
            formatStr = dateMatcher.replaceAll(match.toUpperCase().replaceAll("D", "E"));
        }
        StringBuffer sb = new StringBuffer();
        char[] chars = formatStr.toCharArray();
        boolean mIsMonth = true;
        ArrayList<Integer> ms = new ArrayList<Integer>();
        boolean isElapsed = false;
        int j = 0;
        while (j < chars.length) {
            char c = chars[j];
            if (c == '[' && !isElapsed) {
                isElapsed = true;
                mIsMonth = false;
                sb.append(c);
            } else if (c == ']' && isElapsed) {
                isElapsed = false;
                sb.append(c);
            } else if (isElapsed) {
                if (c == 'h' || c == 'H') {
                    sb.append('H');
                } else if (c == 'm' || c == 'M') {
                    sb.append('m');
                } else if (c == 's' || c == 'S') {
                    sb.append('s');
                } else {
                    sb.append(c);
                }
            } else if (c == 'h' || c == 'H') {
                mIsMonth = false;
                if (hasAmPm) {
                    sb.append('h');
                } else {
                    sb.append('H');
                }
            } else if (c == 'm' || c == 'M') {
                if (mIsMonth) {
                    sb.append('M');
                    ms.add(new Integer(sb.length() - 1));
                } else {
                    sb.append('m');
                }
            } else if (c == 's' || c == 'S') {
                sb.append('s');
                int i = 0;
                while (i < ms.size()) {
                    int index = (Integer)ms.get(i);
                    if (sb.charAt(index) == 'M') {
                        sb.replace(index, index + 1, "m");
                    }
                    ++i;
                }
                mIsMonth = true;
                ms.clear();
            } else if (Character.isLetter(c)) {
                mIsMonth = true;
                ms.clear();
                if (c == 'y' || c == 'Y') {
                    sb.append('y');
                } else if (c == 'd' || c == 'D') {
                    sb.append('d');
                } else {
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            ++j;
        }
        formatStr = sb.toString();
        try {
            return new ExcelStyleDateFormatter(formatStr, this.dateSymbols);
        }
        catch (IllegalArgumentException iae) {
            return this.getDefaultFormat(cellValue);
        }
    }

    private String cleanFormatForNumber(String formatStr) {
        char c;
        int i;
        StringBuffer sb = new StringBuffer(formatStr);
        if (this.emulateCsv) {
            i = 0;
            while (i < sb.length()) {
                c = sb.charAt(i);
                if (!(c != '_' && c != '*' && c != '?' || i > 0 && sb.charAt(i - 1) == '\\')) {
                    if (c == '?') {
                        sb.setCharAt(i, ' ');
                    } else if (i < sb.length() - 1) {
                        if (c == '_') {
                            sb.setCharAt(i + 1, ' ');
                        } else {
                            sb.deleteCharAt(i + 1);
                        }
                        sb.deleteCharAt(i);
                    }
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < sb.length()) {
                c = sb.charAt(i);
                if (!(c != '_' && c != '*' || i > 0 && sb.charAt(i - 1) == '\\')) {
                    if (i < sb.length() - 1) {
                        sb.deleteCharAt(i + 1);
                    }
                    sb.deleteCharAt(i);
                }
                ++i;
            }
        }
        i = 0;
        while (i < sb.length()) {
            c = sb.charAt(i);
            if (c == '\\' || c == '\"') {
                sb.deleteCharAt(i);
                --i;
            } else if (c == '+' && i > 0 && sb.charAt(i - 1) == 'E') {
                sb.deleteCharAt(i);
                --i;
            }
            ++i;
        }
        return sb.toString();
    }

    private Format createNumberFormat(String formatStr, double cellValue) {
        String format = this.cleanFormatForNumber(formatStr);
        try {
            DecimalFormat df = new DecimalFormat(format, this.decimalSymbols);
            DataFormatter.setExcelStyleRoundingMode(df);
            return df;
        }
        catch (IllegalArgumentException iae) {
            return this.getDefaultFormat(cellValue);
        }
    }

    private static boolean isWholeNumber(double d) {
        return d == Math.floor(d);
    }

    public Format getDefaultFormat(Cell cell) {
        return this.getDefaultFormat(cell.getNumericCellValue());
    }

    private Format getDefaultFormat(double cellValue) {
        if (this.defaultNumFormat != null) {
            return this.defaultNumFormat;
        }
        if (DataFormatter.isWholeNumber(cellValue)) {
            return this.generalWholeNumFormat;
        }
        return this.generalDecimalNumFormat;
    }

    private String performDateFormatting(Date d, Format dateFormat) {
        if (dateFormat != null) {
            return dateFormat.format(d);
        }
        return d.toString();
    }

    private String getFormattedDateString(Cell cell) {
        Format dateFormat = this.getFormat(cell);
        if (dateFormat instanceof ExcelStyleDateFormatter) {
            ((ExcelStyleDateFormatter)dateFormat).setDateToBeFormatted(cell.getNumericCellValue());
        }
        Date d = cell.getDateCellValue();
        return this.performDateFormatting(d, dateFormat);
    }

    private String getFormattedNumberString(Cell cell) {
        Format numberFormat = this.getFormat(cell);
        double d = cell.getNumericCellValue();
        if (numberFormat == null) {
            return String.valueOf(d);
        }
        return numberFormat.format(new Double(d));
    }

    public String formatRawCellContents(double value, int formatIndex, String formatString) {
        return this.formatRawCellContents(value, formatIndex, formatString, false);
    }

    public String formatRawCellContents(double value, int formatIndex, String formatString, boolean use1904Windowing) {
        Format numberFormat;
        if (DateUtil.isADateFormat(formatIndex, formatString)) {
            if (DateUtil.isValidExcelDate(value)) {
                Format dateFormat = this.getFormat(value, formatIndex, formatString);
                if (dateFormat instanceof ExcelStyleDateFormatter) {
                    ((ExcelStyleDateFormatter)dateFormat).setDateToBeFormatted(value);
                }
                Date d = DateUtil.getJavaDate(value, use1904Windowing);
                return this.performDateFormatting(d, dateFormat);
            }
            if (this.emulateCsv) {
                return invalidDateTimeString;
            }
        }
        if ((numberFormat = this.getFormat(value, formatIndex, formatString)) == null) {
            return String.valueOf(value);
        }
        String result = numberFormat.format(new Double(value));
        if (result.indexOf("E") >= 0 && result.indexOf("E-") < 0) {
            result = result.replaceFirst("E", "E+");
        }
        return result;
    }

    public String formatCellValue(Cell cell) {
        return this.formatCellValue(cell, null);
    }

    public String formatCellValue(Cell cell, FormulaEvaluator evaluator) {
        if (cell == null) {
            return "";
        }
        int cellType = cell.getCellType();
        if (cellType == 2) {
            if (evaluator == null) {
                return cell.getCellFormula();
            }
            cellType = evaluator.evaluateFormulaCell(cell);
        }
        switch (cellType) {
            case 0: {
                if (DateUtil.isCellDateFormatted(cell)) {
                    return this.getFormattedDateString(cell);
                }
                return this.getFormattedNumberString(cell);
            }
            case 1: {
                return cell.getRichStringCellValue().getString();
            }
            case 4: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case 3: {
                return "";
            }
        }
        throw new RuntimeException("Unexpected celltype (" + cellType + ")");
    }

    public void setDefaultNumberFormat(Format format) {
        Iterator itr = this.formats.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            if (entry.getValue() != this.generalDecimalNumFormat && entry.getValue() != this.generalWholeNumFormat) continue;
            entry.setValue(format);
        }
        this.defaultNumFormat = format;
    }

    public void addFormat(String excelFormatStr, Format format) {
        this.formats.put(excelFormatStr, format);
    }

    static DecimalFormat createIntegerOnlyFormat(String fmt) {
        DecimalFormat result = new DecimalFormat(fmt);
        result.setParseIntegerOnly(true);
        return result;
    }

    public static void setExcelStyleRoundingMode(DecimalFormat format) {
        DataFormatter.setExcelStyleRoundingMode(format, 4);
    }

    public static void setExcelStyleRoundingMode(DecimalFormat format, int roundingMode) {
    }

    private static final class ConstantStringFormat
    extends Format {
        private static final DecimalFormat df = DataFormatter.createIntegerOnlyFormat("##########");
        private final String str;

        public ConstantStringFormat(String s) {
            this.str = s;
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(this.str);
        }

        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }

    private static final class FractionFormat
    extends Format {
        private final String str;

        public FractionFormat(String s) {
            this.str = s;
        }

        public String format(Number num) {
            double decPart;
            double wholePart = Math.floor(num.doubleValue());
            if (wholePart + (decPart = num.doubleValue() - wholePart) == 0.0) {
                return "0";
            }
            String[] parts = this.str.split(" ");
            String[] fractParts = parts.length == 2 ? parts[1].split("/") : this.str.split("/");
            int i = 0;
            while (i < fractParts.length) {
                fractParts[i] = fractParts[i].replace('?', '#');
                ++i;
            }
            if (fractParts.length == 2) {
                double minVal = 1.0;
                double currDenom = Math.pow(10.0, fractParts[1].length()) - 1.0;
                double currNeum = 0.0;
                int i2 = (int)(Math.pow(10.0, fractParts[1].length()) - 1.0);
                while (i2 > 0) {
                    int i22 = (int)(Math.pow(10.0, fractParts[1].length()) - 1.0);
                    while (i22 > 0) {
                        if (minVal >= Math.abs((double)i22 / (double)i2 - decPart)) {
                            currDenom = i2;
                            currNeum = i22;
                            minVal = Math.abs((double)i22 / (double)i2 - decPart);
                        }
                        --i22;
                    }
                    --i2;
                }
                DecimalFormat neumFormatter = new DecimalFormat(fractParts[0]);
                DecimalFormat denomFormatter = new DecimalFormat(fractParts[1]);
                if (parts.length == 2) {
                    DecimalFormat wholeFormatter = new DecimalFormat(parts[0]);
                    String result = String.valueOf(wholeFormatter.format(wholePart)) + " " + neumFormatter.format(currNeum) + "/" + denomFormatter.format(currDenom);
                    return result;
                }
                String result = String.valueOf(neumFormatter.format(currNeum + currDenom * wholePart)) + "/" + denomFormatter.format(currDenom);
                return result;
            }
            throw new IllegalArgumentException("Fraction must have 2 parts, found " + fractParts.length + " for fraction format " + this.str);
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(this.format((Number)obj));
        }

        public Object parseObject(String source, ParsePosition pos) {
            throw new NotImplementedException("Reverse parsing not supported");
        }
    }

    private static final class PhoneFormat
    extends Format {
        public static final Format instance = new PhoneFormat();
        private static final DecimalFormat df = DataFormatter.createIntegerOnlyFormat("##########");

        private PhoneFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            StringBuffer sb = new StringBuffer();
            int len = result.length();
            if (len <= 4) {
                return result;
            }
            String seg3 = result.substring(len - 4, len);
            String seg2 = result.substring(Math.max(0, len - 7), len - 4);
            String seg1 = result.substring(Math.max(0, len - 10), Math.max(0, len - 7));
            if (seg1 != null && seg1.trim().length() > 0) {
                sb.append('(').append(seg1).append(") ");
            }
            if (seg2 != null && seg2.trim().length() > 0) {
                sb.append(seg2).append('-');
            }
            sb.append(seg3);
            return sb.toString();
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(PhoneFormat.format((Number)obj));
        }

        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }

    private static final class SSNFormat
    extends Format {
        public static final Format instance = new SSNFormat();
        private static final DecimalFormat df = DataFormatter.createIntegerOnlyFormat("000000000");

        private SSNFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            StringBuffer sb = new StringBuffer();
            sb.append(result.substring(0, 3)).append('-');
            sb.append(result.substring(3, 5)).append('-');
            sb.append(result.substring(5, 9));
            return sb.toString();
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(SSNFormat.format((Number)obj));
        }

        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }

    private static final class ZipPlusFourFormat
    extends Format {
        public static final Format instance = new ZipPlusFourFormat();
        private static final DecimalFormat df = DataFormatter.createIntegerOnlyFormat("000000000");

        private ZipPlusFourFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            StringBuffer sb = new StringBuffer();
            sb.append(result.substring(0, 5)).append('-');
            sb.append(result.substring(5, 9));
            return sb.toString();
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(ZipPlusFourFormat.format((Number)obj));
        }

        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }
}

