/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.dev;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.Types;

public class TypesLister {
    public void listByName(PrintStream out) {
        ArrayList all = new ArrayList(MAPIProperty.getAll());
        Collections.sort(all, new Comparator(){

            public int compare(Object in_a, Object in_b) {
                MAPIProperty a = (MAPIProperty)in_a;
                MAPIProperty b = (MAPIProperty)in_b;
                return a.name.compareTo(b.name);
            }
        });
        this.list(all, out);
    }

    public void listById(PrintStream out) {
        ArrayList all = new ArrayList(MAPIProperty.getAll());
        Collections.sort(all, new Comparator(){

            public int compare(Object in_a, Object in_b) {
                MAPIProperty a = (MAPIProperty)in_a;
                MAPIProperty b = (MAPIProperty)in_b;
                if (a.id < b.id) {
                    return -1;
                }
                if (a.id > b.id) {
                    return 1;
                }
                return 0;
            }
        });
        this.list(all, out);
    }

    private void list(ArrayList list, PrintStream out) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MAPIProperty attr = (MAPIProperty)iterator.next();
            String id = Integer.toHexString(attr.id);
            while (id.length() < 4) {
                id = "0" + id;
            }
            out.println("0x" + id + " - " + attr.name);
            out.println("   " + attr.id + " - " + Types.asName(attr.usualType) + " (" + attr.usualType + ") - " + attr.mapiProperty);
        }
    }

    public static void main(String[] args) {
        TypesLister lister = new TypesLister();
        lister.listByName(System.out);
        System.out.println();
        lister.listById(System.out);
    }
}

