/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.extractor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import org.apache.poi.POIDocument;
import org.apache.poi.POIOLE2TextExtractor;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.StringUtil;

public class OutlookTextExtactor
extends POIOLE2TextExtractor {
    public OutlookTextExtactor(MAPIMessage msg) {
        super((POIDocument)msg);
    }

    public OutlookTextExtactor(DirectoryNode poifsDir, POIFSFileSystem fs) throws IOException {
        this(new MAPIMessage(poifsDir, fs));
    }

    public OutlookTextExtactor(DirectoryNode poifsDir) throws IOException {
        this(new MAPIMessage(poifsDir));
    }

    public OutlookTextExtactor(POIFSFileSystem fs) throws IOException {
        this(new MAPIMessage(fs));
    }

    public OutlookTextExtactor(NPOIFSFileSystem fs) throws IOException {
        this(new MAPIMessage(fs));
    }

    public OutlookTextExtactor(InputStream inp) throws IOException {
        this(new MAPIMessage(inp));
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            String filename = args[i];
            OutlookTextExtactor extractor = new OutlookTextExtactor(new NPOIFSFileSystem(new File(filename)));
            System.out.println(extractor.getText());
            ++i;
        }
    }

    public MAPIMessage getMAPIMessage() {
        return (MAPIMessage)this.document;
    }

    public String getText() {
        StringUtil.StringsIterator emails;
        MAPIMessage msg = (MAPIMessage)this.document;
        StringBuffer s = new StringBuffer();
        msg.guess7BitEncoding();
        try {
            emails = new StringUtil.StringsIterator(msg.getRecipientEmailAddressList());
        }
        catch (ChunkNotFoundException e) {
            emails = new StringUtil.StringsIterator(new String[0]);
        }
        try {
            s.append("From: " + msg.getDisplayFrom() + "\n");
        }
        catch (ChunkNotFoundException e) {
            // empty catch block
        }
        try {
            this.handleEmails(s, "To", msg.getDisplayTo(), emails);
        }
        catch (ChunkNotFoundException e) {
            // empty catch block
        }
        try {
            this.handleEmails(s, "CC", msg.getDisplayCC(), emails);
        }
        catch (ChunkNotFoundException e) {
            // empty catch block
        }
        try {
            this.handleEmails(s, "BCC", msg.getDisplayBCC(), emails);
        }
        catch (ChunkNotFoundException e) {
            // empty catch block
        }
        try {
            SimpleDateFormat f = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss");
            s.append("Date: " + f.format(msg.getMessageDate().getTime()) + "\n");
        }
        catch (ChunkNotFoundException e) {
            try {
                String[] headers = msg.getHeaders();
                int i = 0;
                while (i < headers.length) {
                    String header = headers[i];
                    if (header.toLowerCase().startsWith("date:")) {
                        s.append("Date:" + header.substring(header.indexOf(58) + 1) + "\n");
                    }
                    ++i;
                }
            }
            catch (ChunkNotFoundException headers) {
                // empty catch block
            }
        }
        try {
            s.append("Subject: " + msg.getSubject() + "\n");
        }
        catch (ChunkNotFoundException e) {
            // empty catch block
        }
        int i = 0;
        while (i < msg.getAttachmentFiles().length) {
            AttachmentChunks att = msg.getAttachmentFiles()[i];
            String ats = att.attachLongFileName.getValue();
            if (att.attachMimeTag != null && att.attachMimeTag.getValue() != null) {
                ats = String.valueOf(att.attachMimeTag.getValue()) + " = " + ats;
            }
            s.append("Attachment: " + ats + "\n");
            ++i;
        }
        try {
            s.append("\n" + msg.getTextBody() + "\n");
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            // empty catch block
        }
        return s.toString();
    }

    protected void handleEmails(StringBuffer s, String type, String displayText, StringUtil.StringsIterator emails) {
        if (displayText == null || displayText.length() == 0) {
            return;
        }
        String[] names = displayText.split(";\\s*");
        boolean first = true;
        s.append(String.valueOf(type) + ": ");
        int i = 0;
        while (i < names.length) {
            String email;
            String name = names[i];
            if (first) {
                first = false;
            } else {
                s.append("; ");
            }
            s.append(name);
            if (emails.hasNext() && !(email = (String)emails.next()).equals(name)) {
                s.append(" <" + email + ">");
            }
            ++i;
        }
        s.append("\n");
    }
}

