/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.hwpf.model.CharIndexTranslator;
import org.apache.poi.hwpf.model.PropertyNode;

public abstract class BytePropertyNode
extends PropertyNode {
    private final int startBytes;
    private final int endBytes;

    public BytePropertyNode(int fcStart, int fcEnd, CharIndexTranslator translator, Object buf) {
        super(translator.getCharIndex(fcStart), translator.getCharIndex(fcEnd, translator.getCharIndex(fcStart)), buf);
        if (fcStart > fcEnd) {
            throw new IllegalArgumentException("fcStart (" + fcStart + ") > fcEnd (" + fcEnd + ")");
        }
        this.startBytes = fcStart;
        this.endBytes = fcEnd;
    }

    public BytePropertyNode(int charStart, int charEnd, Object buf) {
        super(charStart, charEnd, buf);
        if (charStart > charEnd) {
            throw new IllegalArgumentException("charStart (" + charStart + ") > charEnd (" + charEnd + ")");
        }
        this.startBytes = -1;
        this.endBytes = -1;
    }

    public int getStartBytes() {
        return this.startBytes;
    }

    public int getEndBytes() {
        return this.endBytes;
    }
}

