/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

public class PictureType {
    public static final PictureType BMP = new PictureType("image/bmp", "bmp", new byte[][]{{66, 77}});
    public static final PictureType EMF;
    public static final PictureType GIF;
    public static final PictureType JPEG;
    public static final PictureType PICT;
    public static final PictureType PNG;
    public static final PictureType TIFF;
    public static final PictureType UNKNOWN;
    public static final PictureType WMF;
    public static PictureType[] values;
    private String _extension;
    private String _mime;
    private byte[][] _signatures;

    static {
        byte[][] byArrayArray = new byte[1][];
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        byArrayArray[0] = byArray;
        EMF = new PictureType("image/x-emf", "emf", byArrayArray);
        GIF = new PictureType("image/gif", "gif", new byte[][]{{71, 73, 70}});
        JPEG = new PictureType("image/jpeg", "jpg", new byte[][]{{-1, -40}});
        PICT = new PictureType("image/pict", ".pict", new byte[0][]);
        PNG = new PictureType("image/png", "png", new byte[][]{{-119, 80, 78, 71, 13, 10, 26, 10}});
        byte[][] byArrayArray2 = new byte[2][];
        byte[] byArray2 = new byte[4];
        byArray2[0] = 73;
        byArray2[1] = 73;
        byArray2[2] = 42;
        byArrayArray2[0] = byArray2;
        byte[] byArray3 = new byte[4];
        byArray3[0] = 77;
        byArray3[1] = 77;
        byArray3[3] = 42;
        byArrayArray2[1] = byArray3;
        TIFF = new PictureType("image/tiff", "tiff", byArrayArray2);
        UNKNOWN = new PictureType("image/unknown", "", new byte[0][]);
        byte[][] byArrayArray3 = new byte[2][];
        byte[] byArray4 = new byte[6];
        byArray4[0] = -41;
        byArray4[1] = -51;
        byArray4[2] = -58;
        byArray4[3] = -102;
        byArrayArray3[0] = byArray4;
        byte[] byArray5 = new byte[6];
        byArray5[0] = 1;
        byArray5[2] = 9;
        byArray5[5] = 3;
        byArrayArray3[1] = byArray5;
        WMF = new PictureType("image/x-wmf", "wmf", byArrayArray3);
        values = new PictureType[]{BMP, EMF, GIF, JPEG, PICT, PNG, TIFF, UNKNOWN, WMF};
    }

    public static PictureType findMatchingType(byte[] pictureContent) {
        int i = 0;
        while (i < values.length) {
            PictureType pictureType = values[i];
            int j = 0;
            while (j < pictureType.getSignatures().length) {
                byte[] signature = pictureType.getSignatures()[j];
                if (PictureType.matchSignature(pictureContent, signature)) {
                    return pictureType;
                }
                ++j;
            }
            ++i;
        }
        return UNKNOWN;
    }

    private static boolean matchSignature(byte[] pictureData, byte[] signature) {
        if (pictureData.length < signature.length) {
            return false;
        }
        int i = 0;
        while (i < signature.length) {
            if (pictureData[i] != signature[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private PictureType(String mime, String extension, byte[][] signatures) {
        this._mime = mime;
        this._extension = extension;
        this._signatures = signatures;
    }

    public String getExtension() {
        return this._extension;
    }

    public String getMime() {
        return this._mime;
    }

    public byte[][] getSignatures() {
        return this._signatures;
    }

    public boolean matchSignature(byte[] pictureData) {
        int i = 0;
        while (i < this.getSignatures().length) {
            byte[] signature = this.getSignatures()[i];
            if (PictureType.matchSignature(signature, pictureData)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

